/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Container implements SdkPojo, Serializable, ToCopyableBuilder<Container.Builder, Container> {
    private static final SdkField<String> CONTAINER_RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerRuntime").getter(getter(Container::containerRuntime)).setter(setter(Builder::containerRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRuntime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Container::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Container::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Image")
            .getter(getter(Container::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> IMAGE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImagePrefix").getter(getter(Container::imagePrefix)).setter(setter(Builder::imagePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePrefix").build()).build();

    private static final SdkField<List<VolumeMount>> VOLUME_MOUNTS_FIELD = SdkField
            .<List<VolumeMount>> builder(MarshallingType.LIST)
            .memberName("VolumeMounts")
            .getter(getter(Container::volumeMounts))
            .setter(setter(Builder::volumeMounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeMounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeMount> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeMount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SecurityContext> SECURITY_CONTEXT_FIELD = SdkField
            .<SecurityContext> builder(MarshallingType.SDK_POJO).memberName("SecurityContext")
            .getter(getter(Container::securityContext)).setter(setter(Builder::securityContext))
            .constructor(SecurityContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_RUNTIME_FIELD,
            ID_FIELD, NAME_FIELD, IMAGE_FIELD, IMAGE_PREFIX_FIELD, VOLUME_MOUNTS_FIELD, SECURITY_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerRuntime;

    private final String id;

    private final String name;

    private final String image;

    private final String imagePrefix;

    private final List<VolumeMount> volumeMounts;

    private final SecurityContext securityContext;

    private Container(BuilderImpl builder) {
        this.containerRuntime = builder.containerRuntime;
        this.id = builder.id;
        this.name = builder.name;
        this.image = builder.image;
        this.imagePrefix = builder.imagePrefix;
        this.volumeMounts = builder.volumeMounts;
        this.securityContext = builder.securityContext;
    }

    /**
     * <p>
     * The container runtime (such as, Docker or containerd) used to run the container.
     * </p>
     * 
     * @return The container runtime (such as, Docker or containerd) used to run the container.
     */
    public final String containerRuntime() {
        return containerRuntime;
    }

    /**
     * <p>
     * Container ID.
     * </p>
     * 
     * @return Container ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Container name.
     * </p>
     * 
     * @return Container name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Container image.
     * </p>
     * 
     * @return Container image.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * Part of the image name before the last slash. For example, imagePrefix for
     * public.ecr.aws/amazonlinux/amazonlinux:latest would be public.ecr.aws/amazonlinux. If the image name is relative
     * and does not have a slash, this field is empty.
     * </p>
     * 
     * @return Part of the image name before the last slash. For example, imagePrefix for
     *         public.ecr.aws/amazonlinux/amazonlinux:latest would be public.ecr.aws/amazonlinux. If the image name is
     *         relative and does not have a slash, this field is empty.
     */
    public final String imagePrefix() {
        return imagePrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeMounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeMounts() {
        return volumeMounts != null && !(volumeMounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Container volume mounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeMounts} method.
     * </p>
     * 
     * @return Container volume mounts.
     */
    public final List<VolumeMount> volumeMounts() {
        return volumeMounts;
    }

    /**
     * <p>
     * Container security context.
     * </p>
     * 
     * @return Container security context.
     */
    public final SecurityContext securityContext() {
        return securityContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(imagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeMounts() ? volumeMounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container) obj;
        return Objects.equals(containerRuntime(), other.containerRuntime()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(image(), other.image())
                && Objects.equals(imagePrefix(), other.imagePrefix()) && hasVolumeMounts() == other.hasVolumeMounts()
                && Objects.equals(volumeMounts(), other.volumeMounts())
                && Objects.equals(securityContext(), other.securityContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Container").add("ContainerRuntime", containerRuntime()).add("Id", id()).add("Name", name())
                .add("Image", image()).add("ImagePrefix", imagePrefix())
                .add("VolumeMounts", hasVolumeMounts() ? volumeMounts() : null).add("SecurityContext", securityContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerRuntime":
            return Optional.ofNullable(clazz.cast(containerRuntime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "ImagePrefix":
            return Optional.ofNullable(clazz.cast(imagePrefix()));
        case "VolumeMounts":
            return Optional.ofNullable(clazz.cast(volumeMounts()));
        case "SecurityContext":
            return Optional.ofNullable(clazz.cast(securityContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerRuntime", CONTAINER_RUNTIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("imagePrefix", IMAGE_PREFIX_FIELD);
        map.put("volumeMounts", VOLUME_MOUNTS_FIELD);
        map.put("securityContext", SECURITY_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Container> {
        /**
         * <p>
         * The container runtime (such as, Docker or containerd) used to run the container.
         * </p>
         * 
         * @param containerRuntime
         *        The container runtime (such as, Docker or containerd) used to run the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRuntime(String containerRuntime);

        /**
         * <p>
         * Container ID.
         * </p>
         * 
         * @param id
         *        Container ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Container name.
         * </p>
         * 
         * @param name
         *        Container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Container image.
         * </p>
         * 
         * @param image
         *        Container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * Part of the image name before the last slash. For example, imagePrefix for
         * public.ecr.aws/amazonlinux/amazonlinux:latest would be public.ecr.aws/amazonlinux. If the image name is
         * relative and does not have a slash, this field is empty.
         * </p>
         * 
         * @param imagePrefix
         *        Part of the image name before the last slash. For example, imagePrefix for
         *        public.ecr.aws/amazonlinux/amazonlinux:latest would be public.ecr.aws/amazonlinux. If the image name
         *        is relative and does not have a slash, this field is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePrefix(String imagePrefix);

        /**
         * <p>
         * Container volume mounts.
         * </p>
         * 
         * @param volumeMounts
         *        Container volume mounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeMounts(Collection<VolumeMount> volumeMounts);

        /**
         * <p>
         * Container volume mounts.
         * </p>
         * 
         * @param volumeMounts
         *        Container volume mounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeMounts(VolumeMount... volumeMounts);

        /**
         * <p>
         * Container volume mounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeMount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.VolumeMount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeMount.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeMounts(List<VolumeMount>)}.
         * 
         * @param volumeMounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.VolumeMount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeMounts(java.util.Collection<VolumeMount>)
         */
        Builder volumeMounts(Consumer<VolumeMount.Builder>... volumeMounts);

        /**
         * <p>
         * Container security context.
         * </p>
         * 
         * @param securityContext
         *        Container security context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityContext(SecurityContext securityContext);

        /**
         * <p>
         * Container security context.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityContext.Builder} avoiding the
         * need to create one manually via {@link SecurityContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityContext.Builder#build()} is called immediately and its
         * result is passed to {@link #securityContext(SecurityContext)}.
         * 
         * @param securityContext
         *        a consumer that will call methods on {@link SecurityContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityContext(SecurityContext)
         */
        default Builder securityContext(Consumer<SecurityContext.Builder> securityContext) {
            return securityContext(SecurityContext.builder().applyMutation(securityContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String containerRuntime;

        private String id;

        private String name;

        private String image;

        private String imagePrefix;

        private List<VolumeMount> volumeMounts = DefaultSdkAutoConstructList.getInstance();

        private SecurityContext securityContext;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            containerRuntime(model.containerRuntime);
            id(model.id);
            name(model.name);
            image(model.image);
            imagePrefix(model.imagePrefix);
            volumeMounts(model.volumeMounts);
            securityContext(model.securityContext);
        }

        public final String getContainerRuntime() {
            return containerRuntime;
        }

        public final void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        @Override
        public final Builder containerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImagePrefix() {
            return imagePrefix;
        }

        public final void setImagePrefix(String imagePrefix) {
            this.imagePrefix = imagePrefix;
        }

        @Override
        public final Builder imagePrefix(String imagePrefix) {
            this.imagePrefix = imagePrefix;
            return this;
        }

        public final List<VolumeMount.Builder> getVolumeMounts() {
            List<VolumeMount.Builder> result = VolumeMountsCopier.copyToBuilder(this.volumeMounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeMounts(Collection<VolumeMount.BuilderImpl> volumeMounts) {
            this.volumeMounts = VolumeMountsCopier.copyFromBuilder(volumeMounts);
        }

        @Override
        public final Builder volumeMounts(Collection<VolumeMount> volumeMounts) {
            this.volumeMounts = VolumeMountsCopier.copy(volumeMounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(VolumeMount... volumeMounts) {
            volumeMounts(Arrays.asList(volumeMounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(Consumer<VolumeMount.Builder>... volumeMounts) {
            volumeMounts(Stream.of(volumeMounts).map(c -> VolumeMount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SecurityContext.Builder getSecurityContext() {
            return securityContext != null ? securityContext.toBuilder() : null;
        }

        public final void setSecurityContext(SecurityContext.BuilderImpl securityContext) {
            this.securityContext = securityContext != null ? securityContext.build() : null;
        }

        @Override
        public final Builder securityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        @Override
        public Container build() {
            return new Container(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
