/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the installed EKS add-on (GuardDuty security agent).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonDetails implements SdkPojo, Serializable, ToCopyableBuilder<AddonDetails.Builder, AddonDetails> {
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonVersion").getter(getter(AddonDetails::addonVersion)).setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<String> ADDON_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonStatus").getter(getter(AddonDetails::addonStatus)).setter(setter(Builder::addonStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_VERSION_FIELD,
            ADDON_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addonVersion;

    private final String addonStatus;

    private AddonDetails(BuilderImpl builder) {
        this.addonVersion = builder.addonVersion;
        this.addonStatus = builder.addonStatus;
    }

    /**
     * <p>
     * Version of the installed EKS add-on.
     * </p>
     * 
     * @return Version of the installed EKS add-on.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    /**
     * <p>
     * Status of the installed EKS add-on.
     * </p>
     * 
     * @return Status of the installed EKS add-on.
     */
    public final String addonStatus() {
        return addonStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(addonStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonDetails)) {
            return false;
        }
        AddonDetails other = (AddonDetails) obj;
        return Objects.equals(addonVersion(), other.addonVersion()) && Objects.equals(addonStatus(), other.addonStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonDetails").add("AddonVersion", addonVersion()).add("AddonStatus", addonStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "AddonStatus":
            return Optional.ofNullable(clazz.cast(addonStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addonVersion", ADDON_VERSION_FIELD);
        map.put("addonStatus", ADDON_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonDetails, T> g) {
        return obj -> g.apply((AddonDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonDetails> {
        /**
         * <p>
         * Version of the installed EKS add-on.
         * </p>
         * 
         * @param addonVersion
         *        Version of the installed EKS add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * Status of the installed EKS add-on.
         * </p>
         * 
         * @param addonStatus
         *        Status of the installed EKS add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonStatus(String addonStatus);
    }

    static final class BuilderImpl implements Builder {
        private String addonVersion;

        private String addonStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AddonDetails model) {
            addonVersion(model.addonVersion);
            addonStatus(model.addonStatus);
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getAddonStatus() {
            return addonStatus;
        }

        public final void setAddonStatus(String addonStatus) {
            this.addonStatus = addonStatus;
        }

        @Override
        public final Builder addonStatus(String addonStatus) {
            this.addonStatus = addonStatus;
            return this;
        }

        @Override
        public AddonDetails build() {
            return new AddonDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
