/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a process involved in a GuardDuty finding, including process identification, execution
 * details, and file information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActorProcess implements SdkPojo, Serializable, ToCopyableBuilder<ActorProcess.Builder, ActorProcess> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ActorProcess::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(ActorProcess::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sha256")
            .getter(getter(ActorProcess::sha256)).setter(setter(Builder::sha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD,
            SHA256_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String path;

    private final String sha256;

    private ActorProcess(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.sha256 = builder.sha256;
    }

    /**
     * <p>
     * The name of the process as it appears in the system.
     * </p>
     * 
     * @return The name of the process as it appears in the system.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The full file path to the process executable on the system.
     * </p>
     * 
     * @return The full file path to the process executable on the system.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The SHA256 hash of the process executable file, which can be used for identification and verification purposes.
     * </p>
     * 
     * @return The SHA256 hash of the process executable file, which can be used for identification and verification
     *         purposes.
     */
    public final String sha256() {
        return sha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(sha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActorProcess)) {
            return false;
        }
        ActorProcess other = (ActorProcess) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(path(), other.path())
                && Objects.equals(sha256(), other.sha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActorProcess").add("Name", name()).add("Path", path()).add("Sha256", sha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Sha256":
            return Optional.ofNullable(clazz.cast(sha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("path", PATH_FIELD);
        map.put("sha256", SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActorProcess, T> g) {
        return obj -> g.apply((ActorProcess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActorProcess> {
        /**
         * <p>
         * The name of the process as it appears in the system.
         * </p>
         * 
         * @param name
         *        The name of the process as it appears in the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The full file path to the process executable on the system.
         * </p>
         * 
         * @param path
         *        The full file path to the process executable on the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The SHA256 hash of the process executable file, which can be used for identification and verification
         * purposes.
         * </p>
         * 
         * @param sha256
         *        The SHA256 hash of the process executable file, which can be used for identification and verification
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256(String sha256);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String path;

        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(ActorProcess model) {
            name(model.name);
            path(model.path);
            sha256(model.sha256);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSha256() {
            return sha256;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        @Override
        public ActorProcess build() {
            return new ActorProcess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
