/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the actors involved in an attack sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Actor implements SdkPojo, Serializable, ToCopyableBuilder<Actor.Builder, Actor> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Actor::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<User> USER_FIELD = SdkField.<User> builder(MarshallingType.SDK_POJO).memberName("User")
            .getter(getter(Actor::user)).setter(setter(Builder::user)).constructor(User::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<Session> SESSION_FIELD = SdkField.<Session> builder(MarshallingType.SDK_POJO)
            .memberName("Session").getter(getter(Actor::session)).setter(setter(Builder::session)).constructor(Session::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("session").build()).build();

    private static final SdkField<ActorProcess> PROCESS_FIELD = SdkField.<ActorProcess> builder(MarshallingType.SDK_POJO)
            .memberName("Process").getter(getter(Actor::process)).setter(setter(Builder::process))
            .constructor(ActorProcess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("process").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USER_FIELD,
            SESSION_FIELD, PROCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final User user;

    private final Session session;

    private final ActorProcess process;

    private Actor(BuilderImpl builder) {
        this.id = builder.id;
        this.user = builder.user;
        this.session = builder.session;
        this.process = builder.process;
    }

    /**
     * <p>
     * ID of the threat actor.
     * </p>
     * 
     * @return ID of the threat actor.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Contains information about the user credentials used by the threat actor.
     * </p>
     * 
     * @return Contains information about the user credentials used by the threat actor.
     */
    public final User user() {
        return user;
    }

    /**
     * <p>
     * Contains information about the user session where the activity initiated.
     * </p>
     * 
     * @return Contains information about the user session where the activity initiated.
     */
    public final Session session() {
        return session;
    }

    /**
     * <p>
     * Contains information about the process associated with the threat actor. This includes details such as process
     * name, path, execution time, and unique identifiers that help track the actor's activities within the system.
     * </p>
     * 
     * @return Contains information about the process associated with the threat actor. This includes details such as
     *         process name, path, execution time, and unique identifiers that help track the actor's activities within
     *         the system.
     */
    public final ActorProcess process() {
        return process;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        hashCode = 31 * hashCode + Objects.hashCode(process());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Actor)) {
            return false;
        }
        Actor other = (Actor) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(user(), other.user())
                && Objects.equals(session(), other.session()) && Objects.equals(process(), other.process());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Actor").add("Id", id()).add("User", user()).add("Session", session()).add("Process", process())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        case "Process":
            return Optional.ofNullable(clazz.cast(process()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("user", USER_FIELD);
        map.put("session", SESSION_FIELD);
        map.put("process", PROCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Actor, T> g) {
        return obj -> g.apply((Actor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Actor> {
        /**
         * <p>
         * ID of the threat actor.
         * </p>
         * 
         * @param id
         *        ID of the threat actor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Contains information about the user credentials used by the threat actor.
         * </p>
         * 
         * @param user
         *        Contains information about the user credentials used by the threat actor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(User user);

        /**
         * <p>
         * Contains information about the user credentials used by the threat actor.
         * </p>
         * This is a convenience method that creates an instance of the {@link User.Builder} avoiding the need to create
         * one manually via {@link User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link User.Builder#build()} is called immediately and its result is
         * passed to {@link #user(User)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(User)
         */
        default Builder user(Consumer<User.Builder> user) {
            return user(User.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * Contains information about the user session where the activity initiated.
         * </p>
         * 
         * @param session
         *        Contains information about the user session where the activity initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(Session session);

        /**
         * <p>
         * Contains information about the user session where the activity initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Session.Builder} avoiding the need to
         * create one manually via {@link Session#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Session.Builder#build()} is called immediately and its result is
         * passed to {@link #session(Session)}.
         * 
         * @param session
         *        a consumer that will call methods on {@link Session.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #session(Session)
         */
        default Builder session(Consumer<Session.Builder> session) {
            return session(Session.builder().applyMutation(session).build());
        }

        /**
         * <p>
         * Contains information about the process associated with the threat actor. This includes details such as
         * process name, path, execution time, and unique identifiers that help track the actor's activities within the
         * system.
         * </p>
         * 
         * @param process
         *        Contains information about the process associated with the threat actor. This includes details such as
         *        process name, path, execution time, and unique identifiers that help track the actor's activities
         *        within the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder process(ActorProcess process);

        /**
         * <p>
         * Contains information about the process associated with the threat actor. This includes details such as
         * process name, path, execution time, and unique identifiers that help track the actor's activities within the
         * system.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActorProcess.Builder} avoiding the need
         * to create one manually via {@link ActorProcess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActorProcess.Builder#build()} is called immediately and its
         * result is passed to {@link #process(ActorProcess)}.
         * 
         * @param process
         *        a consumer that will call methods on {@link ActorProcess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #process(ActorProcess)
         */
        default Builder process(Consumer<ActorProcess.Builder> process) {
            return process(ActorProcess.builder().applyMutation(process).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private User user;

        private Session session;

        private ActorProcess process;

        private BuilderImpl() {
        }

        private BuilderImpl(Actor model) {
            id(model.id);
            user(model.user);
            session(model.session);
            process(model.process);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final User.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final Session.Builder getSession() {
            return session != null ? session.toBuilder() : null;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final ActorProcess.Builder getProcess() {
            return process != null ? process.toBuilder() : null;
        }

        public final void setProcess(ActorProcess.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        @Override
        public final Builder process(ActorProcess process) {
            this.process = process;
            return this;
        }

        @Override
        public Actor build() {
            return new Actor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
