/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(Action::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<AwsApiCallAction> AWS_API_CALL_ACTION_FIELD = SdkField
            .<AwsApiCallAction> builder(MarshallingType.SDK_POJO).memberName("AwsApiCallAction")
            .getter(getter(Action::awsApiCallAction)).setter(setter(Builder::awsApiCallAction))
            .constructor(AwsApiCallAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsApiCallAction").build()).build();

    private static final SdkField<DnsRequestAction> DNS_REQUEST_ACTION_FIELD = SdkField
            .<DnsRequestAction> builder(MarshallingType.SDK_POJO).memberName("DnsRequestAction")
            .getter(getter(Action::dnsRequestAction)).setter(setter(Builder::dnsRequestAction))
            .constructor(DnsRequestAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRequestAction").build()).build();

    private static final SdkField<NetworkConnectionAction> NETWORK_CONNECTION_ACTION_FIELD = SdkField
            .<NetworkConnectionAction> builder(MarshallingType.SDK_POJO).memberName("NetworkConnectionAction")
            .getter(getter(Action::networkConnectionAction)).setter(setter(Builder::networkConnectionAction))
            .constructor(NetworkConnectionAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConnectionAction").build())
            .build();

    private static final SdkField<PortProbeAction> PORT_PROBE_ACTION_FIELD = SdkField
            .<PortProbeAction> builder(MarshallingType.SDK_POJO).memberName("PortProbeAction")
            .getter(getter(Action::portProbeAction)).setter(setter(Builder::portProbeAction))
            .constructor(PortProbeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portProbeAction").build()).build();

    private static final SdkField<KubernetesApiCallAction> KUBERNETES_API_CALL_ACTION_FIELD = SdkField
            .<KubernetesApiCallAction> builder(MarshallingType.SDK_POJO).memberName("KubernetesApiCallAction")
            .getter(getter(Action::kubernetesApiCallAction)).setter(setter(Builder::kubernetesApiCallAction))
            .constructor(KubernetesApiCallAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesApiCallAction").build())
            .build();

    private static final SdkField<RdsLoginAttemptAction> RDS_LOGIN_ATTEMPT_ACTION_FIELD = SdkField
            .<RdsLoginAttemptAction> builder(MarshallingType.SDK_POJO).memberName("RdsLoginAttemptAction")
            .getter(getter(Action::rdsLoginAttemptAction)).setter(setter(Builder::rdsLoginAttemptAction))
            .constructor(RdsLoginAttemptAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsLoginAttemptAction").build())
            .build();

    private static final SdkField<KubernetesPermissionCheckedDetails> KUBERNETES_PERMISSION_CHECKED_DETAILS_FIELD = SdkField
            .<KubernetesPermissionCheckedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("KubernetesPermissionCheckedDetails")
            .getter(getter(Action::kubernetesPermissionCheckedDetails))
            .setter(setter(Builder::kubernetesPermissionCheckedDetails))
            .constructor(KubernetesPermissionCheckedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesPermissionCheckedDetails")
                    .build()).build();

    private static final SdkField<KubernetesRoleBindingDetails> KUBERNETES_ROLE_BINDING_DETAILS_FIELD = SdkField
            .<KubernetesRoleBindingDetails> builder(MarshallingType.SDK_POJO)
            .memberName("KubernetesRoleBindingDetails")
            .getter(getter(Action::kubernetesRoleBindingDetails))
            .setter(setter(Builder::kubernetesRoleBindingDetails))
            .constructor(KubernetesRoleBindingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesRoleBindingDetails")
                    .build()).build();

    private static final SdkField<KubernetesRoleDetails> KUBERNETES_ROLE_DETAILS_FIELD = SdkField
            .<KubernetesRoleDetails> builder(MarshallingType.SDK_POJO).memberName("KubernetesRoleDetails")
            .getter(getter(Action::kubernetesRoleDetails)).setter(setter(Builder::kubernetesRoleDetails))
            .constructor(KubernetesRoleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesRoleDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            AWS_API_CALL_ACTION_FIELD, DNS_REQUEST_ACTION_FIELD, NETWORK_CONNECTION_ACTION_FIELD, PORT_PROBE_ACTION_FIELD,
            KUBERNETES_API_CALL_ACTION_FIELD, RDS_LOGIN_ATTEMPT_ACTION_FIELD, KUBERNETES_PERMISSION_CHECKED_DETAILS_FIELD,
            KUBERNETES_ROLE_BINDING_DETAILS_FIELD, KUBERNETES_ROLE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final AwsApiCallAction awsApiCallAction;

    private final DnsRequestAction dnsRequestAction;

    private final NetworkConnectionAction networkConnectionAction;

    private final PortProbeAction portProbeAction;

    private final KubernetesApiCallAction kubernetesApiCallAction;

    private final RdsLoginAttemptAction rdsLoginAttemptAction;

    private final KubernetesPermissionCheckedDetails kubernetesPermissionCheckedDetails;

    private final KubernetesRoleBindingDetails kubernetesRoleBindingDetails;

    private final KubernetesRoleDetails kubernetesRoleDetails;

    private Action(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.awsApiCallAction = builder.awsApiCallAction;
        this.dnsRequestAction = builder.dnsRequestAction;
        this.networkConnectionAction = builder.networkConnectionAction;
        this.portProbeAction = builder.portProbeAction;
        this.kubernetesApiCallAction = builder.kubernetesApiCallAction;
        this.rdsLoginAttemptAction = builder.rdsLoginAttemptAction;
        this.kubernetesPermissionCheckedDetails = builder.kubernetesPermissionCheckedDetails;
        this.kubernetesRoleBindingDetails = builder.kubernetesRoleBindingDetails;
        this.kubernetesRoleDetails = builder.kubernetesRoleDetails;
    }

    /**
     * <p>
     * The GuardDuty finding activity type.
     * </p>
     * 
     * @return The GuardDuty finding activity type.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * <p>
     * Information about the AWS_API_CALL action described in this finding.
     * </p>
     * 
     * @return Information about the AWS_API_CALL action described in this finding.
     */
    public final AwsApiCallAction awsApiCallAction() {
        return awsApiCallAction;
    }

    /**
     * <p>
     * Information about the DNS_REQUEST action described in this finding.
     * </p>
     * 
     * @return Information about the DNS_REQUEST action described in this finding.
     */
    public final DnsRequestAction dnsRequestAction() {
        return dnsRequestAction;
    }

    /**
     * <p>
     * Information about the NETWORK_CONNECTION action described in this finding.
     * </p>
     * 
     * @return Information about the NETWORK_CONNECTION action described in this finding.
     */
    public final NetworkConnectionAction networkConnectionAction() {
        return networkConnectionAction;
    }

    /**
     * <p>
     * Information about the PORT_PROBE action described in this finding.
     * </p>
     * 
     * @return Information about the PORT_PROBE action described in this finding.
     */
    public final PortProbeAction portProbeAction() {
        return portProbeAction;
    }

    /**
     * <p>
     * Information about the Kubernetes API call action described in this finding.
     * </p>
     * 
     * @return Information about the Kubernetes API call action described in this finding.
     */
    public final KubernetesApiCallAction kubernetesApiCallAction() {
        return kubernetesApiCallAction;
    }

    /**
     * <p>
     * Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.
     * </p>
     * 
     * @return Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.
     */
    public final RdsLoginAttemptAction rdsLoginAttemptAction() {
        return rdsLoginAttemptAction;
    }

    /**
     * <p>
     * Information whether the user has the permission to use a specific Kubernetes API.
     * </p>
     * 
     * @return Information whether the user has the permission to use a specific Kubernetes API.
     */
    public final KubernetesPermissionCheckedDetails kubernetesPermissionCheckedDetails() {
        return kubernetesPermissionCheckedDetails;
    }

    /**
     * <p>
     * Information about the role binding that grants the permission defined in a Kubernetes role.
     * </p>
     * 
     * @return Information about the role binding that grants the permission defined in a Kubernetes role.
     */
    public final KubernetesRoleBindingDetails kubernetesRoleBindingDetails() {
        return kubernetesRoleBindingDetails;
    }

    /**
     * <p>
     * Information about the Kubernetes role name and role type.
     * </p>
     * 
     * @return Information about the Kubernetes role name and role type.
     */
    public final KubernetesRoleDetails kubernetesRoleDetails() {
        return kubernetesRoleDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRequestAction());
        hashCode = 31 * hashCode + Objects.hashCode(networkConnectionAction());
        hashCode = 31 * hashCode + Objects.hashCode(portProbeAction());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(rdsLoginAttemptAction());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesPermissionCheckedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesRoleBindingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesRoleDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(actionType(), other.actionType()) && Objects.equals(awsApiCallAction(), other.awsApiCallAction())
                && Objects.equals(dnsRequestAction(), other.dnsRequestAction())
                && Objects.equals(networkConnectionAction(), other.networkConnectionAction())
                && Objects.equals(portProbeAction(), other.portProbeAction())
                && Objects.equals(kubernetesApiCallAction(), other.kubernetesApiCallAction())
                && Objects.equals(rdsLoginAttemptAction(), other.rdsLoginAttemptAction())
                && Objects.equals(kubernetesPermissionCheckedDetails(), other.kubernetesPermissionCheckedDetails())
                && Objects.equals(kubernetesRoleBindingDetails(), other.kubernetesRoleBindingDetails())
                && Objects.equals(kubernetesRoleDetails(), other.kubernetesRoleDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("ActionType", actionType()).add("AwsApiCallAction", awsApiCallAction())
                .add("DnsRequestAction", dnsRequestAction()).add("NetworkConnectionAction", networkConnectionAction())
                .add("PortProbeAction", portProbeAction()).add("KubernetesApiCallAction", kubernetesApiCallAction())
                .add("RdsLoginAttemptAction", rdsLoginAttemptAction())
                .add("KubernetesPermissionCheckedDetails", kubernetesPermissionCheckedDetails())
                .add("KubernetesRoleBindingDetails", kubernetesRoleBindingDetails())
                .add("KubernetesRoleDetails", kubernetesRoleDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "AwsApiCallAction":
            return Optional.ofNullable(clazz.cast(awsApiCallAction()));
        case "DnsRequestAction":
            return Optional.ofNullable(clazz.cast(dnsRequestAction()));
        case "NetworkConnectionAction":
            return Optional.ofNullable(clazz.cast(networkConnectionAction()));
        case "PortProbeAction":
            return Optional.ofNullable(clazz.cast(portProbeAction()));
        case "KubernetesApiCallAction":
            return Optional.ofNullable(clazz.cast(kubernetesApiCallAction()));
        case "RdsLoginAttemptAction":
            return Optional.ofNullable(clazz.cast(rdsLoginAttemptAction()));
        case "KubernetesPermissionCheckedDetails":
            return Optional.ofNullable(clazz.cast(kubernetesPermissionCheckedDetails()));
        case "KubernetesRoleBindingDetails":
            return Optional.ofNullable(clazz.cast(kubernetesRoleBindingDetails()));
        case "KubernetesRoleDetails":
            return Optional.ofNullable(clazz.cast(kubernetesRoleDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("awsApiCallAction", AWS_API_CALL_ACTION_FIELD);
        map.put("dnsRequestAction", DNS_REQUEST_ACTION_FIELD);
        map.put("networkConnectionAction", NETWORK_CONNECTION_ACTION_FIELD);
        map.put("portProbeAction", PORT_PROBE_ACTION_FIELD);
        map.put("kubernetesApiCallAction", KUBERNETES_API_CALL_ACTION_FIELD);
        map.put("rdsLoginAttemptAction", RDS_LOGIN_ATTEMPT_ACTION_FIELD);
        map.put("kubernetesPermissionCheckedDetails", KUBERNETES_PERMISSION_CHECKED_DETAILS_FIELD);
        map.put("kubernetesRoleBindingDetails", KUBERNETES_ROLE_BINDING_DETAILS_FIELD);
        map.put("kubernetesRoleDetails", KUBERNETES_ROLE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The GuardDuty finding activity type.
         * </p>
         * 
         * @param actionType
         *        The GuardDuty finding activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Information about the AWS_API_CALL action described in this finding.
         * </p>
         * 
         * @param awsApiCallAction
         *        Information about the AWS_API_CALL action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiCallAction(AwsApiCallAction awsApiCallAction);

        /**
         * <p>
         * Information about the AWS_API_CALL action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiCallAction.Builder} avoiding the
         * need to create one manually via {@link AwsApiCallAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiCallAction.Builder#build()} is called immediately and its
         * result is passed to {@link #awsApiCallAction(AwsApiCallAction)}.
         * 
         * @param awsApiCallAction
         *        a consumer that will call methods on {@link AwsApiCallAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiCallAction(AwsApiCallAction)
         */
        default Builder awsApiCallAction(Consumer<AwsApiCallAction.Builder> awsApiCallAction) {
            return awsApiCallAction(AwsApiCallAction.builder().applyMutation(awsApiCallAction).build());
        }

        /**
         * <p>
         * Information about the DNS_REQUEST action described in this finding.
         * </p>
         * 
         * @param dnsRequestAction
         *        Information about the DNS_REQUEST action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRequestAction(DnsRequestAction dnsRequestAction);

        /**
         * <p>
         * Information about the DNS_REQUEST action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsRequestAction.Builder} avoiding the
         * need to create one manually via {@link DnsRequestAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsRequestAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsRequestAction(DnsRequestAction)}.
         * 
         * @param dnsRequestAction
         *        a consumer that will call methods on {@link DnsRequestAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRequestAction(DnsRequestAction)
         */
        default Builder dnsRequestAction(Consumer<DnsRequestAction.Builder> dnsRequestAction) {
            return dnsRequestAction(DnsRequestAction.builder().applyMutation(dnsRequestAction).build());
        }

        /**
         * <p>
         * Information about the NETWORK_CONNECTION action described in this finding.
         * </p>
         * 
         * @param networkConnectionAction
         *        Information about the NETWORK_CONNECTION action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction);

        /**
         * <p>
         * Information about the NETWORK_CONNECTION action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConnectionAction.Builder} avoiding
         * the need to create one manually via {@link NetworkConnectionAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConnectionAction.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConnectionAction(NetworkConnectionAction)}.
         * 
         * @param networkConnectionAction
         *        a consumer that will call methods on {@link NetworkConnectionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConnectionAction(NetworkConnectionAction)
         */
        default Builder networkConnectionAction(Consumer<NetworkConnectionAction.Builder> networkConnectionAction) {
            return networkConnectionAction(NetworkConnectionAction.builder().applyMutation(networkConnectionAction).build());
        }

        /**
         * <p>
         * Information about the PORT_PROBE action described in this finding.
         * </p>
         * 
         * @param portProbeAction
         *        Information about the PORT_PROBE action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portProbeAction(PortProbeAction portProbeAction);

        /**
         * <p>
         * Information about the PORT_PROBE action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortProbeAction.Builder} avoiding the
         * need to create one manually via {@link PortProbeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortProbeAction.Builder#build()} is called immediately and its
         * result is passed to {@link #portProbeAction(PortProbeAction)}.
         * 
         * @param portProbeAction
         *        a consumer that will call methods on {@link PortProbeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portProbeAction(PortProbeAction)
         */
        default Builder portProbeAction(Consumer<PortProbeAction.Builder> portProbeAction) {
            return portProbeAction(PortProbeAction.builder().applyMutation(portProbeAction).build());
        }

        /**
         * <p>
         * Information about the Kubernetes API call action described in this finding.
         * </p>
         * 
         * @param kubernetesApiCallAction
         *        Information about the Kubernetes API call action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesApiCallAction(KubernetesApiCallAction kubernetesApiCallAction);

        /**
         * <p>
         * Information about the Kubernetes API call action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesApiCallAction.Builder} avoiding
         * the need to create one manually via {@link KubernetesApiCallAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesApiCallAction.Builder#build()} is called immediately
         * and its result is passed to {@link #kubernetesApiCallAction(KubernetesApiCallAction)}.
         * 
         * @param kubernetesApiCallAction
         *        a consumer that will call methods on {@link KubernetesApiCallAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesApiCallAction(KubernetesApiCallAction)
         */
        default Builder kubernetesApiCallAction(Consumer<KubernetesApiCallAction.Builder> kubernetesApiCallAction) {
            return kubernetesApiCallAction(KubernetesApiCallAction.builder().applyMutation(kubernetesApiCallAction).build());
        }

        /**
         * <p>
         * Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.
         * </p>
         * 
         * @param rdsLoginAttemptAction
         *        Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsLoginAttemptAction(RdsLoginAttemptAction rdsLoginAttemptAction);

        /**
         * <p>
         * Information about <code>RDS_LOGIN_ATTEMPT</code> action described in this finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsLoginAttemptAction.Builder} avoiding
         * the need to create one manually via {@link RdsLoginAttemptAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsLoginAttemptAction.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsLoginAttemptAction(RdsLoginAttemptAction)}.
         * 
         * @param rdsLoginAttemptAction
         *        a consumer that will call methods on {@link RdsLoginAttemptAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsLoginAttemptAction(RdsLoginAttemptAction)
         */
        default Builder rdsLoginAttemptAction(Consumer<RdsLoginAttemptAction.Builder> rdsLoginAttemptAction) {
            return rdsLoginAttemptAction(RdsLoginAttemptAction.builder().applyMutation(rdsLoginAttemptAction).build());
        }

        /**
         * <p>
         * Information whether the user has the permission to use a specific Kubernetes API.
         * </p>
         * 
         * @param kubernetesPermissionCheckedDetails
         *        Information whether the user has the permission to use a specific Kubernetes API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesPermissionCheckedDetails(KubernetesPermissionCheckedDetails kubernetesPermissionCheckedDetails);

        /**
         * <p>
         * Information whether the user has the permission to use a specific Kubernetes API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KubernetesPermissionCheckedDetails.Builder} avoiding the need to create one manually via
         * {@link KubernetesPermissionCheckedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesPermissionCheckedDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kubernetesPermissionCheckedDetails(KubernetesPermissionCheckedDetails)}.
         * 
         * @param kubernetesPermissionCheckedDetails
         *        a consumer that will call methods on {@link KubernetesPermissionCheckedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesPermissionCheckedDetails(KubernetesPermissionCheckedDetails)
         */
        default Builder kubernetesPermissionCheckedDetails(
                Consumer<KubernetesPermissionCheckedDetails.Builder> kubernetesPermissionCheckedDetails) {
            return kubernetesPermissionCheckedDetails(KubernetesPermissionCheckedDetails.builder()
                    .applyMutation(kubernetesPermissionCheckedDetails).build());
        }

        /**
         * <p>
         * Information about the role binding that grants the permission defined in a Kubernetes role.
         * </p>
         * 
         * @param kubernetesRoleBindingDetails
         *        Information about the role binding that grants the permission defined in a Kubernetes role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesRoleBindingDetails(KubernetesRoleBindingDetails kubernetesRoleBindingDetails);

        /**
         * <p>
         * Information about the role binding that grants the permission defined in a Kubernetes role.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesRoleBindingDetails.Builder}
         * avoiding the need to create one manually via {@link KubernetesRoleBindingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesRoleBindingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #kubernetesRoleBindingDetails(KubernetesRoleBindingDetails)}.
         * 
         * @param kubernetesRoleBindingDetails
         *        a consumer that will call methods on {@link KubernetesRoleBindingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesRoleBindingDetails(KubernetesRoleBindingDetails)
         */
        default Builder kubernetesRoleBindingDetails(Consumer<KubernetesRoleBindingDetails.Builder> kubernetesRoleBindingDetails) {
            return kubernetesRoleBindingDetails(KubernetesRoleBindingDetails.builder()
                    .applyMutation(kubernetesRoleBindingDetails).build());
        }

        /**
         * <p>
         * Information about the Kubernetes role name and role type.
         * </p>
         * 
         * @param kubernetesRoleDetails
         *        Information about the Kubernetes role name and role type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesRoleDetails(KubernetesRoleDetails kubernetesRoleDetails);

        /**
         * <p>
         * Information about the Kubernetes role name and role type.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesRoleDetails.Builder} avoiding
         * the need to create one manually via {@link KubernetesRoleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesRoleDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #kubernetesRoleDetails(KubernetesRoleDetails)}.
         * 
         * @param kubernetesRoleDetails
         *        a consumer that will call methods on {@link KubernetesRoleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesRoleDetails(KubernetesRoleDetails)
         */
        default Builder kubernetesRoleDetails(Consumer<KubernetesRoleDetails.Builder> kubernetesRoleDetails) {
            return kubernetesRoleDetails(KubernetesRoleDetails.builder().applyMutation(kubernetesRoleDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private AwsApiCallAction awsApiCallAction;

        private DnsRequestAction dnsRequestAction;

        private NetworkConnectionAction networkConnectionAction;

        private PortProbeAction portProbeAction;

        private KubernetesApiCallAction kubernetesApiCallAction;

        private RdsLoginAttemptAction rdsLoginAttemptAction;

        private KubernetesPermissionCheckedDetails kubernetesPermissionCheckedDetails;

        private KubernetesRoleBindingDetails kubernetesRoleBindingDetails;

        private KubernetesRoleDetails kubernetesRoleDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            actionType(model.actionType);
            awsApiCallAction(model.awsApiCallAction);
            dnsRequestAction(model.dnsRequestAction);
            networkConnectionAction(model.networkConnectionAction);
            portProbeAction(model.portProbeAction);
            kubernetesApiCallAction(model.kubernetesApiCallAction);
            rdsLoginAttemptAction(model.rdsLoginAttemptAction);
            kubernetesPermissionCheckedDetails(model.kubernetesPermissionCheckedDetails);
            kubernetesRoleBindingDetails(model.kubernetesRoleBindingDetails);
            kubernetesRoleDetails(model.kubernetesRoleDetails);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final AwsApiCallAction.Builder getAwsApiCallAction() {
            return awsApiCallAction != null ? awsApiCallAction.toBuilder() : null;
        }

        public final void setAwsApiCallAction(AwsApiCallAction.BuilderImpl awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction != null ? awsApiCallAction.build() : null;
        }

        @Override
        public final Builder awsApiCallAction(AwsApiCallAction awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction;
            return this;
        }

        public final DnsRequestAction.Builder getDnsRequestAction() {
            return dnsRequestAction != null ? dnsRequestAction.toBuilder() : null;
        }

        public final void setDnsRequestAction(DnsRequestAction.BuilderImpl dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction != null ? dnsRequestAction.build() : null;
        }

        @Override
        public final Builder dnsRequestAction(DnsRequestAction dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction;
            return this;
        }

        public final NetworkConnectionAction.Builder getNetworkConnectionAction() {
            return networkConnectionAction != null ? networkConnectionAction.toBuilder() : null;
        }

        public final void setNetworkConnectionAction(NetworkConnectionAction.BuilderImpl networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction != null ? networkConnectionAction.build() : null;
        }

        @Override
        public final Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction;
            return this;
        }

        public final PortProbeAction.Builder getPortProbeAction() {
            return portProbeAction != null ? portProbeAction.toBuilder() : null;
        }

        public final void setPortProbeAction(PortProbeAction.BuilderImpl portProbeAction) {
            this.portProbeAction = portProbeAction != null ? portProbeAction.build() : null;
        }

        @Override
        public final Builder portProbeAction(PortProbeAction portProbeAction) {
            this.portProbeAction = portProbeAction;
            return this;
        }

        public final KubernetesApiCallAction.Builder getKubernetesApiCallAction() {
            return kubernetesApiCallAction != null ? kubernetesApiCallAction.toBuilder() : null;
        }

        public final void setKubernetesApiCallAction(KubernetesApiCallAction.BuilderImpl kubernetesApiCallAction) {
            this.kubernetesApiCallAction = kubernetesApiCallAction != null ? kubernetesApiCallAction.build() : null;
        }

        @Override
        public final Builder kubernetesApiCallAction(KubernetesApiCallAction kubernetesApiCallAction) {
            this.kubernetesApiCallAction = kubernetesApiCallAction;
            return this;
        }

        public final RdsLoginAttemptAction.Builder getRdsLoginAttemptAction() {
            return rdsLoginAttemptAction != null ? rdsLoginAttemptAction.toBuilder() : null;
        }

        public final void setRdsLoginAttemptAction(RdsLoginAttemptAction.BuilderImpl rdsLoginAttemptAction) {
            this.rdsLoginAttemptAction = rdsLoginAttemptAction != null ? rdsLoginAttemptAction.build() : null;
        }

        @Override
        public final Builder rdsLoginAttemptAction(RdsLoginAttemptAction rdsLoginAttemptAction) {
            this.rdsLoginAttemptAction = rdsLoginAttemptAction;
            return this;
        }

        public final KubernetesPermissionCheckedDetails.Builder getKubernetesPermissionCheckedDetails() {
            return kubernetesPermissionCheckedDetails != null ? kubernetesPermissionCheckedDetails.toBuilder() : null;
        }

        public final void setKubernetesPermissionCheckedDetails(
                KubernetesPermissionCheckedDetails.BuilderImpl kubernetesPermissionCheckedDetails) {
            this.kubernetesPermissionCheckedDetails = kubernetesPermissionCheckedDetails != null ? kubernetesPermissionCheckedDetails
                    .build() : null;
        }

        @Override
        public final Builder kubernetesPermissionCheckedDetails(
                KubernetesPermissionCheckedDetails kubernetesPermissionCheckedDetails) {
            this.kubernetesPermissionCheckedDetails = kubernetesPermissionCheckedDetails;
            return this;
        }

        public final KubernetesRoleBindingDetails.Builder getKubernetesRoleBindingDetails() {
            return kubernetesRoleBindingDetails != null ? kubernetesRoleBindingDetails.toBuilder() : null;
        }

        public final void setKubernetesRoleBindingDetails(KubernetesRoleBindingDetails.BuilderImpl kubernetesRoleBindingDetails) {
            this.kubernetesRoleBindingDetails = kubernetesRoleBindingDetails != null ? kubernetesRoleBindingDetails.build()
                    : null;
        }

        @Override
        public final Builder kubernetesRoleBindingDetails(KubernetesRoleBindingDetails kubernetesRoleBindingDetails) {
            this.kubernetesRoleBindingDetails = kubernetesRoleBindingDetails;
            return this;
        }

        public final KubernetesRoleDetails.Builder getKubernetesRoleDetails() {
            return kubernetesRoleDetails != null ? kubernetesRoleDetails.toBuilder() : null;
        }

        public final void setKubernetesRoleDetails(KubernetesRoleDetails.BuilderImpl kubernetesRoleDetails) {
            this.kubernetesRoleDetails = kubernetesRoleDetails != null ? kubernetesRoleDetails.build() : null;
        }

        @Override
        public final Builder kubernetesRoleDetails(KubernetesRoleDetails kubernetesRoleDetails) {
            this.kubernetesRoleDetails = kubernetesRoleDetails;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
