/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a list of map of accounts with the number of findings associated with each account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountStatistics.Builder, AccountStatistics> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountStatistics::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastGeneratedAt").getter(getter(AccountStatistics::lastGeneratedAt))
            .setter(setter(Builder::lastGeneratedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()).build();

    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFindings").getter(getter(AccountStatistics::totalFindings)).setter(setter(Builder::totalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            LAST_GENERATED_AT_FIELD, TOTAL_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Instant lastGeneratedAt;

    private final Integer totalFindings;

    private AccountStatistics(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.totalFindings = builder.totalFindings;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The timestamp at which the finding for this account was last generated.
     * </p>
     * 
     * @return The timestamp at which the finding for this account was last generated.
     */
    public final Instant lastGeneratedAt() {
        return lastGeneratedAt;
    }

    /**
     * <p>
     * The total number of findings associated with an account.
     * </p>
     * 
     * @return The total number of findings associated with an account.
     */
    public final Integer totalFindings() {
        return totalFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(totalFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountStatistics)) {
            return false;
        }
        AccountStatistics other = (AccountStatistics) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(lastGeneratedAt(), other.lastGeneratedAt())
                && Objects.equals(totalFindings(), other.totalFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountStatistics").add("AccountId", accountId()).add("LastGeneratedAt", lastGeneratedAt())
                .add("TotalFindings", totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "LastGeneratedAt":
            return Optional.ofNullable(clazz.cast(lastGeneratedAt()));
        case "TotalFindings":
            return Optional.ofNullable(clazz.cast(totalFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("lastGeneratedAt", LAST_GENERATED_AT_FIELD);
        map.put("totalFindings", TOTAL_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountStatistics, T> g) {
        return obj -> g.apply((AccountStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountStatistics> {
        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The timestamp at which the finding for this account was last generated.
         * </p>
         * 
         * @param lastGeneratedAt
         *        The timestamp at which the finding for this account was last generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastGeneratedAt(Instant lastGeneratedAt);

        /**
         * <p>
         * The total number of findings associated with an account.
         * </p>
         * 
         * @param totalFindings
         *        The total number of findings associated with an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindings(Integer totalFindings);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Instant lastGeneratedAt;

        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountStatistics model) {
            accountId(model.accountId);
            lastGeneratedAt(model.lastGeneratedAt);
            totalFindings(model.totalFindings);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Integer getTotalFindings() {
            return totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        @Override
        public AccountStatistics build() {
            return new AccountStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
