/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration settings for running telemetry.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryConfiguration.Builder, TelemetryConfiguration> {
    private static final SdkField<String> CONFIGURATION_SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSyncStatus").getter(getter(TelemetryConfiguration::configurationSyncStatusAsString))
            .setter(setter(Builder::configurationSyncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSyncStatus").build())
            .build();

    private static final SdkField<String> TELEMETRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telemetry").getter(getter(TelemetryConfiguration::telemetryAsString)).setter(setter(Builder::telemetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telemetry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_SYNC_STATUS_FIELD, TELEMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationSyncStatus;

    private final String telemetry;

    private TelemetryConfiguration(BuilderImpl builder) {
        this.configurationSyncStatus = builder.configurationSyncStatus;
        this.telemetry = builder.telemetry;
    }

    /**
     * Synchronization status of the device reported configuration with the desired configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationSyncStatus} will return {@link ConfigurationSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationSyncStatusAsString}.
     * </p>
     * 
     * @return Synchronization status of the device reported configuration with the desired configuration.
     * @see ConfigurationSyncStatus
     */
    public final ConfigurationSyncStatus configurationSyncStatus() {
        return ConfigurationSyncStatus.fromValue(configurationSyncStatus);
    }

    /**
     * Synchronization status of the device reported configuration with the desired configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationSyncStatus} will return {@link ConfigurationSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationSyncStatusAsString}.
     * </p>
     * 
     * @return Synchronization status of the device reported configuration with the desired configuration.
     * @see ConfigurationSyncStatus
     */
    public final String configurationSyncStatusAsString() {
        return configurationSyncStatus;
    }

    /**
     * Configure telemetry to be on or off.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telemetry} will
     * return {@link Telemetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telemetryAsString}.
     * </p>
     * 
     * @return Configure telemetry to be on or off.
     * @see Telemetry
     */
    public final Telemetry telemetry() {
        return Telemetry.fromValue(telemetry);
    }

    /**
     * Configure telemetry to be on or off.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telemetry} will
     * return {@link Telemetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telemetryAsString}.
     * </p>
     * 
     * @return Configure telemetry to be on or off.
     * @see Telemetry
     */
    public final String telemetryAsString() {
        return telemetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSyncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telemetryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryConfiguration)) {
            return false;
        }
        TelemetryConfiguration other = (TelemetryConfiguration) obj;
        return Objects.equals(configurationSyncStatusAsString(), other.configurationSyncStatusAsString())
                && Objects.equals(telemetryAsString(), other.telemetryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelemetryConfiguration").add("ConfigurationSyncStatus", configurationSyncStatusAsString())
                .add("Telemetry", telemetryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSyncStatus":
            return Optional.ofNullable(clazz.cast(configurationSyncStatusAsString()));
        case "Telemetry":
            return Optional.ofNullable(clazz.cast(telemetryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSyncStatus", CONFIGURATION_SYNC_STATUS_FIELD);
        map.put("Telemetry", TELEMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryConfiguration, T> g) {
        return obj -> g.apply((TelemetryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryConfiguration> {
        /**
         * Synchronization status of the device reported configuration with the desired configuration.
         * 
         * @param configurationSyncStatus
         *        Synchronization status of the device reported configuration with the desired configuration.
         * @see ConfigurationSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSyncStatus
         */
        Builder configurationSyncStatus(String configurationSyncStatus);

        /**
         * Synchronization status of the device reported configuration with the desired configuration.
         * 
         * @param configurationSyncStatus
         *        Synchronization status of the device reported configuration with the desired configuration.
         * @see ConfigurationSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSyncStatus
         */
        Builder configurationSyncStatus(ConfigurationSyncStatus configurationSyncStatus);

        /**
         * Configure telemetry to be on or off.
         * 
         * @param telemetry
         *        Configure telemetry to be on or off.
         * @see Telemetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Telemetry
         */
        Builder telemetry(String telemetry);

        /**
         * Configure telemetry to be on or off.
         * 
         * @param telemetry
         *        Configure telemetry to be on or off.
         * @see Telemetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Telemetry
         */
        Builder telemetry(Telemetry telemetry);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSyncStatus;

        private String telemetry;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryConfiguration model) {
            configurationSyncStatus(model.configurationSyncStatus);
            telemetry(model.telemetry);
        }

        public final String getConfigurationSyncStatus() {
            return configurationSyncStatus;
        }

        public final void setConfigurationSyncStatus(String configurationSyncStatus) {
            this.configurationSyncStatus = configurationSyncStatus;
        }

        @Override
        public final Builder configurationSyncStatus(String configurationSyncStatus) {
            this.configurationSyncStatus = configurationSyncStatus;
            return this;
        }

        @Override
        public final Builder configurationSyncStatus(ConfigurationSyncStatus configurationSyncStatus) {
            this.configurationSyncStatus(configurationSyncStatus == null ? null : configurationSyncStatus.toString());
            return this;
        }

        public final String getTelemetry() {
            return telemetry;
        }

        public final void setTelemetry(String telemetry) {
            this.telemetry = telemetry;
        }

        @Override
        public final Builder telemetry(String telemetry) {
            this.telemetry = telemetry;
            return this;
        }

        @Override
        public final Builder telemetry(Telemetry telemetry) {
            this.telemetry(telemetry == null ? null : telemetry.toString());
            return this;
        }

        @Override
        public TelemetryConfiguration build() {
            return new TelemetryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
