/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBulkDeploymentResponse extends GreengrassResponse implements
        ToCopyableBuilder<StartBulkDeploymentResponse.Builder, StartBulkDeploymentResponse> {
    private static final SdkField<String> BULK_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BulkDeploymentArn").getter(getter(StartBulkDeploymentResponse::bulkDeploymentArn))
            .setter(setter(Builder::bulkDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentArn").build()).build();

    private static final SdkField<String> BULK_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BulkDeploymentId").getter(getter(StartBulkDeploymentResponse::bulkDeploymentId))
            .setter(setter(Builder::bulkDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENT_ARN_FIELD,
            BULK_DEPLOYMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bulkDeploymentArn;

    private final String bulkDeploymentId;

    private StartBulkDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.bulkDeploymentArn = builder.bulkDeploymentArn;
        this.bulkDeploymentId = builder.bulkDeploymentId;
    }

    /**
     * The ARN of the bulk deployment.
     * 
     * @return The ARN of the bulk deployment.
     */
    public final String bulkDeploymentArn() {
        return bulkDeploymentArn;
    }

    /**
     * The ID of the bulk deployment.
     * 
     * @return The ID of the bulk deployment.
     */
    public final String bulkDeploymentId() {
        return bulkDeploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBulkDeploymentResponse)) {
            return false;
        }
        StartBulkDeploymentResponse other = (StartBulkDeploymentResponse) obj;
        return Objects.equals(bulkDeploymentArn(), other.bulkDeploymentArn())
                && Objects.equals(bulkDeploymentId(), other.bulkDeploymentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBulkDeploymentResponse").add("BulkDeploymentArn", bulkDeploymentArn())
                .add("BulkDeploymentId", bulkDeploymentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkDeploymentArn":
            return Optional.ofNullable(clazz.cast(bulkDeploymentArn()));
        case "BulkDeploymentId":
            return Optional.ofNullable(clazz.cast(bulkDeploymentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BulkDeploymentArn", BULK_DEPLOYMENT_ARN_FIELD);
        map.put("BulkDeploymentId", BULK_DEPLOYMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBulkDeploymentResponse, T> g) {
        return obj -> g.apply((StartBulkDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartBulkDeploymentResponse> {
        /**
         * The ARN of the bulk deployment.
         * 
         * @param bulkDeploymentArn
         *        The ARN of the bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentArn(String bulkDeploymentArn);

        /**
         * The ID of the bulk deployment.
         * 
         * @param bulkDeploymentId
         *        The ID of the bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentId(String bulkDeploymentId);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String bulkDeploymentArn;

        private String bulkDeploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBulkDeploymentResponse model) {
            super(model);
            bulkDeploymentArn(model.bulkDeploymentArn);
            bulkDeploymentId(model.bulkDeploymentId);
        }

        public final String getBulkDeploymentArn() {
            return bulkDeploymentArn;
        }

        public final void setBulkDeploymentArn(String bulkDeploymentArn) {
            this.bulkDeploymentArn = bulkDeploymentArn;
        }

        @Override
        public final Builder bulkDeploymentArn(String bulkDeploymentArn) {
            this.bulkDeploymentArn = bulkDeploymentArn;
            return this;
        }

        public final String getBulkDeploymentId() {
            return bulkDeploymentId;
        }

        public final void setBulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
        }

        @Override
        public final Builder bulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
            return this;
        }

        @Override
        public StartBulkDeploymentResponse build() {
            return new StartBulkDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
