/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetFunctionDefinitionRequest.Builder, GetFunctionDefinitionRequest> {
    private static final SdkField<String> FUNCTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionDefinitionId").getter(getter(GetFunctionDefinitionRequest::functionDefinitionId))
            .setter(setter(Builder::functionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionDefinitionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_DEFINITION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionDefinitionId;

    private GetFunctionDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.functionDefinitionId = builder.functionDefinitionId;
    }

    /**
     * The ID of the Lambda function definition.
     * 
     * @return The ID of the Lambda function definition.
     */
    public final String functionDefinitionId() {
        return functionDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionDefinitionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionDefinitionRequest)) {
            return false;
        }
        GetFunctionDefinitionRequest other = (GetFunctionDefinitionRequest) obj;
        return Objects.equals(functionDefinitionId(), other.functionDefinitionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionDefinitionRequest").add("FunctionDefinitionId", functionDefinitionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionDefinitionId":
            return Optional.ofNullable(clazz.cast(functionDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionDefinitionId", FUNCTION_DEFINITION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionDefinitionRequest, T> g) {
        return obj -> g.apply((GetFunctionDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionDefinitionRequest> {
        /**
         * The ID of the Lambda function definition.
         * 
         * @param functionDefinitionId
         *        The ID of the Lambda function definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionDefinitionId(String functionDefinitionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String functionDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionDefinitionRequest model) {
            super(model);
            functionDefinitionId(model.functionDefinitionId);
        }

        public final String getFunctionDefinitionId() {
            return functionDefinitionId;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFunctionDefinitionRequest build() {
            return new GetFunctionDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
