/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSoftwareUpdateJobResponse extends GreengrassResponse implements
        ToCopyableBuilder<CreateSoftwareUpdateJobResponse.Builder, CreateSoftwareUpdateJobResponse> {
    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotJobArn").getter(getter(CreateSoftwareUpdateJobResponse::iotJobArn))
            .setter(setter(Builder::iotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotJobArn").build()).build();

    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotJobId").getter(getter(CreateSoftwareUpdateJobResponse::iotJobId)).setter(setter(Builder::iotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotJobId").build()).build();

    private static final SdkField<String> PLATFORM_SOFTWARE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformSoftwareVersion").getter(getter(CreateSoftwareUpdateJobResponse::platformSoftwareVersion))
            .setter(setter(Builder::platformSoftwareVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSoftwareVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOT_JOB_ARN_FIELD,
            IOT_JOB_ID_FIELD, PLATFORM_SOFTWARE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String iotJobArn;

    private final String iotJobId;

    private final String platformSoftwareVersion;

    private CreateSoftwareUpdateJobResponse(BuilderImpl builder) {
        super(builder);
        this.iotJobArn = builder.iotJobArn;
        this.iotJobId = builder.iotJobId;
        this.platformSoftwareVersion = builder.platformSoftwareVersion;
    }

    /**
     * The IoT Job ARN corresponding to this update.
     * 
     * @return The IoT Job ARN corresponding to this update.
     */
    public final String iotJobArn() {
        return iotJobArn;
    }

    /**
     * The IoT Job Id corresponding to this update.
     * 
     * @return The IoT Job Id corresponding to this update.
     */
    public final String iotJobId() {
        return iotJobId;
    }

    /**
     * The software version installed on the device or devices after the update.
     * 
     * @return The software version installed on the device or devices after the update.
     */
    public final String platformSoftwareVersion() {
        return platformSoftwareVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(iotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(platformSoftwareVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSoftwareUpdateJobResponse)) {
            return false;
        }
        CreateSoftwareUpdateJobResponse other = (CreateSoftwareUpdateJobResponse) obj;
        return Objects.equals(iotJobArn(), other.iotJobArn()) && Objects.equals(iotJobId(), other.iotJobId())
                && Objects.equals(platformSoftwareVersion(), other.platformSoftwareVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSoftwareUpdateJobResponse").add("IotJobArn", iotJobArn()).add("IotJobId", iotJobId())
                .add("PlatformSoftwareVersion", platformSoftwareVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IotJobArn":
            return Optional.ofNullable(clazz.cast(iotJobArn()));
        case "IotJobId":
            return Optional.ofNullable(clazz.cast(iotJobId()));
        case "PlatformSoftwareVersion":
            return Optional.ofNullable(clazz.cast(platformSoftwareVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IotJobArn", IOT_JOB_ARN_FIELD);
        map.put("IotJobId", IOT_JOB_ID_FIELD);
        map.put("PlatformSoftwareVersion", PLATFORM_SOFTWARE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSoftwareUpdateJobResponse, T> g) {
        return obj -> g.apply((CreateSoftwareUpdateJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSoftwareUpdateJobResponse> {
        /**
         * The IoT Job ARN corresponding to this update.
         * 
         * @param iotJobArn
         *        The IoT Job ARN corresponding to this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobArn(String iotJobArn);

        /**
         * The IoT Job Id corresponding to this update.
         * 
         * @param iotJobId
         *        The IoT Job Id corresponding to this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotJobId(String iotJobId);

        /**
         * The software version installed on the device or devices after the update.
         * 
         * @param platformSoftwareVersion
         *        The software version installed on the device or devices after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSoftwareVersion(String platformSoftwareVersion);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String iotJobArn;

        private String iotJobId;

        private String platformSoftwareVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSoftwareUpdateJobResponse model) {
            super(model);
            iotJobArn(model.iotJobArn);
            iotJobId(model.iotJobId);
            platformSoftwareVersion(model.platformSoftwareVersion);
        }

        public final String getIotJobArn() {
            return iotJobArn;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final String getIotJobId() {
            return iotJobId;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final String getPlatformSoftwareVersion() {
            return platformSoftwareVersion;
        }

        public final void setPlatformSoftwareVersion(String platformSoftwareVersion) {
            this.platformSoftwareVersion = platformSoftwareVersion;
        }

        @Override
        public final Builder platformSoftwareVersion(String platformSoftwareVersion) {
            this.platformSoftwareVersion = platformSoftwareVersion;
            return this;
        }

        @Override
        public CreateSoftwareUpdateJobResponse build() {
            return new CreateSoftwareUpdateJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
