/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFunctionDefinitionVersionResponse extends GreengrassResponse implements
        ToCopyableBuilder<CreateFunctionDefinitionVersionResponse.Builder, CreateFunctionDefinitionVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateFunctionDefinitionVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTimestamp").getter(getter(CreateFunctionDefinitionVersionResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateFunctionDefinitionVersionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(CreateFunctionDefinitionVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, ID_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String creationTimestamp;

    private final String id;

    private final String version;

    private CreateFunctionDefinitionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.id = builder.id;
        this.version = builder.version;
    }

    /**
     * The ARN of the version.
     * 
     * @return The ARN of the version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The time, in milliseconds since the epoch, when the version was created.
     * 
     * @return The time, in milliseconds since the epoch, when the version was created.
     */
    public final String creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * The ID of the parent definition that the version is associated with.
     * 
     * @return The ID of the parent definition that the version is associated with.
     */
    public final String id() {
        return id;
    }

    /**
     * The ID of the version.
     * 
     * @return The ID of the version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionVersionResponse)) {
            return false;
        }
        CreateFunctionDefinitionVersionResponse other = (CreateFunctionDefinitionVersionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(id(), other.id()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFunctionDefinitionVersionResponse").add("Arn", arn())
                .add("CreationTimestamp", creationTimestamp()).add("Id", id()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionDefinitionVersionResponse, T> g) {
        return obj -> g.apply((CreateFunctionDefinitionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFunctionDefinitionVersionResponse> {
        /**
         * The ARN of the version.
         * 
         * @param arn
         *        The ARN of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time, in milliseconds since the epoch, when the version was created.
         * 
         * @param creationTimestamp
         *        The time, in milliseconds since the epoch, when the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(String creationTimestamp);

        /**
         * The ID of the parent definition that the version is associated with.
         * 
         * @param id
         *        The ID of the parent definition that the version is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ID of the version.
         * 
         * @param version
         *        The ID of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationTimestamp;

        private String id;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionVersionResponse model) {
            super(model);
            arn(model.arn);
            creationTimestamp(model.creationTimestamp);
            id(model.id);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public CreateFunctionDefinitionVersionResponse build() {
            return new CreateFunctionDefinitionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
