/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCatalogRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateCatalogRequest.Builder, UpdateCatalogRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateCatalogRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<CatalogInput> CATALOG_INPUT_FIELD = SdkField.<CatalogInput> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogInput").getter(getter(UpdateCatalogRequest::catalogInput)).setter(setter(Builder::catalogInput))
            .constructor(CatalogInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            CATALOG_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final CatalogInput catalogInput;

    private UpdateCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.catalogInput = builder.catalogInput;
    }

    /**
     * <p>
     * The ID of the catalog.
     * </p>
     * 
     * @return The ID of the catalog.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A <code>CatalogInput</code> object specifying the new properties of an existing catalog.
     * </p>
     * 
     * @return A <code>CatalogInput</code> object specifying the new properties of an existing catalog.
     */
    public final CatalogInput catalogInput() {
        return catalogInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(catalogInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCatalogRequest)) {
            return false;
        }
        UpdateCatalogRequest other = (UpdateCatalogRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(catalogInput(), other.catalogInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCatalogRequest").add("CatalogId", catalogId()).add("CatalogInput", catalogInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "CatalogInput":
            return Optional.ofNullable(clazz.cast(catalogInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("CatalogInput", CATALOG_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCatalogRequest, T> g) {
        return obj -> g.apply((UpdateCatalogRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCatalogRequest> {
        /**
         * <p>
         * The ID of the catalog.
         * </p>
         * 
         * @param catalogId
         *        The ID of the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A <code>CatalogInput</code> object specifying the new properties of an existing catalog.
         * </p>
         * 
         * @param catalogInput
         *        A <code>CatalogInput</code> object specifying the new properties of an existing catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogInput(CatalogInput catalogInput);

        /**
         * <p>
         * A <code>CatalogInput</code> object specifying the new properties of an existing catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogInput.Builder} avoiding the need
         * to create one manually via {@link CatalogInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogInput.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogInput(CatalogInput)}.
         * 
         * @param catalogInput
         *        a consumer that will call methods on {@link CatalogInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogInput(CatalogInput)
         */
        default Builder catalogInput(Consumer<CatalogInput.Builder> catalogInput) {
            return catalogInput(CatalogInput.builder().applyMutation(catalogInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private CatalogInput catalogInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCatalogRequest model) {
            super(model);
            catalogId(model.catalogId);
            catalogInput(model.catalogInput);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final CatalogInput.Builder getCatalogInput() {
            return catalogInput != null ? catalogInput.toBuilder() : null;
        }

        public final void setCatalogInput(CatalogInput.BuilderImpl catalogInput) {
            this.catalogInput = catalogInput != null ? catalogInput.build() : null;
        }

        @Override
        public final Builder catalogInput(CatalogInput catalogInput) {
            this.catalogInput = catalogInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCatalogRequest build() {
            return new UpdateCatalogRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
