/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource properties associated with the integration target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetProcessingProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetProcessingProperties.Builder, TargetProcessingProperties> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(TargetProcessingProperties::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsArn")
            .getter(getter(TargetProcessingProperties::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsArn").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(TargetProcessingProperties::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> EVENT_BUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBusArn").getter(getter(TargetProcessingProperties::eventBusArn))
            .setter(setter(Builder::eventBusArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, KMS_ARN_FIELD,
            CONNECTION_NAME_FIELD, EVENT_BUS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String kmsArn;

    private final String connectionName;

    private final String eventBusArn;

    private TargetProcessingProperties(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.kmsArn = builder.kmsArn;
        this.connectionName = builder.connectionName;
        this.eventBusArn = builder.eventBusArn;
    }

    /**
     * <p>
     * The IAM role to access the Glue database.
     * </p>
     * 
     * @return The IAM role to access the Glue database.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN of the KMS key used for encryption.
     * </p>
     * 
     * @return The ARN of the KMS key used for encryption.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The Glue network connection to configure the Glue job running in the customer VPC.
     * </p>
     * 
     * @return The Glue network connection to configure the Glue job running in the customer VPC.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The ARN of an Eventbridge event bus to receive the integration status notification.
     * </p>
     * 
     * @return The ARN of an Eventbridge event bus to receive the integration status notification.
     */
    public final String eventBusArn() {
        return eventBusArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(eventBusArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetProcessingProperties)) {
            return false;
        }
        TargetProcessingProperties other = (TargetProcessingProperties) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(kmsArn(), other.kmsArn())
                && Objects.equals(connectionName(), other.connectionName()) && Objects.equals(eventBusArn(), other.eventBusArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetProcessingProperties").add("RoleArn", roleArn()).add("KmsArn", kmsArn())
                .add("ConnectionName", connectionName()).add("EventBusArn", eventBusArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "EventBusArn":
            return Optional.ofNullable(clazz.cast(eventBusArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("KmsArn", KMS_ARN_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("EventBusArn", EVENT_BUS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetProcessingProperties, T> g) {
        return obj -> g.apply((TargetProcessingProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetProcessingProperties> {
        /**
         * <p>
         * The IAM role to access the Glue database.
         * </p>
         * 
         * @param roleArn
         *        The IAM role to access the Glue database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN of the KMS key used for encryption.
         * </p>
         * 
         * @param kmsArn
         *        The ARN of the KMS key used for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The Glue network connection to configure the Glue job running in the customer VPC.
         * </p>
         * 
         * @param connectionName
         *        The Glue network connection to configure the Glue job running in the customer VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The ARN of an Eventbridge event bus to receive the integration status notification.
         * </p>
         * 
         * @param eventBusArn
         *        The ARN of an Eventbridge event bus to receive the integration status notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusArn(String eventBusArn);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String kmsArn;

        private String connectionName;

        private String eventBusArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetProcessingProperties model) {
            roleArn(model.roleArn);
            kmsArn(model.kmsArn);
            connectionName(model.connectionName);
            eventBusArn(model.eventBusArn);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getEventBusArn() {
            return eventBusArn;
        }

        public final void setEventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
        }

        @Override
        public final Builder eventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        @Override
        public TargetProcessingProperties build() {
            return new TargetProcessingProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
