/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a route node that directs data to different output paths based on defined filtering conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route implements SdkPojo, Serializable, ToCopyableBuilder<Route.Builder, Route> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Route::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Route::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GroupFilters>> GROUP_FILTERS_LIST_FIELD = SdkField
            .<List<GroupFilters>> builder(MarshallingType.LIST)
            .memberName("GroupFiltersList")
            .getter(getter(Route::groupFiltersList))
            .setter(setter(Builder::groupFiltersList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupFiltersList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupFilters> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupFilters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            GROUP_FILTERS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<GroupFilters> groupFiltersList;

    private Route(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.groupFiltersList = builder.groupFiltersList;
    }

    /**
     * <p>
     * The name of the route node.
     * </p>
     * 
     * @return The name of the route node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input connection for the route node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The input connection for the route node.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupFiltersList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupFiltersList() {
        return groupFiltersList != null && !(groupFiltersList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of group filters that define the routing conditions and criteria for directing data to different output
     * paths.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupFiltersList} method.
     * </p>
     * 
     * @return A list of group filters that define the routing conditions and criteria for directing data to different
     *         output paths.
     */
    public final List<GroupFilters> groupFiltersList() {
        return groupFiltersList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupFiltersList() ? groupFiltersList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasGroupFiltersList() == other.hasGroupFiltersList()
                && Objects.equals(groupFiltersList(), other.groupFiltersList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("GroupFiltersList", hasGroupFiltersList() ? groupFiltersList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "GroupFiltersList":
            return Optional.ofNullable(clazz.cast(groupFiltersList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("GroupFiltersList", GROUP_FILTERS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route> {
        /**
         * <p>
         * The name of the route node.
         * </p>
         * 
         * @param name
         *        The name of the route node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The input connection for the route node.
         * </p>
         * 
         * @param inputs
         *        The input connection for the route node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The input connection for the route node.
         * </p>
         * 
         * @param inputs
         *        The input connection for the route node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A list of group filters that define the routing conditions and criteria for directing data to different
         * output paths.
         * </p>
         * 
         * @param groupFiltersList
         *        A list of group filters that define the routing conditions and criteria for directing data to
         *        different output paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupFiltersList(Collection<GroupFilters> groupFiltersList);

        /**
         * <p>
         * A list of group filters that define the routing conditions and criteria for directing data to different
         * output paths.
         * </p>
         * 
         * @param groupFiltersList
         *        A list of group filters that define the routing conditions and criteria for directing data to
         *        different output paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupFiltersList(GroupFilters... groupFiltersList);

        /**
         * <p>
         * A list of group filters that define the routing conditions and criteria for directing data to different
         * output paths.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GroupFilters.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GroupFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GroupFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #groupFiltersList(List<GroupFilters>)}.
         * 
         * @param groupFiltersList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GroupFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupFiltersList(java.util.Collection<GroupFilters>)
         */
        Builder groupFiltersList(Consumer<GroupFilters.Builder>... groupFiltersList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<GroupFilters> groupFiltersList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            name(model.name);
            inputs(model.inputs);
            groupFiltersList(model.groupFiltersList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final List<GroupFilters.Builder> getGroupFiltersList() {
            List<GroupFilters.Builder> result = GroupFiltersListCopier.copyToBuilder(this.groupFiltersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupFiltersList(Collection<GroupFilters.BuilderImpl> groupFiltersList) {
            this.groupFiltersList = GroupFiltersListCopier.copyFromBuilder(groupFiltersList);
        }

        @Override
        public final Builder groupFiltersList(Collection<GroupFilters> groupFiltersList) {
            this.groupFiltersList = GroupFiltersListCopier.copy(groupFiltersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupFiltersList(GroupFilters... groupFiltersList) {
            groupFiltersList(Arrays.asList(groupFiltersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupFiltersList(Consumer<GroupFilters.Builder>... groupFiltersList) {
            groupFiltersList(Stream.of(groupFiltersList).map(c -> GroupFilters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Route build() {
            return new Route(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
