/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the partitioning specification for an Iceberg table, determining how table data will be organized and
 * partitioned for optimal query performance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergPartitionSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergPartitionSpec.Builder, IcebergPartitionSpec> {
    private static final SdkField<List<IcebergPartitionField>> FIELDS_FIELD = SdkField
            .<List<IcebergPartitionField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(IcebergPartitionSpec::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IcebergPartitionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(IcebergPartitionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SPEC_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpecId").getter(getter(IcebergPartitionSpec::specId)).setter(setter(Builder::specId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, SPEC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<IcebergPartitionField> fields;

    private final Integer specId;

    private IcebergPartitionSpec(BuilderImpl builder) {
        this.fields = builder.fields;
        this.specId = builder.specId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partition fields that define how the table data should be partitioned, including source fields and
     * their transformations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The list of partition fields that define how the table data should be partitioned, including source
     *         fields and their transformations.
     */
    public final List<IcebergPartitionField> fields() {
        return fields;
    }

    /**
     * <p>
     * The unique identifier for this partition specification within the Iceberg table's metadata history.
     * </p>
     * 
     * @return The unique identifier for this partition specification within the Iceberg table's metadata history.
     */
    public final Integer specId() {
        return specId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(specId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergPartitionSpec)) {
            return false;
        }
        IcebergPartitionSpec other = (IcebergPartitionSpec) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(specId(), other.specId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergPartitionSpec").add("Fields", hasFields() ? fields() : null).add("SpecId", specId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "SpecId":
            return Optional.ofNullable(clazz.cast(specId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Fields", FIELDS_FIELD);
        map.put("SpecId", SPEC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergPartitionSpec, T> g) {
        return obj -> g.apply((IcebergPartitionSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergPartitionSpec> {
        /**
         * <p>
         * The list of partition fields that define how the table data should be partitioned, including source fields
         * and their transformations.
         * </p>
         * 
         * @param fields
         *        The list of partition fields that define how the table data should be partitioned, including source
         *        fields and their transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<IcebergPartitionField> fields);

        /**
         * <p>
         * The list of partition fields that define how the table data should be partitioned, including source fields
         * and their transformations.
         * </p>
         * 
         * @param fields
         *        The list of partition fields that define how the table data should be partitioned, including source
         *        fields and their transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(IcebergPartitionField... fields);

        /**
         * <p>
         * The list of partition fields that define how the table data should be partitioned, including source fields
         * and their transformations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.IcebergPartitionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.IcebergPartitionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.IcebergPartitionField.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<IcebergPartitionField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.IcebergPartitionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<IcebergPartitionField>)
         */
        Builder fields(Consumer<IcebergPartitionField.Builder>... fields);

        /**
         * <p>
         * The unique identifier for this partition specification within the Iceberg table's metadata history.
         * </p>
         * 
         * @param specId
         *        The unique identifier for this partition specification within the Iceberg table's metadata history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specId(Integer specId);
    }

    static final class BuilderImpl implements Builder {
        private List<IcebergPartitionField> fields = DefaultSdkAutoConstructList.getInstance();

        private Integer specId;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergPartitionSpec model) {
            fields(model.fields);
            specId(model.specId);
        }

        public final List<IcebergPartitionField.Builder> getFields() {
            List<IcebergPartitionField.Builder> result = IcebergPartitionSpecFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<IcebergPartitionField.BuilderImpl> fields) {
            this.fields = IcebergPartitionSpecFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<IcebergPartitionField> fields) {
            this.fields = IcebergPartitionSpecFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(IcebergPartitionField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<IcebergPartitionField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> IcebergPartitionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getSpecId() {
            return specId;
        }

        public final void setSpecId(Integer specId) {
            this.specId = specId;
        }

        @Override
        public final Builder specId(Integer specId) {
            this.specId = specId;
            return this;
        }

        @Override
        public IcebergPartitionSpec build() {
            return new IcebergPartitionSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
