/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a single partition field within an Iceberg partition specification, including the source field,
 * transformation function, partition name, and unique identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergPartitionField implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergPartitionField.Builder, IcebergPartitionField> {
    private static final SdkField<Integer> SOURCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceId").getter(getter(IcebergPartitionField::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> TRANSFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transform").getter(getter(IcebergPartitionField::transform)).setter(setter(Builder::transform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transform").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IcebergPartitionField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> FIELD_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FieldId").getter(getter(IcebergPartitionField::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD,
            TRANSFORM_FIELD, NAME_FIELD, FIELD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer sourceId;

    private final String transform;

    private final String name;

    private final Integer fieldId;

    private IcebergPartitionField(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.transform = builder.transform;
        this.name = builder.name;
        this.fieldId = builder.fieldId;
    }

    /**
     * <p>
     * The identifier of the source field from the table schema that this partition field is based on.
     * </p>
     * 
     * @return The identifier of the source field from the table schema that this partition field is based on.
     */
    public final Integer sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The transformation function applied to the source field to create the partition, such as identity, bucket,
     * truncate, year, month, day, or hour.
     * </p>
     * 
     * @return The transformation function applied to the source field to create the partition, such as identity,
     *         bucket, truncate, year, month, day, or hour.
     */
    public final String transform() {
        return transform;
    }

    /**
     * <p>
     * The name of the partition field as it will appear in the partitioned table structure.
     * </p>
     * 
     * @return The name of the partition field as it will appear in the partitioned table structure.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier assigned to this partition field within the Iceberg table's partition specification.
     * </p>
     * 
     * @return The unique identifier assigned to this partition field within the Iceberg table's partition
     *         specification.
     */
    public final Integer fieldId() {
        return fieldId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(transform());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergPartitionField)) {
            return false;
        }
        IcebergPartitionField other = (IcebergPartitionField) obj;
        return Objects.equals(sourceId(), other.sourceId()) && Objects.equals(transform(), other.transform())
                && Objects.equals(name(), other.name()) && Objects.equals(fieldId(), other.fieldId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergPartitionField").add("SourceId", sourceId()).add("Transform", transform())
                .add("Name", name()).add("FieldId", fieldId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "Transform":
            return Optional.ofNullable(clazz.cast(transform()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("Transform", TRANSFORM_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("FieldId", FIELD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergPartitionField, T> g) {
        return obj -> g.apply((IcebergPartitionField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergPartitionField> {
        /**
         * <p>
         * The identifier of the source field from the table schema that this partition field is based on.
         * </p>
         * 
         * @param sourceId
         *        The identifier of the source field from the table schema that this partition field is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(Integer sourceId);

        /**
         * <p>
         * The transformation function applied to the source field to create the partition, such as identity, bucket,
         * truncate, year, month, day, or hour.
         * </p>
         * 
         * @param transform
         *        The transformation function applied to the source field to create the partition, such as identity,
         *        bucket, truncate, year, month, day, or hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transform(String transform);

        /**
         * <p>
         * The name of the partition field as it will appear in the partitioned table structure.
         * </p>
         * 
         * @param name
         *        The name of the partition field as it will appear in the partitioned table structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier assigned to this partition field within the Iceberg table's partition specification.
         * </p>
         * 
         * @param fieldId
         *        The unique identifier assigned to this partition field within the Iceberg table's partition
         *        specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(Integer fieldId);
    }

    static final class BuilderImpl implements Builder {
        private Integer sourceId;

        private String transform;

        private String name;

        private Integer fieldId;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergPartitionField model) {
            sourceId(model.sourceId);
            transform(model.transform);
            name(model.name);
            fieldId(model.fieldId);
        }

        public final Integer getSourceId() {
            return sourceId;
        }

        public final void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(Integer sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getTransform() {
            return transform;
        }

        public final void setTransform(String transform) {
            this.transform = transform;
        }

        @Override
        public final Builder transform(String transform) {
            this.transform = transform;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getFieldId() {
            return fieldId;
        }

        public final void setFieldId(Integer fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(Integer fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        @Override
        public IcebergPartitionField build() {
            return new IcebergPartitionField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
