/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the data store in the governed Glue Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GovernedCatalogSource implements SdkPojo, Serializable,
        ToCopyableBuilder<GovernedCatalogSource.Builder, GovernedCatalogSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GovernedCatalogSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(GovernedCatalogSource::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(GovernedCatalogSource::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> PARTITION_PREDICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionPredicate").getter(getter(GovernedCatalogSource::partitionPredicate))
            .setter(setter(Builder::partitionPredicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionPredicate").build())
            .build();

    private static final SdkField<S3SourceAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<S3SourceAdditionalOptions> builder(MarshallingType.SDK_POJO).memberName("AdditionalOptions")
            .getter(getter(GovernedCatalogSource::additionalOptions)).setter(setter(Builder::additionalOptions))
            .constructor(S3SourceAdditionalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD,
            TABLE_FIELD, PARTITION_PREDICATE_FIELD, ADDITIONAL_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String database;

    private final String table;

    private final String partitionPredicate;

    private final S3SourceAdditionalOptions additionalOptions;

    private GovernedCatalogSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.partitionPredicate = builder.partitionPredicate;
        this.additionalOptions = builder.additionalOptions;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The database to read from.
     * </p>
     * 
     * @return The database to read from.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database table to read from.
     * </p>
     * 
     * @return The database table to read from.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * Partitions satisfying this predicate are deleted. Files within the retention period in these partitions are not
     * deleted. Set to <code>""</code> – empty by default.
     * </p>
     * 
     * @return Partitions satisfying this predicate are deleted. Files within the retention period in these partitions
     *         are not deleted. Set to <code>""</code> – empty by default.
     */
    public final String partitionPredicate() {
        return partitionPredicate;
    }

    /**
     * <p>
     * Specifies additional connection options.
     * </p>
     * 
     * @return Specifies additional connection options.
     */
    public final S3SourceAdditionalOptions additionalOptions() {
        return additionalOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(partitionPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(additionalOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GovernedCatalogSource)) {
            return false;
        }
        GovernedCatalogSource other = (GovernedCatalogSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(partitionPredicate(), other.partitionPredicate())
                && Objects.equals(additionalOptions(), other.additionalOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GovernedCatalogSource").add("Name", name()).add("Database", database()).add("Table", table())
                .add("PartitionPredicate", partitionPredicate()).add("AdditionalOptions", additionalOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "PartitionPredicate":
            return Optional.ofNullable(clazz.cast(partitionPredicate()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("PartitionPredicate", PARTITION_PREDICATE_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GovernedCatalogSource, T> g) {
        return obj -> g.apply((GovernedCatalogSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GovernedCatalogSource> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param name
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The database to read from.
         * </p>
         * 
         * @param database
         *        The database to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database table to read from.
         * </p>
         * 
         * @param table
         *        The database table to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * Partitions satisfying this predicate are deleted. Files within the retention period in these partitions are
         * not deleted. Set to <code>""</code> – empty by default.
         * </p>
         * 
         * @param partitionPredicate
         *        Partitions satisfying this predicate are deleted. Files within the retention period in these
         *        partitions are not deleted. Set to <code>""</code> – empty by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionPredicate(String partitionPredicate);

        /**
         * <p>
         * Specifies additional connection options.
         * </p>
         * 
         * @param additionalOptions
         *        Specifies additional connection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(S3SourceAdditionalOptions additionalOptions);

        /**
         * <p>
         * Specifies additional connection options.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SourceAdditionalOptions.Builder}
         * avoiding the need to create one manually via {@link S3SourceAdditionalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SourceAdditionalOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalOptions(S3SourceAdditionalOptions)}.
         * 
         * @param additionalOptions
         *        a consumer that will call methods on {@link S3SourceAdditionalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalOptions(S3SourceAdditionalOptions)
         */
        default Builder additionalOptions(Consumer<S3SourceAdditionalOptions.Builder> additionalOptions) {
            return additionalOptions(S3SourceAdditionalOptions.builder().applyMutation(additionalOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String database;

        private String table;

        private String partitionPredicate;

        private S3SourceAdditionalOptions additionalOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GovernedCatalogSource model) {
            name(model.name);
            database(model.database);
            table(model.table);
            partitionPredicate(model.partitionPredicate);
            additionalOptions(model.additionalOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getPartitionPredicate() {
            return partitionPredicate;
        }

        public final void setPartitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
        }

        @Override
        public final Builder partitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
            return this;
        }

        public final S3SourceAdditionalOptions.Builder getAdditionalOptions() {
            return additionalOptions != null ? additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(S3SourceAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(S3SourceAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        @Override
        public GovernedCatalogSource build() {
            return new GovernedCatalogSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
