/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintRequest extends GlueRequest implements
        ToCopyableBuilder<GetBlueprintRequest.Builder, GetBlueprintRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetBlueprintRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> INCLUDE_BLUEPRINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeBlueprint").getter(getter(GetBlueprintRequest::includeBlueprint))
            .setter(setter(Builder::includeBlueprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBlueprint").build()).build();

    private static final SdkField<Boolean> INCLUDE_PARAMETER_SPEC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeParameterSpec").getter(getter(GetBlueprintRequest::includeParameterSpec))
            .setter(setter(Builder::includeParameterSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeParameterSpec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INCLUDE_BLUEPRINT_FIELD, INCLUDE_PARAMETER_SPEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Boolean includeBlueprint;

    private final Boolean includeParameterSpec;

    private GetBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.includeBlueprint = builder.includeBlueprint;
        this.includeParameterSpec = builder.includeParameterSpec;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether or not to include the blueprint in the response.
     * </p>
     * 
     * @return Specifies whether or not to include the blueprint in the response.
     */
    public final Boolean includeBlueprint() {
        return includeBlueprint;
    }

    /**
     * <p>
     * Specifies whether or not to include the parameter specification.
     * </p>
     * 
     * @return Specifies whether or not to include the parameter specification.
     */
    public final Boolean includeParameterSpec() {
        return includeParameterSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(includeBlueprint());
        hashCode = 31 * hashCode + Objects.hashCode(includeParameterSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintRequest)) {
            return false;
        }
        GetBlueprintRequest other = (GetBlueprintRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(includeBlueprint(), other.includeBlueprint())
                && Objects.equals(includeParameterSpec(), other.includeParameterSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlueprintRequest").add("Name", name()).add("IncludeBlueprint", includeBlueprint())
                .add("IncludeParameterSpec", includeParameterSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IncludeBlueprint":
            return Optional.ofNullable(clazz.cast(includeBlueprint()));
        case "IncludeParameterSpec":
            return Optional.ofNullable(clazz.cast(includeParameterSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("IncludeBlueprint", INCLUDE_BLUEPRINT_FIELD);
        map.put("IncludeParameterSpec", INCLUDE_PARAMETER_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintRequest, T> g) {
        return obj -> g.apply((GetBlueprintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBlueprintRequest> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param name
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether or not to include the blueprint in the response.
         * </p>
         * 
         * @param includeBlueprint
         *        Specifies whether or not to include the blueprint in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeBlueprint(Boolean includeBlueprint);

        /**
         * <p>
         * Specifies whether or not to include the parameter specification.
         * </p>
         * 
         * @param includeParameterSpec
         *        Specifies whether or not to include the parameter specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeParameterSpec(Boolean includeParameterSpec);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean includeBlueprint;

        private Boolean includeParameterSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintRequest model) {
            super(model);
            name(model.name);
            includeBlueprint(model.includeBlueprint);
            includeParameterSpec(model.includeParameterSpec);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIncludeBlueprint() {
            return includeBlueprint;
        }

        public final void setIncludeBlueprint(Boolean includeBlueprint) {
            this.includeBlueprint = includeBlueprint;
        }

        @Override
        public final Builder includeBlueprint(Boolean includeBlueprint) {
            this.includeBlueprint = includeBlueprint;
            return this;
        }

        public final Boolean getIncludeParameterSpec() {
            return includeParameterSpec;
        }

        public final void setIncludeParameterSpec(Boolean includeParameterSpec) {
            this.includeParameterSpec = includeParameterSpec;
        }

        @Override
        public final Builder includeParameterSpec(Boolean includeParameterSpec) {
            this.includeParameterSpec = includeParameterSpec;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintRequest build() {
            return new GetBlueprintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
