/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a filter expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterExpression.Builder, FilterExpression> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(FilterExpression::operationAsString)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<Boolean> NEGATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negated").getter(getter(FilterExpression::negated)).setter(setter(Builder::negated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negated").build()).build();

    private static final SdkField<List<FilterValue>> VALUES_FIELD = SdkField
            .<List<FilterValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(FilterExpression::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD,
            NEGATED_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operation;

    private final Boolean negated;

    private final List<FilterValue> values;

    private FilterExpression(BuilderImpl builder) {
        this.operation = builder.operation;
        this.negated = builder.negated;
        this.values = builder.values;
    }

    /**
     * <p>
     * The type of operation to perform in the expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FilterOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The type of operation to perform in the expression.
     * @see FilterOperation
     */
    public final FilterOperation operation() {
        return FilterOperation.fromValue(operation);
    }

    /**
     * <p>
     * The type of operation to perform in the expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FilterOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The type of operation to perform in the expression.
     * @see FilterOperation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * Whether the expression is to be negated.
     * </p>
     * 
     * @return Whether the expression is to be negated.
     */
    public final Boolean negated() {
        return negated;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of filter values.
     */
    public final List<FilterValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(negated());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression) obj;
        return Objects.equals(operationAsString(), other.operationAsString()) && Objects.equals(negated(), other.negated())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterExpression").add("Operation", operationAsString()).add("Negated", negated())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "Negated":
            return Optional.ofNullable(clazz.cast(negated()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operation", OPERATION_FIELD);
        map.put("Negated", NEGATED_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterExpression, T> g) {
        return obj -> g.apply((FilterExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterExpression> {
        /**
         * <p>
         * The type of operation to perform in the expression.
         * </p>
         * 
         * @param operation
         *        The type of operation to perform in the expression.
         * @see FilterOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperation
         */
        Builder operation(String operation);

        /**
         * <p>
         * The type of operation to perform in the expression.
         * </p>
         * 
         * @param operation
         *        The type of operation to perform in the expression.
         * @see FilterOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperation
         */
        Builder operation(FilterOperation operation);

        /**
         * <p>
         * Whether the expression is to be negated.
         * </p>
         * 
         * @param negated
         *        Whether the expression is to be negated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negated(Boolean negated);

        /**
         * <p>
         * A list of filter values.
         * </p>
         * 
         * @param values
         *        A list of filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<FilterValue> values);

        /**
         * <p>
         * A list of filter values.
         * </p>
         * 
         * @param values
         *        A list of filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(FilterValue... values);

        /**
         * <p>
         * A list of filter values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.FilterValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.FilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.FilterValue.Builder#build()} is called immediately and its
         * result is passed to {@link #values(List<FilterValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.FilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<FilterValue>)
         */
        Builder values(Consumer<FilterValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String operation;

        private Boolean negated;

        private List<FilterValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterExpression model) {
            operation(model.operation);
            negated(model.negated);
            values(model.values);
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FilterOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Boolean getNegated() {
            return negated;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final List<FilterValue.Builder> getValues() {
            List<FilterValue.Builder> result = FilterValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<FilterValue.BuilderImpl> values) {
            this.values = FilterValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<FilterValue> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(FilterValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<FilterValue.Builder>... values) {
            values(Stream.of(values).map(c -> FilterValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FilterExpression build() {
            return new FilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
