/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies your data quality evaluation criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateDataQuality implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluateDataQuality.Builder, EvaluateDataQuality> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EvaluateDataQuality::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(EvaluateDataQuality::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ruleset")
            .getter(getter(EvaluateDataQuality::ruleset)).setter(setter(Builder::ruleset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Output")
            .getter(getter(EvaluateDataQuality::outputAsString)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<DQResultsPublishingOptions> PUBLISHING_OPTIONS_FIELD = SdkField
            .<DQResultsPublishingOptions> builder(MarshallingType.SDK_POJO).memberName("PublishingOptions")
            .getter(getter(EvaluateDataQuality::publishingOptions)).setter(setter(Builder::publishingOptions))
            .constructor(DQResultsPublishingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishingOptions").build()).build();

    private static final SdkField<DQStopJobOnFailureOptions> STOP_JOB_ON_FAILURE_OPTIONS_FIELD = SdkField
            .<DQStopJobOnFailureOptions> builder(MarshallingType.SDK_POJO).memberName("StopJobOnFailureOptions")
            .getter(getter(EvaluateDataQuality::stopJobOnFailureOptions)).setter(setter(Builder::stopJobOnFailureOptions))
            .constructor(DQStopJobOnFailureOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopJobOnFailureOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            RULESET_FIELD, OUTPUT_FIELD, PUBLISHING_OPTIONS_FIELD, STOP_JOB_ON_FAILURE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String ruleset;

    private final String output;

    private final DQResultsPublishingOptions publishingOptions;

    private final DQStopJobOnFailureOptions stopJobOnFailureOptions;

    private EvaluateDataQuality(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.ruleset = builder.ruleset;
        this.output = builder.output;
        this.publishingOptions = builder.publishingOptions;
        this.stopJobOnFailureOptions = builder.stopJobOnFailureOptions;
    }

    /**
     * <p>
     * The name of the data quality evaluation.
     * </p>
     * 
     * @return The name of the data quality evaluation.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inputs of your data quality evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The inputs of your data quality evaluation.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The ruleset for your data quality evaluation.
     * </p>
     * 
     * @return The ruleset for your data quality evaluation.
     */
    public final String ruleset() {
        return ruleset;
    }

    /**
     * <p>
     * The output of your data quality evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #output} will
     * return {@link DQTransformOutput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputAsString}.
     * </p>
     * 
     * @return The output of your data quality evaluation.
     * @see DQTransformOutput
     */
    public final DQTransformOutput output() {
        return DQTransformOutput.fromValue(output);
    }

    /**
     * <p>
     * The output of your data quality evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #output} will
     * return {@link DQTransformOutput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputAsString}.
     * </p>
     * 
     * @return The output of your data quality evaluation.
     * @see DQTransformOutput
     */
    public final String outputAsString() {
        return output;
    }

    /**
     * <p>
     * Options to configure how your results are published.
     * </p>
     * 
     * @return Options to configure how your results are published.
     */
    public final DQResultsPublishingOptions publishingOptions() {
        return publishingOptions;
    }

    /**
     * <p>
     * Options to configure how your job will stop if your data quality evaluation fails.
     * </p>
     * 
     * @return Options to configure how your job will stop if your data quality evaluation fails.
     */
    public final DQStopJobOnFailureOptions stopJobOnFailureOptions() {
        return stopJobOnFailureOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(outputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(stopJobOnFailureOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataQuality)) {
            return false;
        }
        EvaluateDataQuality other = (EvaluateDataQuality) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(ruleset(), other.ruleset())
                && Objects.equals(outputAsString(), other.outputAsString())
                && Objects.equals(publishingOptions(), other.publishingOptions())
                && Objects.equals(stopJobOnFailureOptions(), other.stopJobOnFailureOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateDataQuality").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Ruleset", ruleset()).add("Output", outputAsString()).add("PublishingOptions", publishingOptions())
                .add("StopJobOnFailureOptions", stopJobOnFailureOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Ruleset":
            return Optional.ofNullable(clazz.cast(ruleset()));
        case "Output":
            return Optional.ofNullable(clazz.cast(outputAsString()));
        case "PublishingOptions":
            return Optional.ofNullable(clazz.cast(publishingOptions()));
        case "StopJobOnFailureOptions":
            return Optional.ofNullable(clazz.cast(stopJobOnFailureOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Ruleset", RULESET_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("PublishingOptions", PUBLISHING_OPTIONS_FIELD);
        map.put("StopJobOnFailureOptions", STOP_JOB_ON_FAILURE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataQuality, T> g) {
        return obj -> g.apply((EvaluateDataQuality) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluateDataQuality> {
        /**
         * <p>
         * The name of the data quality evaluation.
         * </p>
         * 
         * @param name
         *        The name of the data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The inputs of your data quality evaluation.
         * </p>
         * 
         * @param inputs
         *        The inputs of your data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The inputs of your data quality evaluation.
         * </p>
         * 
         * @param inputs
         *        The inputs of your data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The ruleset for your data quality evaluation.
         * </p>
         * 
         * @param ruleset
         *        The ruleset for your data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleset(String ruleset);

        /**
         * <p>
         * The output of your data quality evaluation.
         * </p>
         * 
         * @param output
         *        The output of your data quality evaluation.
         * @see DQTransformOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DQTransformOutput
         */
        Builder output(String output);

        /**
         * <p>
         * The output of your data quality evaluation.
         * </p>
         * 
         * @param output
         *        The output of your data quality evaluation.
         * @see DQTransformOutput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DQTransformOutput
         */
        Builder output(DQTransformOutput output);

        /**
         * <p>
         * Options to configure how your results are published.
         * </p>
         * 
         * @param publishingOptions
         *        Options to configure how your results are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishingOptions(DQResultsPublishingOptions publishingOptions);

        /**
         * <p>
         * Options to configure how your results are published.
         * </p>
         * This is a convenience method that creates an instance of the {@link DQResultsPublishingOptions.Builder}
         * avoiding the need to create one manually via {@link DQResultsPublishingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DQResultsPublishingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #publishingOptions(DQResultsPublishingOptions)}.
         * 
         * @param publishingOptions
         *        a consumer that will call methods on {@link DQResultsPublishingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishingOptions(DQResultsPublishingOptions)
         */
        default Builder publishingOptions(Consumer<DQResultsPublishingOptions.Builder> publishingOptions) {
            return publishingOptions(DQResultsPublishingOptions.builder().applyMutation(publishingOptions).build());
        }

        /**
         * <p>
         * Options to configure how your job will stop if your data quality evaluation fails.
         * </p>
         * 
         * @param stopJobOnFailureOptions
         *        Options to configure how your job will stop if your data quality evaluation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions);

        /**
         * <p>
         * Options to configure how your job will stop if your data quality evaluation fails.
         * </p>
         * This is a convenience method that creates an instance of the {@link DQStopJobOnFailureOptions.Builder}
         * avoiding the need to create one manually via {@link DQStopJobOnFailureOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DQStopJobOnFailureOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #stopJobOnFailureOptions(DQStopJobOnFailureOptions)}.
         * 
         * @param stopJobOnFailureOptions
         *        a consumer that will call methods on {@link DQStopJobOnFailureOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopJobOnFailureOptions(DQStopJobOnFailureOptions)
         */
        default Builder stopJobOnFailureOptions(Consumer<DQStopJobOnFailureOptions.Builder> stopJobOnFailureOptions) {
            return stopJobOnFailureOptions(DQStopJobOnFailureOptions.builder().applyMutation(stopJobOnFailureOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String ruleset;

        private String output;

        private DQResultsPublishingOptions publishingOptions;

        private DQStopJobOnFailureOptions stopJobOnFailureOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataQuality model) {
            name(model.name);
            inputs(model.inputs);
            ruleset(model.ruleset);
            output(model.output);
            publishingOptions(model.publishingOptions);
            stopJobOnFailureOptions(model.stopJobOnFailureOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getRuleset() {
            return ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        @Override
        public final Builder output(DQTransformOutput output) {
            this.output(output == null ? null : output.toString());
            return this;
        }

        public final DQResultsPublishingOptions.Builder getPublishingOptions() {
            return publishingOptions != null ? publishingOptions.toBuilder() : null;
        }

        public final void setPublishingOptions(DQResultsPublishingOptions.BuilderImpl publishingOptions) {
            this.publishingOptions = publishingOptions != null ? publishingOptions.build() : null;
        }

        @Override
        public final Builder publishingOptions(DQResultsPublishingOptions publishingOptions) {
            this.publishingOptions = publishingOptions;
            return this;
        }

        public final DQStopJobOnFailureOptions.Builder getStopJobOnFailureOptions() {
            return stopJobOnFailureOptions != null ? stopJobOnFailureOptions.toBuilder() : null;
        }

        public final void setStopJobOnFailureOptions(DQStopJobOnFailureOptions.BuilderImpl stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions != null ? stopJobOnFailureOptions.build() : null;
        }

        @Override
        public final Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions;
            return this;
        }

        @Override
        public EvaluateDataQuality build() {
            return new EvaluateDataQuality(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
