/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity supported by a given <code>ConnectionType</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entity implements SdkPojo, Serializable, ToCopyableBuilder<Entity.Builder, Entity> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityName").getter(getter(Entity::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(Entity::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Boolean> IS_PARENT_ENTITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsParentEntity").getter(getter(Entity::isParentEntity)).setter(setter(Builder::isParentEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParentEntity").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Entity::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(Entity::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomProperties")
            .getter(getter(Entity::customProperties))
            .setter(setter(Builder::customProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD,
            LABEL_FIELD, IS_PARENT_ENTITY_FIELD, DESCRIPTION_FIELD, CATEGORY_FIELD, CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entityName;

    private final String label;

    private final Boolean isParentEntity;

    private final String description;

    private final String category;

    private final Map<String, String> customProperties;

    private Entity(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.label = builder.label;
        this.isParentEntity = builder.isParentEntity;
        this.description = builder.description;
        this.category = builder.category;
        this.customProperties = builder.customProperties;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * Label used for the entity.
     * </p>
     * 
     * @return Label used for the entity.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * A Boolean value which helps to determine whether there are sub objects that can be listed.
     * </p>
     * 
     * @return A Boolean value which helps to determine whether there are sub objects that can be listed.
     */
    public final Boolean isParentEntity() {
        return isParentEntity;
    }

    /**
     * <p>
     * A description of the entity.
     * </p>
     * 
     * @return A description of the entity.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of entities that are present in the response. This value depends on the source connection. For example
     * this is <code>SObjects</code> for Salesforce and <code>databases</code> or <code>schemas</code> or
     * <code>tables</code> for sources like Amazon Redshift.
     * </p>
     * 
     * @return The type of entities that are present in the response. This value depends on the source connection. For
     *         example this is <code>SObjects</code> for Salesforce and <code>databases</code> or <code>schemas</code>
     *         or <code>tables</code> for sources like Amazon Redshift.
     */
    public final String category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProperties() {
        return customProperties != null && !(customProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional map of keys which may be returned for an entity by a connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProperties} method.
     * </p>
     * 
     * @return An optional map of keys which may be returned for an entity by a connector.
     */
    public final Map<String, String> customProperties() {
        return customProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(isParentEntity());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProperties() ? customProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity) obj;
        return Objects.equals(entityName(), other.entityName()) && Objects.equals(label(), other.label())
                && Objects.equals(isParentEntity(), other.isParentEntity()) && Objects.equals(description(), other.description())
                && Objects.equals(category(), other.category()) && hasCustomProperties() == other.hasCustomProperties()
                && Objects.equals(customProperties(), other.customProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entity").add("EntityName", entityName()).add("Label", label())
                .add("IsParentEntity", isParentEntity()).add("Description", description()).add("Category", category())
                .add("CustomProperties", hasCustomProperties() ? customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "IsParentEntity":
            return Optional.ofNullable(clazz.cast(isParentEntity()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "CustomProperties":
            return Optional.ofNullable(clazz.cast(customProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EntityName", ENTITY_NAME_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("IsParentEntity", IS_PARENT_ENTITY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entity> {
        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param entityName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * Label used for the entity.
         * </p>
         * 
         * @param label
         *        Label used for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * A Boolean value which helps to determine whether there are sub objects that can be listed.
         * </p>
         * 
         * @param isParentEntity
         *        A Boolean value which helps to determine whether there are sub objects that can be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isParentEntity(Boolean isParentEntity);

        /**
         * <p>
         * A description of the entity.
         * </p>
         * 
         * @param description
         *        A description of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of entities that are present in the response. This value depends on the source connection. For
         * example this is <code>SObjects</code> for Salesforce and <code>databases</code> or <code>schemas</code> or
         * <code>tables</code> for sources like Amazon Redshift.
         * </p>
         * 
         * @param category
         *        The type of entities that are present in the response. This value depends on the source connection.
         *        For example this is <code>SObjects</code> for Salesforce and <code>databases</code> or
         *        <code>schemas</code> or <code>tables</code> for sources like Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * An optional map of keys which may be returned for an entity by a connector.
         * </p>
         * 
         * @param customProperties
         *        An optional map of keys which may be returned for an entity by a connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProperties(Map<String, String> customProperties);
    }

    static final class BuilderImpl implements Builder {
        private String entityName;

        private String label;

        private Boolean isParentEntity;

        private String description;

        private String category;

        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            entityName(model.entityName);
            label(model.label);
            isParentEntity(model.isParentEntity);
            description(model.description);
            category(model.category);
            customProperties(model.customProperties);
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getIsParentEntity() {
            return isParentEntity;
        }

        public final void setIsParentEntity(Boolean isParentEntity) {
            this.isParentEntity = isParentEntity;
        }

        @Override
        public final Builder isParentEntity(Boolean isParentEntity) {
            this.isParentEntity = isParentEntity;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
