/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityResponse extends GlueResponse implements
        ToCopyableBuilder<DescribeEntityResponse.Builder, DescribeEntityResponse> {
    private static final SdkField<List<Field>> FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(DescribeEntityResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEntityResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Field> fields;

    private final String nextToken;

    private DescribeEntityResponse(BuilderImpl builder) {
        super(builder);
        this.fields = builder.fields;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
     * <code>Field</code> is very similar to column in a database. The <code>Field</code> object has information about
     * different properties associated with fields in the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
     *         <code>Field</code> is very similar to column in a database. The <code>Field</code> object has information
     *         about different properties associated with fields in the connector.
     */
    public final List<Field> fields() {
        return fields;
    }

    /**
     * <p>
     * A continuation token, present if the current segment is not the last.
     * </p>
     * 
     * @return A continuation token, present if the current segment is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityResponse)) {
            return false;
        }
        DescribeEntityResponse other = (DescribeEntityResponse) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityResponse").add("Fields", hasFields() ? fields() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Fields", FIELDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityResponse, T> g) {
        return obj -> g.apply((DescribeEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEntityResponse> {
        /**
         * <p>
         * Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
         * <code>Field</code> is very similar to column in a database. The <code>Field</code> object has information
         * about different properties associated with fields in the connector.
         * </p>
         * 
         * @param fields
         *        Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
         *        <code>Field</code> is very similar to column in a database. The <code>Field</code> object has
         *        information about different properties associated with fields in the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<Field> fields);

        /**
         * <p>
         * Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
         * <code>Field</code> is very similar to column in a database. The <code>Field</code> object has information
         * about different properties associated with fields in the connector.
         * </p>
         * 
         * @param fields
         *        Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
         *        <code>Field</code> is very similar to column in a database. The <code>Field</code> object has
         *        information about different properties associated with fields in the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Field... fields);

        /**
         * <p>
         * Describes the fields for that connector entity. This is the list of <code>Field</code> objects.
         * <code>Field</code> is very similar to column in a database. The <code>Field</code> object has information
         * about different properties associated with fields in the connector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Field.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.glue.model.Field#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.glue.model.Field.Builder#build()}
         * is called immediately and its result is passed to {@link #fields(List<Field>)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<Field>)
         */
        Builder fields(Consumer<Field.Builder>... fields);

        /**
         * <p>
         * A continuation token, present if the current segment is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, present if the current segment is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Field> fields = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityResponse model) {
            super(model);
            fields(model.fields);
            nextToken(model.nextToken);
        }

        public final List<Field.Builder> getFields() {
            List<Field.Builder> result = FieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<Field.BuilderImpl> fields) {
            this.fields = FieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = FieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<Field.Builder>... fields) {
            fields(Stream.of(fields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEntityResponse build() {
            return new DescribeEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
