/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSchemaVersionsResponse extends GlueResponse implements
        ToCopyableBuilder<DeleteSchemaVersionsResponse.Builder, DeleteSchemaVersionsResponse> {
    private static final SdkField<List<SchemaVersionErrorItem>> SCHEMA_VERSION_ERRORS_FIELD = SdkField
            .<List<SchemaVersionErrorItem>> builder(MarshallingType.LIST)
            .memberName("SchemaVersionErrors")
            .getter(getter(DeleteSchemaVersionsResponse::schemaVersionErrors))
            .setter(setter(Builder::schemaVersionErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaVersionErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaVersionErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SchemaVersionErrorItem> schemaVersionErrors;

    private DeleteSchemaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionErrors = builder.schemaVersionErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaVersionErrors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSchemaVersionErrors() {
        return schemaVersionErrors != null && !(schemaVersionErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaVersionErrors} method.
     * </p>
     * 
     * @return A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
     */
    public final List<SchemaVersionErrorItem> schemaVersionErrors() {
        return schemaVersionErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaVersionErrors() ? schemaVersionErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSchemaVersionsResponse)) {
            return false;
        }
        DeleteSchemaVersionsResponse other = (DeleteSchemaVersionsResponse) obj;
        return hasSchemaVersionErrors() == other.hasSchemaVersionErrors()
                && Objects.equals(schemaVersionErrors(), other.schemaVersionErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSchemaVersionsResponse")
                .add("SchemaVersionErrors", hasSchemaVersionErrors() ? schemaVersionErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaVersionErrors":
            return Optional.ofNullable(clazz.cast(schemaVersionErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaVersionErrors", SCHEMA_VERSION_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSchemaVersionsResponse, T> g) {
        return obj -> g.apply((DeleteSchemaVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSchemaVersionsResponse> {
        /**
         * <p>
         * A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
         * </p>
         * 
         * @param schemaVersionErrors
         *        A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionErrors(Collection<SchemaVersionErrorItem> schemaVersionErrors);

        /**
         * <p>
         * A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
         * </p>
         * 
         * @param schemaVersionErrors
         *        A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionErrors(SchemaVersionErrorItem... schemaVersionErrors);

        /**
         * <p>
         * A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.SchemaVersionErrorItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.SchemaVersionErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.SchemaVersionErrorItem.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaVersionErrors(List<SchemaVersionErrorItem>)}.
         * 
         * @param schemaVersionErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.SchemaVersionErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersionErrors(java.util.Collection<SchemaVersionErrorItem>)
         */
        Builder schemaVersionErrors(Consumer<SchemaVersionErrorItem.Builder>... schemaVersionErrors);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<SchemaVersionErrorItem> schemaVersionErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSchemaVersionsResponse model) {
            super(model);
            schemaVersionErrors(model.schemaVersionErrors);
        }

        public final List<SchemaVersionErrorItem.Builder> getSchemaVersionErrors() {
            List<SchemaVersionErrorItem.Builder> result = SchemaVersionErrorListCopier.copyToBuilder(this.schemaVersionErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaVersionErrors(Collection<SchemaVersionErrorItem.BuilderImpl> schemaVersionErrors) {
            this.schemaVersionErrors = SchemaVersionErrorListCopier.copyFromBuilder(schemaVersionErrors);
        }

        @Override
        public final Builder schemaVersionErrors(Collection<SchemaVersionErrorItem> schemaVersionErrors) {
            this.schemaVersionErrors = SchemaVersionErrorListCopier.copy(schemaVersionErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersionErrors(SchemaVersionErrorItem... schemaVersionErrors) {
            schemaVersionErrors(Arrays.asList(schemaVersionErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersionErrors(Consumer<SchemaVersionErrorItem.Builder>... schemaVersionErrors) {
            schemaVersionErrors(Stream.of(schemaVersionErrors)
                    .map(c -> SchemaVersionErrorItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteSchemaVersionsResponse build() {
            return new DeleteSchemaVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
