/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the observation generated after evaluating the rules and analyzers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityObservation implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityObservation.Builder, DataQualityObservation> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataQualityObservation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<MetricBasedObservation> METRIC_BASED_OBSERVATION_FIELD = SdkField
            .<MetricBasedObservation> builder(MarshallingType.SDK_POJO).memberName("MetricBasedObservation")
            .getter(getter(DataQualityObservation::metricBasedObservation)).setter(setter(Builder::metricBasedObservation))
            .constructor(MetricBasedObservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricBasedObservation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            METRIC_BASED_OBSERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final MetricBasedObservation metricBasedObservation;

    private DataQualityObservation(BuilderImpl builder) {
        this.description = builder.description;
        this.metricBasedObservation = builder.metricBasedObservation;
    }

    /**
     * <p>
     * A description of the data quality observation.
     * </p>
     * 
     * @return A description of the data quality observation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object of type <code>MetricBasedObservation</code> representing the observation that is based on evaluated
     * data quality metrics.
     * </p>
     * 
     * @return An object of type <code>MetricBasedObservation</code> representing the observation that is based on
     *         evaluated data quality metrics.
     */
    public final MetricBasedObservation metricBasedObservation() {
        return metricBasedObservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(metricBasedObservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityObservation)) {
            return false;
        }
        DataQualityObservation other = (DataQualityObservation) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(metricBasedObservation(), other.metricBasedObservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityObservation")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MetricBasedObservation", metricBasedObservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MetricBasedObservation":
            return Optional.ofNullable(clazz.cast(metricBasedObservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MetricBasedObservation", METRIC_BASED_OBSERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityObservation, T> g) {
        return obj -> g.apply((DataQualityObservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityObservation> {
        /**
         * <p>
         * A description of the data quality observation.
         * </p>
         * 
         * @param description
         *        A description of the data quality observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object of type <code>MetricBasedObservation</code> representing the observation that is based on evaluated
         * data quality metrics.
         * </p>
         * 
         * @param metricBasedObservation
         *        An object of type <code>MetricBasedObservation</code> representing the observation that is based on
         *        evaluated data quality metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricBasedObservation(MetricBasedObservation metricBasedObservation);

        /**
         * <p>
         * An object of type <code>MetricBasedObservation</code> representing the observation that is based on evaluated
         * data quality metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricBasedObservation.Builder} avoiding
         * the need to create one manually via {@link MetricBasedObservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricBasedObservation.Builder#build()} is called immediately and
         * its result is passed to {@link #metricBasedObservation(MetricBasedObservation)}.
         * 
         * @param metricBasedObservation
         *        a consumer that will call methods on {@link MetricBasedObservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricBasedObservation(MetricBasedObservation)
         */
        default Builder metricBasedObservation(Consumer<MetricBasedObservation.Builder> metricBasedObservation) {
            return metricBasedObservation(MetricBasedObservation.builder().applyMutation(metricBasedObservation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private MetricBasedObservation metricBasedObservation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityObservation model) {
            description(model.description);
            metricBasedObservation(model.metricBasedObservation);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MetricBasedObservation.Builder getMetricBasedObservation() {
            return metricBasedObservation != null ? metricBasedObservation.toBuilder() : null;
        }

        public final void setMetricBasedObservation(MetricBasedObservation.BuilderImpl metricBasedObservation) {
            this.metricBasedObservation = metricBasedObservation != null ? metricBasedObservation.build() : null;
        }

        @Override
        public final Builder metricBasedObservation(MetricBasedObservation metricBasedObservation) {
            this.metricBasedObservation = metricBasedObservation;
            return this;
        }

        @Override
        public DataQualityObservation build() {
            return new DataQualityObservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
