/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomEntityTypeRequest extends GlueRequest implements
        ToCopyableBuilder<CreateCustomEntityTypeRequest.Builder, CreateCustomEntityTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCustomEntityTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGEX_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexString").getter(getter(CreateCustomEntityTypeRequest::regexString))
            .setter(setter(Builder::regexString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexString").build()).build();

    private static final SdkField<List<String>> CONTEXT_WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContextWords")
            .getter(getter(CreateCustomEntityTypeRequest::contextWords))
            .setter(setter(Builder::contextWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCustomEntityTypeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REGEX_STRING_FIELD, CONTEXT_WORDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String regexString;

    private final List<String> contextWords;

    private final Map<String, String> tags;

    private CreateCustomEntityTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.regexString = builder.regexString;
        this.contextWords = builder.contextWords;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the custom pattern that allows it to be retrieved or deleted later. This name must be unique per
     * Amazon Web Services account.
     * </p>
     * 
     * @return A name for the custom pattern that allows it to be retrieved or deleted later. This name must be unique
     *         per Amazon Web Services account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     * 
     * @return A regular expression string that is used for detecting sensitive data in a custom pattern.
     */
    public final String regexString() {
        return regexString;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextWords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextWords() {
        return contextWords != null && !(contextWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of context words. If none of these context words are found within the vicinity of the regular expression
     * the data will not be detected as sensitive data.
     * </p>
     * <p>
     * If no context words are passed only a regular expression is checked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextWords} method.
     * </p>
     * 
     * @return A list of context words. If none of these context words are found within the vicinity of the regular
     *         expression the data will not be detected as sensitive data.</p>
     *         <p>
     *         If no context words are passed only a regular expression is checked.
     */
    public final List<String> contextWords() {
        return contextWords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags applied to the custom entity type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags applied to the custom entity type.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regexString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContextWords() ? contextWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomEntityTypeRequest)) {
            return false;
        }
        CreateCustomEntityTypeRequest other = (CreateCustomEntityTypeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(regexString(), other.regexString())
                && hasContextWords() == other.hasContextWords() && Objects.equals(contextWords(), other.contextWords())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomEntityTypeRequest").add("Name", name()).add("RegexString", regexString())
                .add("ContextWords", hasContextWords() ? contextWords() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RegexString":
            return Optional.ofNullable(clazz.cast(regexString()));
        case "ContextWords":
            return Optional.ofNullable(clazz.cast(contextWords()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RegexString", REGEX_STRING_FIELD);
        map.put("ContextWords", CONTEXT_WORDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomEntityTypeRequest, T> g) {
        return obj -> g.apply((CreateCustomEntityTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomEntityTypeRequest> {
        /**
         * <p>
         * A name for the custom pattern that allows it to be retrieved or deleted later. This name must be unique per
         * Amazon Web Services account.
         * </p>
         * 
         * @param name
         *        A name for the custom pattern that allows it to be retrieved or deleted later. This name must be
         *        unique per Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A regular expression string that is used for detecting sensitive data in a custom pattern.
         * </p>
         * 
         * @param regexString
         *        A regular expression string that is used for detecting sensitive data in a custom pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexString(String regexString);

        /**
         * <p>
         * A list of context words. If none of these context words are found within the vicinity of the regular
         * expression the data will not be detected as sensitive data.
         * </p>
         * <p>
         * If no context words are passed only a regular expression is checked.
         * </p>
         * 
         * @param contextWords
         *        A list of context words. If none of these context words are found within the vicinity of the regular
         *        expression the data will not be detected as sensitive data.</p>
         *        <p>
         *        If no context words are passed only a regular expression is checked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextWords(Collection<String> contextWords);

        /**
         * <p>
         * A list of context words. If none of these context words are found within the vicinity of the regular
         * expression the data will not be detected as sensitive data.
         * </p>
         * <p>
         * If no context words are passed only a regular expression is checked.
         * </p>
         * 
         * @param contextWords
         *        A list of context words. If none of these context words are found within the vicinity of the regular
         *        expression the data will not be detected as sensitive data.</p>
         *        <p>
         *        If no context words are passed only a regular expression is checked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextWords(String... contextWords);

        /**
         * <p>
         * A list of tags applied to the custom entity type.
         * </p>
         * 
         * @param tags
         *        A list of tags applied to the custom entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String regexString;

        private List<String> contextWords = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomEntityTypeRequest model) {
            super(model);
            name(model.name);
            regexString(model.regexString);
            contextWords(model.contextWords);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegexString() {
            return regexString;
        }

        public final void setRegexString(String regexString) {
            this.regexString = regexString;
        }

        @Override
        public final Builder regexString(String regexString) {
            this.regexString = regexString;
            return this;
        }

        public final Collection<String> getContextWords() {
            if (contextWords instanceof SdkAutoConstructList) {
                return null;
            }
            return contextWords;
        }

        public final void setContextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
        }

        @Override
        public final Builder contextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextWords(String... contextWords) {
            contextWords(Arrays.asList(contextWords));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomEntityTypeRequest build() {
            return new CreateCustomEntityTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
