/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateColumnStatisticsTaskSettingsRequest extends GlueRequest implements
        ToCopyableBuilder<CreateColumnStatisticsTaskSettingsRequest.Builder, CreateColumnStatisticsTaskSettingsRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateColumnStatisticsTaskSettingsRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(CreateColumnStatisticsTaskSettingsRequest::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateColumnStatisticsTaskSettingsRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateColumnStatisticsTaskSettingsRequest::schedule))
            .setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnNameList")
            .getter(getter(CreateColumnStatisticsTaskSettingsRequest::columnNameList))
            .setter(setter(Builder::columnNameList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleSize").getter(getter(CreateColumnStatisticsTaskSettingsRequest::sampleSize))
            .setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogID").getter(getter(CreateColumnStatisticsTaskSettingsRequest::catalogID))
            .setter(setter(Builder::catalogID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(CreateColumnStatisticsTaskSettingsRequest::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateColumnStatisticsTaskSettingsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, ROLE_FIELD, SCHEDULE_FIELD, COLUMN_NAME_LIST_FIELD, SAMPLE_SIZE_FIELD, CATALOG_ID_FIELD,
            SECURITY_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String databaseName;

    private final String tableName;

    private final String role;

    private final String schedule;

    private final List<String> columnNameList;

    private final Double sampleSize;

    private final String catalogID;

    private final String securityConfiguration;

    private final Map<String, String> tags;

    private CreateColumnStatisticsTaskSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.role = builder.role;
        this.schedule = builder.schedule;
        this.columnNameList = builder.columnNameList;
        this.sampleSize = builder.sampleSize;
        this.catalogID = builder.catalogID;
        this.securityConfiguration = builder.securityConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the database where the table resides.
     * </p>
     * 
     * @return The name of the database where the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table for which to generate column statistics.
     * </p>
     * 
     * @return The name of the table for which to generate column statistics.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The role used for running the column statistics.
     * </p>
     * 
     * @return The role used for running the column statistics.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * A schedule for running the column statistics, specified in CRON syntax.
     * </p>
     * 
     * @return A schedule for running the column statistics, specified in CRON syntax.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNameList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNameList() {
        return columnNameList != null && !(columnNameList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column names for which to run statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNameList} method.
     * </p>
     * 
     * @return A list of column names for which to run statistics.
     */
    public final List<String> columnNameList() {
        return columnNameList;
    }

    /**
     * <p>
     * The percentage of data to sample.
     * </p>
     * 
     * @return The percentage of data to sample.
     */
    public final Double sampleSize() {
        return sampleSize;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the database resides.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the database resides.
     */
    public final String catalogID() {
        return catalogID;
    }

    /**
     * <p>
     * Name of the security configuration that is used to encrypt CloudWatch logs.
     * </p>
     * 
     * @return Name of the security configuration that is used to encrypt CloudWatch logs.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNameList() ? columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateColumnStatisticsTaskSettingsRequest)) {
            return false;
        }
        CreateColumnStatisticsTaskSettingsRequest other = (CreateColumnStatisticsTaskSettingsRequest) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(role(), other.role()) && Objects.equals(schedule(), other.schedule())
                && hasColumnNameList() == other.hasColumnNameList() && Objects.equals(columnNameList(), other.columnNameList())
                && Objects.equals(sampleSize(), other.sampleSize()) && Objects.equals(catalogID(), other.catalogID())
                && Objects.equals(securityConfiguration(), other.securityConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateColumnStatisticsTaskSettingsRequest").add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("Role", role()).add("Schedule", schedule())
                .add("ColumnNameList", hasColumnNameList() ? columnNameList() : null).add("SampleSize", sampleSize())
                .add("CatalogID", catalogID()).add("SecurityConfiguration", securityConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ColumnNameList":
            return Optional.ofNullable(clazz.cast(columnNameList()));
        case "SampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "CatalogID":
            return Optional.ofNullable(clazz.cast(catalogID()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("ColumnNameList", COLUMN_NAME_LIST_FIELD);
        map.put("SampleSize", SAMPLE_SIZE_FIELD);
        map.put("CatalogID", CATALOG_ID_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateColumnStatisticsTaskSettingsRequest, T> g) {
        return obj -> g.apply((CreateColumnStatisticsTaskSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateColumnStatisticsTaskSettingsRequest> {
        /**
         * <p>
         * The name of the database where the table resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table for which to generate column statistics.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which to generate column statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The role used for running the column statistics.
         * </p>
         * 
         * @param role
         *        The role used for running the column statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * A schedule for running the column statistics, specified in CRON syntax.
         * </p>
         * 
         * @param schedule
         *        A schedule for running the column statistics, specified in CRON syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * A list of column names for which to run statistics.
         * </p>
         * 
         * @param columnNameList
         *        A list of column names for which to run statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(Collection<String> columnNameList);

        /**
         * <p>
         * A list of column names for which to run statistics.
         * </p>
         * 
         * @param columnNameList
         *        A list of column names for which to run statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(String... columnNameList);

        /**
         * <p>
         * The percentage of data to sample.
         * </p>
         * 
         * @param sampleSize
         *        The percentage of data to sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Double sampleSize);

        /**
         * <p>
         * The ID of the Data Catalog in which the database resides.
         * </p>
         * 
         * @param catalogID
         *        The ID of the Data Catalog in which the database resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogID(String catalogID);

        /**
         * <p>
         * Name of the security configuration that is used to encrypt CloudWatch logs.
         * </p>
         * 
         * @param securityConfiguration
         *        Name of the security configuration that is used to encrypt CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * A map of tags.
         * </p>
         * 
         * @param tags
         *        A map of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private String role;

        private String schedule;

        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();

        private Double sampleSize;

        private String catalogID;

        private String securityConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateColumnStatisticsTaskSettingsRequest model) {
            super(model);
            databaseName(model.databaseName);
            tableName(model.tableName);
            role(model.role);
            schedule(model.schedule);
            columnNameList(model.columnNameList);
            sampleSize(model.sampleSize);
            catalogID(model.catalogID);
            securityConfiguration(model.securityConfiguration);
            tags(model.tags);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String... columnNameList) {
            columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final Double getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getCatalogID() {
            return catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateColumnStatisticsTaskSettingsRequest build() {
            return new CreateColumnStatisticsTaskSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
