/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a variant of a connection type in Glue Data Catalog. Connection type variants provide specific
 * configurations and behaviors for different implementations of the same general connection type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionTypeVariant implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionTypeVariant.Builder, ConnectionTypeVariant> {
    private static final SdkField<String> CONNECTION_TYPE_VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionTypeVariantName").getter(getter(ConnectionTypeVariant::connectionTypeVariantName))
            .setter(setter(Builder::connectionTypeVariantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypeVariantName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(ConnectionTypeVariant::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectionTypeVariant::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogoUrl").getter(getter(ConnectionTypeVariant::logoUrl)).setter(setter(Builder::logoUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_TYPE_VARIANT_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, LOGO_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionTypeVariantName;

    private final String displayName;

    private final String description;

    private final String logoUrl;

    private ConnectionTypeVariant(BuilderImpl builder) {
        this.connectionTypeVariantName = builder.connectionTypeVariantName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.logoUrl = builder.logoUrl;
    }

    /**
     * <p>
     * The unique identifier for the connection type variant. This name is used internally to identify the specific
     * variant of a connection type.
     * </p>
     * 
     * @return The unique identifier for the connection type variant. This name is used internally to identify the
     *         specific variant of a connection type.
     */
    public final String connectionTypeVariantName() {
        return connectionTypeVariantName;
    }

    /**
     * <p>
     * The human-readable name for the connection type variant that is displayed in the Glue console.
     * </p>
     * 
     * @return The human-readable name for the connection type variant that is displayed in the Glue console.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A detailed description of the connection type variant, including its purpose, use cases, and any specific
     * configuration requirements.
     * </p>
     * 
     * @return A detailed description of the connection type variant, including its purpose, use cases, and any specific
     *         configuration requirements.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URL of the logo associated with a connection type variant.
     * </p>
     * 
     * @return The URL of the logo associated with a connection type variant.
     */
    public final String logoUrl() {
        return logoUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeVariantName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logoUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeVariant)) {
            return false;
        }
        ConnectionTypeVariant other = (ConnectionTypeVariant) obj;
        return Objects.equals(connectionTypeVariantName(), other.connectionTypeVariantName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(logoUrl(), other.logoUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionTypeVariant").add("ConnectionTypeVariantName", connectionTypeVariantName())
                .add("DisplayName", displayName()).add("Description", description()).add("LogoUrl", logoUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionTypeVariantName":
            return Optional.ofNullable(clazz.cast(connectionTypeVariantName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LogoUrl":
            return Optional.ofNullable(clazz.cast(logoUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionTypeVariantName", CONNECTION_TYPE_VARIANT_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LogoUrl", LOGO_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeVariant, T> g) {
        return obj -> g.apply((ConnectionTypeVariant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionTypeVariant> {
        /**
         * <p>
         * The unique identifier for the connection type variant. This name is used internally to identify the specific
         * variant of a connection type.
         * </p>
         * 
         * @param connectionTypeVariantName
         *        The unique identifier for the connection type variant. This name is used internally to identify the
         *        specific variant of a connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTypeVariantName(String connectionTypeVariantName);

        /**
         * <p>
         * The human-readable name for the connection type variant that is displayed in the Glue console.
         * </p>
         * 
         * @param displayName
         *        The human-readable name for the connection type variant that is displayed in the Glue console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A detailed description of the connection type variant, including its purpose, use cases, and any specific
         * configuration requirements.
         * </p>
         * 
         * @param description
         *        A detailed description of the connection type variant, including its purpose, use cases, and any
         *        specific configuration requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL of the logo associated with a connection type variant.
         * </p>
         * 
         * @param logoUrl
         *        The URL of the logo associated with a connection type variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoUrl(String logoUrl);
    }

    static final class BuilderImpl implements Builder {
        private String connectionTypeVariantName;

        private String displayName;

        private String description;

        private String logoUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeVariant model) {
            connectionTypeVariantName(model.connectionTypeVariantName);
            displayName(model.displayName);
            description(model.description);
            logoUrl(model.logoUrl);
        }

        public final String getConnectionTypeVariantName() {
            return connectionTypeVariantName;
        }

        public final void setConnectionTypeVariantName(String connectionTypeVariantName) {
            this.connectionTypeVariantName = connectionTypeVariantName;
        }

        @Override
        public final Builder connectionTypeVariantName(String connectionTypeVariantName) {
            this.connectionTypeVariantName = connectionTypeVariantName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLogoUrl() {
            return logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public ConnectionTypeVariant build() {
            return new ConnectionTypeVariant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
