/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ConnectionType {
    JDBC("JDBC"),

    SFTP("SFTP"),

    MONGODB("MONGODB"),

    KAFKA("KAFKA"),

    NETWORK("NETWORK"),

    MARKETPLACE("MARKETPLACE"),

    CUSTOM("CUSTOM"),

    SALESFORCE("SALESFORCE"),

    VIEW_VALIDATION_REDSHIFT("VIEW_VALIDATION_REDSHIFT"),

    VIEW_VALIDATION_ATHENA("VIEW_VALIDATION_ATHENA"),

    GOOGLEADS("GOOGLEADS"),

    GOOGLESHEETS("GOOGLESHEETS"),

    GOOGLEANALYTICS4("GOOGLEANALYTICS4"),

    SERVICENOW("SERVICENOW"),

    MARKETO("MARKETO"),

    SAPODATA("SAPODATA"),

    ZENDESK("ZENDESK"),

    JIRACLOUD("JIRACLOUD"),

    NETSUITEERP("NETSUITEERP"),

    HUBSPOT("HUBSPOT"),

    FACEBOOKADS("FACEBOOKADS"),

    INSTAGRAMADS("INSTAGRAMADS"),

    ZOHOCRM("ZOHOCRM"),

    SALESFORCEPARDOT("SALESFORCEPARDOT"),

    SALESFORCEMARKETINGCLOUD("SALESFORCEMARKETINGCLOUD"),

    ADOBEANALYTICS("ADOBEANALYTICS"),

    SLACK("SLACK"),

    LINKEDIN("LINKEDIN"),

    MIXPANEL("MIXPANEL"),

    ASANA("ASANA"),

    STRIPE("STRIPE"),

    SMARTSHEET("SMARTSHEET"),

    DATADOG("DATADOG"),

    WOOCOMMERCE("WOOCOMMERCE"),

    INTERCOM("INTERCOM"),

    SNAPCHATADS("SNAPCHATADS"),

    PAYPAL("PAYPAL"),

    QUICKBOOKS("QUICKBOOKS"),

    FACEBOOKPAGEINSIGHTS("FACEBOOKPAGEINSIGHTS"),

    FRESHDESK("FRESHDESK"),

    TWILIO("TWILIO"),

    DOCUSIGNMONITOR("DOCUSIGNMONITOR"),

    FRESHSALES("FRESHSALES"),

    ZOOM("ZOOM"),

    GOOGLESEARCHCONSOLE("GOOGLESEARCHCONSOLE"),

    SALESFORCECOMMERCECLOUD("SALESFORCECOMMERCECLOUD"),

    SAPCONCUR("SAPCONCUR"),

    DYNATRACE("DYNATRACE"),

    MICROSOFTDYNAMIC365_FINANCEANDOPS("MICROSOFTDYNAMIC365FINANCEANDOPS"),

    MICROSOFTTEAMS("MICROSOFTTEAMS"),

    BLACKBAUDRAISEREDGENXT("BLACKBAUDRAISEREDGENXT"),

    MAILCHIMP("MAILCHIMP"),

    GITLAB("GITLAB"),

    PENDO("PENDO"),

    PRODUCTBOARD("PRODUCTBOARD"),

    CIRCLECI("CIRCLECI"),

    PIPEDIVE("PIPEDIVE"),

    SENDGRID("SENDGRID"),

    AZURECOSMOS("AZURECOSMOS"),

    AZURESQL("AZURESQL"),

    BIGQUERY("BIGQUERY"),

    BLACKBAUD("BLACKBAUD"),

    CLOUDERAHIVE("CLOUDERAHIVE"),

    CLOUDERAIMPALA("CLOUDERAIMPALA"),

    CLOUDWATCH("CLOUDWATCH"),

    CLOUDWATCHMETRICS("CLOUDWATCHMETRICS"),

    CMDB("CMDB"),

    DATALAKEGEN2("DATALAKEGEN2"),

    DB2("DB2"),

    DB2_AS400("DB2AS400"),

    DOCUMENTDB("DOCUMENTDB"),

    DOMO("DOMO"),

    DYNAMODB("DYNAMODB"),

    GOOGLECLOUDSTORAGE("GOOGLECLOUDSTORAGE"),

    HBASE("HBASE"),

    KUSTOMER("KUSTOMER"),

    MICROSOFTDYNAMICS365_CRM("MICROSOFTDYNAMICS365CRM"),

    MONDAY("MONDAY"),

    MYSQL("MYSQL"),

    OKTA("OKTA"),

    OPENSEARCH("OPENSEARCH"),

    ORACLE("ORACLE"),

    PIPEDRIVE("PIPEDRIVE"),

    POSTGRESQL("POSTGRESQL"),

    SAPHANA("SAPHANA"),

    SQLSERVER("SQLSERVER"),

    SYNAPSE("SYNAPSE"),

    TERADATA("TERADATA"),

    TERADATANOS("TERADATANOS"),

    TIMESTREAM("TIMESTREAM"),

    TPCDS("TPCDS"),

    VERTICA("VERTICA"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionType> VALUE_MAP = EnumUtils.uniqueIndex(ConnectionType.class,
            ConnectionType::toString);

    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ConnectionType corresponding to the value
     */
    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ConnectionType}s
     */
    public static Set<ConnectionType> knownValues() {
        Set<ConnectionType> knownValues = EnumSet.allOf(ConnectionType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
