/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomRoutingAcceleratorAttributesRequest extends GlobalAcceleratorRequest
        implements
        ToCopyableBuilder<UpdateCustomRoutingAcceleratorAttributesRequest.Builder, UpdateCustomRoutingAcceleratorAttributesRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(UpdateCustomRoutingAcceleratorAttributesRequest::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<Boolean> FLOW_LOGS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FlowLogsEnabled").getter(getter(UpdateCustomRoutingAcceleratorAttributesRequest::flowLogsEnabled))
            .setter(setter(Builder::flowLogsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsEnabled").build()).build();

    private static final SdkField<String> FLOW_LOGS_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowLogsS3Bucket").getter(getter(UpdateCustomRoutingAcceleratorAttributesRequest::flowLogsS3Bucket))
            .setter(setter(Builder::flowLogsS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Bucket").build()).build();

    private static final SdkField<String> FLOW_LOGS_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowLogsS3Prefix").getter(getter(UpdateCustomRoutingAcceleratorAttributesRequest::flowLogsS3Prefix))
            .setter(setter(Builder::flowLogsS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            FLOW_LOGS_ENABLED_FIELD, FLOW_LOGS_S3_BUCKET_FIELD, FLOW_LOGS_S3_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceleratorArn;

    private final Boolean flowLogsEnabled;

    private final String flowLogsS3Bucket;

    private final String flowLogsS3Prefix;

    private UpdateCustomRoutingAcceleratorAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.flowLogsEnabled = builder.flowLogsEnabled;
        this.flowLogsS3Bucket = builder.flowLogsS3Bucket;
        this.flowLogsS3Prefix = builder.flowLogsS3Prefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * <p>
     * Update whether flow logs are enabled. The default value is false. If the value is true,
     * <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow
     * logs</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * 
     * @return Update whether flow logs are enabled. The default value is false. If the value is true,
     *         <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html"
     *         >Flow logs</a> in the <i>Global Accelerator Developer Guide</i>.
     */
    public final Boolean flowLogsEnabled() {
        return flowLogsEnabled;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
     * <code>true</code>. The bucket must exist and have a bucket policy that grants Global Accelerator permission to
     * write to the bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code>
     *         is <code>true</code>. The bucket must exist and have a bucket policy that grants Global Accelerator
     *         permission to write to the bucket.
     */
    public final String flowLogsS3Bucket() {
        return flowLogsS3Bucket;
    }

    /**
     * <p>
     * Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
     * <code>FlowLogsEnabled</code> is <code>true</code>.
     * </p>
     * <p>
     * If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for
     * the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:
     * </p>
     * <p>
     * DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
     * </p>
     * 
     * @return Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
     *         <code>FlowLogsEnabled</code> is <code>true</code>. </p>
     *         <p>
     *         If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash
     *         (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like
     *         the following:
     *         </p>
     *         <p>
     *         DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
     */
    public final String flowLogsS3Prefix() {
        return flowLogsS3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsS3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomRoutingAcceleratorAttributesRequest)) {
            return false;
        }
        UpdateCustomRoutingAcceleratorAttributesRequest other = (UpdateCustomRoutingAcceleratorAttributesRequest) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn())
                && Objects.equals(flowLogsEnabled(), other.flowLogsEnabled())
                && Objects.equals(flowLogsS3Bucket(), other.flowLogsS3Bucket())
                && Objects.equals(flowLogsS3Prefix(), other.flowLogsS3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomRoutingAcceleratorAttributesRequest").add("AcceleratorArn", acceleratorArn())
                .add("FlowLogsEnabled", flowLogsEnabled()).add("FlowLogsS3Bucket", flowLogsS3Bucket())
                .add("FlowLogsS3Prefix", flowLogsS3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "FlowLogsEnabled":
            return Optional.ofNullable(clazz.cast(flowLogsEnabled()));
        case "FlowLogsS3Bucket":
            return Optional.ofNullable(clazz.cast(flowLogsS3Bucket()));
        case "FlowLogsS3Prefix":
            return Optional.ofNullable(clazz.cast(flowLogsS3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
        map.put("FlowLogsEnabled", FLOW_LOGS_ENABLED_FIELD);
        map.put("FlowLogsS3Bucket", FLOW_LOGS_S3_BUCKET_FIELD);
        map.put("FlowLogsS3Prefix", FLOW_LOGS_S3_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomRoutingAcceleratorAttributesRequest, T> g) {
        return obj -> g.apply((UpdateCustomRoutingAcceleratorAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCustomRoutingAcceleratorAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * Update whether flow logs are enabled. The default value is false. If the value is true,
         * <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow
         * logs</a> in the <i>Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param flowLogsEnabled
         *        Update whether flow logs are enabled. The default value is false. If the value is true,
         *        <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html"
         *        >Flow logs</a> in the <i>Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsEnabled(Boolean flowLogsEnabled);

        /**
         * <p>
         * The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
         * <code>true</code>. The bucket must exist and have a bucket policy that grants Global Accelerator permission
         * to write to the bucket.
         * </p>
         * 
         * @param flowLogsS3Bucket
         *        The name of the Amazon S3 bucket for the flow logs. Attribute is required if
         *        <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that
         *        grants Global Accelerator permission to write to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsS3Bucket(String flowLogsS3Bucket);

        /**
         * <p>
         * Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
         * <code>FlowLogsEnabled</code> is <code>true</code>.
         * </p>
         * <p>
         * If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/)
         * for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the
         * following:
         * </p>
         * <p>
         * DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
         * </p>
         * 
         * @param flowLogsS3Prefix
         *        Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
         *        <code>FlowLogsEnabled</code> is <code>true</code>. </p>
         *        <p>
         *        If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify
         *        slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash
         *        (//), like the following:
         *        </p>
         *        <p>
         *        DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsS3Prefix(String flowLogsS3Prefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String acceleratorArn;

        private Boolean flowLogsEnabled;

        private String flowLogsS3Bucket;

        private String flowLogsS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomRoutingAcceleratorAttributesRequest model) {
            super(model);
            acceleratorArn(model.acceleratorArn);
            flowLogsEnabled(model.flowLogsEnabled);
            flowLogsS3Bucket(model.flowLogsS3Bucket);
            flowLogsS3Prefix(model.flowLogsS3Prefix);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final Boolean getFlowLogsEnabled() {
            return flowLogsEnabled;
        }

        public final void setFlowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
        }

        @Override
        public final Builder flowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
            return this;
        }

        public final String getFlowLogsS3Bucket() {
            return flowLogsS3Bucket;
        }

        public final void setFlowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
        }

        @Override
        public final Builder flowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
            return this;
        }

        public final String getFlowLogsS3Prefix() {
            return flowLogsS3Prefix;
        }

        public final void setFlowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
        }

        @Override
        public final Builder flowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomRoutingAcceleratorAttributesRequest build() {
            return new UpdateCustomRoutingAcceleratorAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
