/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCrossAccountAttachmentRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<UpdateCrossAccountAttachmentRequest.Builder, UpdateCrossAccountAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentArn").getter(getter(UpdateCrossAccountAttachmentRequest::attachmentArn))
            .setter(setter(Builder::attachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateCrossAccountAttachmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> ADD_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddPrincipals")
            .getter(getter(UpdateCrossAccountAttachmentRequest::addPrincipals))
            .setter(setter(Builder::addPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemovePrincipals")
            .getter(getter(UpdateCrossAccountAttachmentRequest::removePrincipals))
            .setter(setter(Builder::removePrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Resource>> ADD_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("AddResources")
            .getter(getter(UpdateCrossAccountAttachmentRequest::addResources))
            .setter(setter(Builder::addResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Resource>> REMOVE_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("RemoveResources")
            .getter(getter(UpdateCrossAccountAttachmentRequest::removeResources))
            .setter(setter(Builder::removeResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ARN_FIELD,
            NAME_FIELD, ADD_PRINCIPALS_FIELD, REMOVE_PRINCIPALS_FIELD, ADD_RESOURCES_FIELD, REMOVE_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String attachmentArn;

    private final String name;

    private final List<String> addPrincipals;

    private final List<String> removePrincipals;

    private final List<Resource> addResources;

    private final List<Resource> removeResources;

    private UpdateCrossAccountAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentArn = builder.attachmentArn;
        this.name = builder.name;
        this.addPrincipals = builder.addPrincipals;
        this.removePrincipals = builder.removePrincipals;
        this.addResources = builder.addResources;
        this.removeResources = builder.removeResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cross-account attachment to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cross-account attachment to update.
     */
    public final String attachmentArn() {
        return attachmentArn;
    }

    /**
     * <p>
     * The name of the cross-account attachment.
     * </p>
     * 
     * @return The name of the cross-account attachment.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddPrincipals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddPrincipals() {
        return addPrincipals != null && !(addPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principals to add to the cross-account attachment. A principal is an account or the Amazon Resource Name
     * (ARN) of an accelerator that the attachment gives permission to work with resources from another account. The
     * resources are also listed in the attachment.
     * </p>
     * <p>
     * To add more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddPrincipals} method.
     * </p>
     * 
     * @return The principals to add to the cross-account attachment. A principal is an account or the Amazon Resource
     *         Name (ARN) of an accelerator that the attachment gives permission to work with resources from another
     *         account. The resources are also listed in the attachment.</p>
     *         <p>
     *         To add more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
     */
    public final List<String> addPrincipals() {
        return addPrincipals;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemovePrincipals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemovePrincipals() {
        return removePrincipals != null && !(removePrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principals to remove from the cross-account attachment. A principal is an account or the Amazon Resource Name
     * (ARN) of an accelerator that the attachment gives permission to work with resources from another account. The
     * resources are also listed in the attachment.
     * </p>
     * <p>
     * To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemovePrincipals} method.
     * </p>
     * 
     * @return The principals to remove from the cross-account attachment. A principal is an account or the Amazon
     *         Resource Name (ARN) of an accelerator that the attachment gives permission to work with resources from
     *         another account. The resources are also listed in the attachment.</p>
     *         <p>
     *         To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with
     *         commas.
     */
    public final List<String> removePrincipals() {
        return removePrincipals;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddResources() {
        return addResources != null && !(addResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources to add to the cross-account attachment. A resource listed in a cross-account attachment can be used
     * with an accelerator by the principals that are listed in the attachment.
     * </p>
     * <p>
     * To add more than one resource, separate the resource ARNs with commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddResources} method.
     * </p>
     * 
     * @return The resources to add to the cross-account attachment. A resource listed in a cross-account attachment can
     *         be used with an accelerator by the principals that are listed in the attachment.</p>
     *         <p>
     *         To add more than one resource, separate the resource ARNs with commas.
     */
    public final List<Resource> addResources() {
        return addResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveResources() {
        return removeResources != null && !(removeResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources to remove from the cross-account attachment. A resource listed in a cross-account attachment can be
     * used with an accelerator by the principals that are listed in the attachment.
     * </p>
     * <p>
     * To remove more than one resource, separate the resource ARNs with commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveResources} method.
     * </p>
     * 
     * @return The resources to remove from the cross-account attachment. A resource listed in a cross-account
     *         attachment can be used with an accelerator by the principals that are listed in the attachment.</p>
     *         <p>
     *         To remove more than one resource, separate the resource ARNs with commas.
     */
    public final List<Resource> removeResources() {
        return removeResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddPrincipals() ? addPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemovePrincipals() ? removePrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddResources() ? addResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveResources() ? removeResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrossAccountAttachmentRequest)) {
            return false;
        }
        UpdateCrossAccountAttachmentRequest other = (UpdateCrossAccountAttachmentRequest) obj;
        return Objects.equals(attachmentArn(), other.attachmentArn()) && Objects.equals(name(), other.name())
                && hasAddPrincipals() == other.hasAddPrincipals() && Objects.equals(addPrincipals(), other.addPrincipals())
                && hasRemovePrincipals() == other.hasRemovePrincipals()
                && Objects.equals(removePrincipals(), other.removePrincipals()) && hasAddResources() == other.hasAddResources()
                && Objects.equals(addResources(), other.addResources()) && hasRemoveResources() == other.hasRemoveResources()
                && Objects.equals(removeResources(), other.removeResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCrossAccountAttachmentRequest").add("AttachmentArn", attachmentArn()).add("Name", name())
                .add("AddPrincipals", hasAddPrincipals() ? addPrincipals() : null)
                .add("RemovePrincipals", hasRemovePrincipals() ? removePrincipals() : null)
                .add("AddResources", hasAddResources() ? addResources() : null)
                .add("RemoveResources", hasRemoveResources() ? removeResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentArn":
            return Optional.ofNullable(clazz.cast(attachmentArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AddPrincipals":
            return Optional.ofNullable(clazz.cast(addPrincipals()));
        case "RemovePrincipals":
            return Optional.ofNullable(clazz.cast(removePrincipals()));
        case "AddResources":
            return Optional.ofNullable(clazz.cast(addResources()));
        case "RemoveResources":
            return Optional.ofNullable(clazz.cast(removeResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentArn", ATTACHMENT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AddPrincipals", ADD_PRINCIPALS_FIELD);
        map.put("RemovePrincipals", REMOVE_PRINCIPALS_FIELD);
        map.put("AddResources", ADD_RESOURCES_FIELD);
        map.put("RemoveResources", REMOVE_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCrossAccountAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateCrossAccountAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCrossAccountAttachmentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cross-account attachment to update.
         * </p>
         * 
         * @param attachmentArn
         *        The Amazon Resource Name (ARN) of the cross-account attachment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentArn(String attachmentArn);

        /**
         * <p>
         * The name of the cross-account attachment.
         * </p>
         * 
         * @param name
         *        The name of the cross-account attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The principals to add to the cross-account attachment. A principal is an account or the Amazon Resource Name
         * (ARN) of an accelerator that the attachment gives permission to work with resources from another account. The
         * resources are also listed in the attachment.
         * </p>
         * <p>
         * To add more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
         * </p>
         * 
         * @param addPrincipals
         *        The principals to add to the cross-account attachment. A principal is an account or the Amazon
         *        Resource Name (ARN) of an accelerator that the attachment gives permission to work with resources from
         *        another account. The resources are also listed in the attachment.</p>
         *        <p>
         *        To add more than one principal, separate the account numbers or accelerator ARNs, or both, with
         *        commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addPrincipals(Collection<String> addPrincipals);

        /**
         * <p>
         * The principals to add to the cross-account attachment. A principal is an account or the Amazon Resource Name
         * (ARN) of an accelerator that the attachment gives permission to work with resources from another account. The
         * resources are also listed in the attachment.
         * </p>
         * <p>
         * To add more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
         * </p>
         * 
         * @param addPrincipals
         *        The principals to add to the cross-account attachment. A principal is an account or the Amazon
         *        Resource Name (ARN) of an accelerator that the attachment gives permission to work with resources from
         *        another account. The resources are also listed in the attachment.</p>
         *        <p>
         *        To add more than one principal, separate the account numbers or accelerator ARNs, or both, with
         *        commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addPrincipals(String... addPrincipals);

        /**
         * <p>
         * The principals to remove from the cross-account attachment. A principal is an account or the Amazon Resource
         * Name (ARN) of an accelerator that the attachment gives permission to work with resources from another
         * account. The resources are also listed in the attachment.
         * </p>
         * <p>
         * To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
         * </p>
         * 
         * @param removePrincipals
         *        The principals to remove from the cross-account attachment. A principal is an account or the Amazon
         *        Resource Name (ARN) of an accelerator that the attachment gives permission to work with resources from
         *        another account. The resources are also listed in the attachment.</p>
         *        <p>
         *        To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with
         *        commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePrincipals(Collection<String> removePrincipals);

        /**
         * <p>
         * The principals to remove from the cross-account attachment. A principal is an account or the Amazon Resource
         * Name (ARN) of an accelerator that the attachment gives permission to work with resources from another
         * account. The resources are also listed in the attachment.
         * </p>
         * <p>
         * To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with commas.
         * </p>
         * 
         * @param removePrincipals
         *        The principals to remove from the cross-account attachment. A principal is an account or the Amazon
         *        Resource Name (ARN) of an accelerator that the attachment gives permission to work with resources from
         *        another account. The resources are also listed in the attachment.</p>
         *        <p>
         *        To remove more than one principal, separate the account numbers or accelerator ARNs, or both, with
         *        commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePrincipals(String... removePrincipals);

        /**
         * <p>
         * The resources to add to the cross-account attachment. A resource listed in a cross-account attachment can be
         * used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To add more than one resource, separate the resource ARNs with commas.
         * </p>
         * 
         * @param addResources
         *        The resources to add to the cross-account attachment. A resource listed in a cross-account attachment
         *        can be used with an accelerator by the principals that are listed in the attachment.</p>
         *        <p>
         *        To add more than one resource, separate the resource ARNs with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addResources(Collection<Resource> addResources);

        /**
         * <p>
         * The resources to add to the cross-account attachment. A resource listed in a cross-account attachment can be
         * used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To add more than one resource, separate the resource ARNs with commas.
         * </p>
         * 
         * @param addResources
         *        The resources to add to the cross-account attachment. A resource listed in a cross-account attachment
         *        can be used with an accelerator by the principals that are listed in the attachment.</p>
         *        <p>
         *        To add more than one resource, separate the resource ARNs with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addResources(Resource... addResources);

        /**
         * <p>
         * The resources to add to the cross-account attachment. A resource listed in a cross-account attachment can be
         * used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To add more than one resource, separate the resource ARNs with commas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.globalaccelerator.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder#build()} is called
         * immediately and its result is passed to {@link #addResources(List<Resource>)}.
         * 
         * @param addResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addResources(java.util.Collection<Resource>)
         */
        Builder addResources(Consumer<Resource.Builder>... addResources);

        /**
         * <p>
         * The resources to remove from the cross-account attachment. A resource listed in a cross-account attachment
         * can be used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To remove more than one resource, separate the resource ARNs with commas.
         * </p>
         * 
         * @param removeResources
         *        The resources to remove from the cross-account attachment. A resource listed in a cross-account
         *        attachment can be used with an accelerator by the principals that are listed in the attachment.</p>
         *        <p>
         *        To remove more than one resource, separate the resource ARNs with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeResources(Collection<Resource> removeResources);

        /**
         * <p>
         * The resources to remove from the cross-account attachment. A resource listed in a cross-account attachment
         * can be used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To remove more than one resource, separate the resource ARNs with commas.
         * </p>
         * 
         * @param removeResources
         *        The resources to remove from the cross-account attachment. A resource listed in a cross-account
         *        attachment can be used with an accelerator by the principals that are listed in the attachment.</p>
         *        <p>
         *        To remove more than one resource, separate the resource ARNs with commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeResources(Resource... removeResources);

        /**
         * <p>
         * The resources to remove from the cross-account attachment. A resource listed in a cross-account attachment
         * can be used with an accelerator by the principals that are listed in the attachment.
         * </p>
         * <p>
         * To remove more than one resource, separate the resource ARNs with commas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.globalaccelerator.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder#build()} is called
         * immediately and its result is passed to {@link #removeResources(List<Resource>)}.
         * 
         * @param removeResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeResources(java.util.Collection<Resource>)
         */
        Builder removeResources(Consumer<Resource.Builder>... removeResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String attachmentArn;

        private String name;

        private List<String> addPrincipals = DefaultSdkAutoConstructList.getInstance();

        private List<String> removePrincipals = DefaultSdkAutoConstructList.getInstance();

        private List<Resource> addResources = DefaultSdkAutoConstructList.getInstance();

        private List<Resource> removeResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrossAccountAttachmentRequest model) {
            super(model);
            attachmentArn(model.attachmentArn);
            name(model.name);
            addPrincipals(model.addPrincipals);
            removePrincipals(model.removePrincipals);
            addResources(model.addResources);
            removeResources(model.removeResources);
        }

        public final String getAttachmentArn() {
            return attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAddPrincipals() {
            if (addPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return addPrincipals;
        }

        public final void setAddPrincipals(Collection<String> addPrincipals) {
            this.addPrincipals = PrincipalsCopier.copy(addPrincipals);
        }

        @Override
        public final Builder addPrincipals(Collection<String> addPrincipals) {
            this.addPrincipals = PrincipalsCopier.copy(addPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addPrincipals(String... addPrincipals) {
            addPrincipals(Arrays.asList(addPrincipals));
            return this;
        }

        public final Collection<String> getRemovePrincipals() {
            if (removePrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return removePrincipals;
        }

        public final void setRemovePrincipals(Collection<String> removePrincipals) {
            this.removePrincipals = PrincipalsCopier.copy(removePrincipals);
        }

        @Override
        public final Builder removePrincipals(Collection<String> removePrincipals) {
            this.removePrincipals = PrincipalsCopier.copy(removePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removePrincipals(String... removePrincipals) {
            removePrincipals(Arrays.asList(removePrincipals));
            return this;
        }

        public final List<Resource.Builder> getAddResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.addResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddResources(Collection<Resource.BuilderImpl> addResources) {
            this.addResources = ResourcesCopier.copyFromBuilder(addResources);
        }

        @Override
        public final Builder addResources(Collection<Resource> addResources) {
            this.addResources = ResourcesCopier.copy(addResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Resource... addResources) {
            addResources(Arrays.asList(addResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Consumer<Resource.Builder>... addResources) {
            addResources(Stream.of(addResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Resource.Builder> getRemoveResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.removeResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveResources(Collection<Resource.BuilderImpl> removeResources) {
            this.removeResources = ResourcesCopier.copyFromBuilder(removeResources);
        }

        @Override
        public final Builder removeResources(Collection<Resource> removeResources) {
            this.removeResources = ResourcesCopier.copy(removeResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(Resource... removeResources) {
            removeResources(Arrays.asList(removeResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(Consumer<Resource.Builder>... removeResources) {
            removeResources(Stream.of(removeResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrossAccountAttachmentRequest build() {
            return new UpdateCrossAccountAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
