/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SocketAddressesCopier {
    static List<SocketAddress> copy(Collection<? extends SocketAddress> socketAddressesParam) {
        List<SocketAddress> list;
        if (socketAddressesParam == null || socketAddressesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SocketAddress> modifiableList = new ArrayList<>(socketAddressesParam.size());
            socketAddressesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SocketAddress> copyFromBuilder(Collection<? extends SocketAddress.Builder> socketAddressesParam) {
        List<SocketAddress> list;
        if (socketAddressesParam == null || socketAddressesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SocketAddress> modifiableList = new ArrayList<>(socketAddressesParam.size());
            socketAddressesParam.forEach(entry -> {
                SocketAddress member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SocketAddress.Builder> copyToBuilder(Collection<? extends SocketAddress> socketAddressesParam) {
        List<SocketAddress.Builder> list;
        if (socketAddressesParam == null || socketAddressesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SocketAddress.Builder> modifiableList = new ArrayList<>(socketAddressesParam.size());
            socketAddressesParam.forEach(entry -> {
                SocketAddress.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
