/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingPortMappingsRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<ListCustomRoutingPortMappingsRequest.Builder, ListCustomRoutingPortMappingsRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(ListCustomRoutingPortMappingsRequest::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(ListCustomRoutingPortMappingsRequest::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCustomRoutingPortMappingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingPortMappingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            ENDPOINT_GROUP_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceleratorArn;

    private final String endpointGroupArn;

    private final Integer maxResults;

    private final String nextToken;

    private ListCustomRoutingPortMappingsRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.endpointGroupArn = builder.endpointGroupArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * <p>
     * The number of destination port mappings that you want to return with this call. The default value is 10.
     * </p>
     * 
     * @return The number of destination port mappings that you want to return with this call. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsRequest)) {
            return false;
        }
        ListCustomRoutingPortMappingsRequest other = (ListCustomRoutingPortMappingsRequest) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn())
                && Objects.equals(endpointGroupArn(), other.endpointGroupArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingPortMappingsRequest").add("AcceleratorArn", acceleratorArn())
                .add("EndpointGroupArn", endpointGroupArn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
        map.put("EndpointGroupArn", ENDPOINT_GROUP_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsRequest, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingPortMappingsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * The number of destination port mappings that you want to return with this call. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The number of destination port mappings that you want to return with this call. The default value is
         *        10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String acceleratorArn;

        private String endpointGroupArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsRequest model) {
            super(model);
            acceleratorArn(model.acceleratorArn);
            endpointGroupArn(model.endpointGroupArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsRequest build() {
            return new ListCustomRoutingPortMappingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
