/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingPortMappingsByDestinationRequest extends GlobalAcceleratorRequest
        implements
        ToCopyableBuilder<ListCustomRoutingPortMappingsByDestinationRequest.Builder, ListCustomRoutingPortMappingsByDestinationRequest> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(ListCustomRoutingPortMappingsByDestinationRequest::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationAddress")
            .getter(getter(ListCustomRoutingPortMappingsByDestinationRequest::destinationAddress))
            .setter(setter(Builder::destinationAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCustomRoutingPortMappingsByDestinationRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingPortMappingsByDestinationRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            DESTINATION_ADDRESS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointId;

    private final String destinationAddress;

    private final Integer maxResults;

    private final String nextToken;

    private ListCustomRoutingPortMappingsByDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.endpointId = builder.endpointId;
        this.destinationAddress = builder.destinationAddress;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID for the virtual private cloud (VPC) subnet.
     * </p>
     * 
     * @return The ID for the virtual private cloud (VPC) subnet.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port mappings.
     * </p>
     * 
     * @return The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
     *         mappings.
     */
    public final String destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The number of destination port mappings that you want to return with this call. The default value is 10.
     * </p>
     * 
     * @return The number of destination port mappings that you want to return with this call. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsByDestinationRequest)) {
            return false;
        }
        ListCustomRoutingPortMappingsByDestinationRequest other = (ListCustomRoutingPortMappingsByDestinationRequest) obj;
        return Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingPortMappingsByDestinationRequest").add("EndpointId", endpointId())
                .add("DestinationAddress", destinationAddress()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsByDestinationRequest, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsByDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationRequest> {
        /**
         * <p>
         * The ID for the virtual private cloud (VPC) subnet.
         * </p>
         * 
         * @param endpointId
         *        The ID for the virtual private cloud (VPC) subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
         * mappings.
         * </p>
         * 
         * @param destinationAddress
         *        The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back
         *        port mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(String destinationAddress);

        /**
         * <p>
         * The number of destination port mappings that you want to return with this call. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The number of destination port mappings that you want to return with this call. The default value is
         *        10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String endpointId;

        private String destinationAddress;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsByDestinationRequest model) {
            super(model);
            endpointId(model.endpointId);
            destinationAddress(model.destinationAddress);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getDestinationAddress() {
            return destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsByDestinationRequest build() {
            return new ListCustomRoutingPortMappingsByDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
