/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingAcceleratorsResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListCustomRoutingAcceleratorsResponse.Builder, ListCustomRoutingAcceleratorsResponse> {
    private static final SdkField<List<CustomRoutingAccelerator>> ACCELERATORS_FIELD = SdkField
            .<List<CustomRoutingAccelerator>> builder(MarshallingType.LIST)
            .memberName("Accelerators")
            .getter(getter(ListCustomRoutingAcceleratorsResponse::accelerators))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingAcceleratorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CustomRoutingAccelerator> accelerators;

    private final String nextToken;

    private ListCustomRoutingAcceleratorsResponse(BuilderImpl builder) {
        super(builder);
        this.accelerators = builder.accelerators;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accelerators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccelerators() {
        return accelerators != null && !(accelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of custom routing accelerators for a customer account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccelerators} method.
     * </p>
     * 
     * @return The list of custom routing accelerators for a customer account.
     */
    public final List<CustomRoutingAccelerator> accelerators() {
        return accelerators;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccelerators() ? accelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingAcceleratorsResponse)) {
            return false;
        }
        ListCustomRoutingAcceleratorsResponse other = (ListCustomRoutingAcceleratorsResponse) obj;
        return hasAccelerators() == other.hasAccelerators() && Objects.equals(accelerators(), other.accelerators())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingAcceleratorsResponse")
                .add("Accelerators", hasAccelerators() ? accelerators() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accelerators":
            return Optional.ofNullable(clazz.cast(accelerators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accelerators", ACCELERATORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingAcceleratorsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingAcceleratorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingAcceleratorsResponse> {
        /**
         * <p>
         * The list of custom routing accelerators for a customer account.
         * </p>
         * 
         * @param accelerators
         *        The list of custom routing accelerators for a customer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(Collection<CustomRoutingAccelerator> accelerators);

        /**
         * <p>
         * The list of custom routing accelerators for a customer account.
         * </p>
         * 
         * @param accelerators
         *        The list of custom routing accelerators for a customer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(CustomRoutingAccelerator... accelerators);

        /**
         * <p>
         * The list of custom routing accelerators for a customer account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator.Builder#build()} is
         * called immediately and its result is passed to {@link #accelerators(List<CustomRoutingAccelerator>)}.
         * 
         * @param accelerators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerators(java.util.Collection<CustomRoutingAccelerator>)
         */
        Builder accelerators(Consumer<CustomRoutingAccelerator.Builder>... accelerators);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<CustomRoutingAccelerator> accelerators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingAcceleratorsResponse model) {
            super(model);
            accelerators(model.accelerators);
            nextToken(model.nextToken);
        }

        public final List<CustomRoutingAccelerator.Builder> getAccelerators() {
            List<CustomRoutingAccelerator.Builder> result = CustomRoutingAcceleratorsCopier.copyToBuilder(this.accelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccelerators(Collection<CustomRoutingAccelerator.BuilderImpl> accelerators) {
            this.accelerators = CustomRoutingAcceleratorsCopier.copyFromBuilder(accelerators);
        }

        @Override
        public final Builder accelerators(Collection<CustomRoutingAccelerator> accelerators) {
            this.accelerators = CustomRoutingAcceleratorsCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(CustomRoutingAccelerator... accelerators) {
            accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<CustomRoutingAccelerator.Builder>... accelerators) {
            accelerators(Stream.of(accelerators).map(c -> CustomRoutingAccelerator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingAcceleratorsResponse build() {
            return new ListCustomRoutingAcceleratorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
