/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCrossAccountAttachmentsResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListCrossAccountAttachmentsResponse.Builder, ListCrossAccountAttachmentsResponse> {
    private static final SdkField<List<Attachment>> CROSS_ACCOUNT_ATTACHMENTS_FIELD = SdkField
            .<List<Attachment>> builder(MarshallingType.LIST)
            .memberName("CrossAccountAttachments")
            .getter(getter(ListCrossAccountAttachmentsResponse::crossAccountAttachments))
            .setter(setter(Builder::crossAccountAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCrossAccountAttachmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CROSS_ACCOUNT_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Attachment> crossAccountAttachments;

    private final String nextToken;

    private ListCrossAccountAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.crossAccountAttachments = builder.crossAccountAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossAccountAttachments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossAccountAttachments() {
        return crossAccountAttachments != null && !(crossAccountAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the cross-account attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossAccountAttachments} method.
     * </p>
     * 
     * @return Information about the cross-account attachments.
     */
    public final List<Attachment> crossAccountAttachments() {
        return crossAccountAttachments;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossAccountAttachments() ? crossAccountAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrossAccountAttachmentsResponse)) {
            return false;
        }
        ListCrossAccountAttachmentsResponse other = (ListCrossAccountAttachmentsResponse) obj;
        return hasCrossAccountAttachments() == other.hasCrossAccountAttachments()
                && Objects.equals(crossAccountAttachments(), other.crossAccountAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCrossAccountAttachmentsResponse")
                .add("CrossAccountAttachments", hasCrossAccountAttachments() ? crossAccountAttachments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossAccountAttachments":
            return Optional.ofNullable(clazz.cast(crossAccountAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrossAccountAttachments", CROSS_ACCOUNT_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCrossAccountAttachmentsResponse, T> g) {
        return obj -> g.apply((ListCrossAccountAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCrossAccountAttachmentsResponse> {
        /**
         * <p>
         * Information about the cross-account attachments.
         * </p>
         * 
         * @param crossAccountAttachments
         *        Information about the cross-account attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountAttachments(Collection<Attachment> crossAccountAttachments);

        /**
         * <p>
         * Information about the cross-account attachments.
         * </p>
         * 
         * @param crossAccountAttachments
         *        Information about the cross-account attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountAttachments(Attachment... crossAccountAttachments);

        /**
         * <p>
         * Information about the cross-account attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Attachment.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.globalaccelerator.model.Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.Attachment.Builder#build()} is called
         * immediately and its result is passed to {@link #crossAccountAttachments(List<Attachment>)}.
         * 
         * @param crossAccountAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossAccountAttachments(java.util.Collection<Attachment>)
         */
        Builder crossAccountAttachments(Consumer<Attachment.Builder>... crossAccountAttachments);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<Attachment> crossAccountAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrossAccountAttachmentsResponse model) {
            super(model);
            crossAccountAttachments(model.crossAccountAttachments);
            nextToken(model.nextToken);
        }

        public final List<Attachment.Builder> getCrossAccountAttachments() {
            List<Attachment.Builder> result = AttachmentsCopier.copyToBuilder(this.crossAccountAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossAccountAttachments(Collection<Attachment.BuilderImpl> crossAccountAttachments) {
            this.crossAccountAttachments = AttachmentsCopier.copyFromBuilder(crossAccountAttachments);
        }

        @Override
        public final Builder crossAccountAttachments(Collection<Attachment> crossAccountAttachments) {
            this.crossAccountAttachments = AttachmentsCopier.copy(crossAccountAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountAttachments(Attachment... crossAccountAttachments) {
            crossAccountAttachments(Arrays.asList(crossAccountAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountAttachments(Consumer<Attachment.Builder>... crossAccountAttachments) {
            crossAccountAttachments(Stream.of(crossAccountAttachments).map(c -> Attachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrossAccountAttachmentsResponse build() {
            return new ListCrossAccountAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
