/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of endpoint objects. For custom routing, this is a list of virtual private cloud (VPC) subnet IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRoutingEndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomRoutingEndpointConfiguration.Builder, CustomRoutingEndpointConfiguration> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(CustomRoutingEndpointConfiguration::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentArn").getter(getter(CustomRoutingEndpointConfiguration::attachmentArn))
            .setter(setter(Builder::attachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            ATTACHMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final String attachmentArn;

    private CustomRoutingEndpointConfiguration(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.attachmentArn = builder.attachmentArn;
    }

    /**
     * <p>
     * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     * </p>
     * 
     * @return An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet
     *         ID.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that can
     * be added to accelerators and principals that have permission to add the endpoints.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources)
     *         that can be added to accelerators and principals that have permission to add the endpoints.
     */
    public final String attachmentArn() {
        return attachmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingEndpointConfiguration)) {
            return false;
        }
        CustomRoutingEndpointConfiguration other = (CustomRoutingEndpointConfiguration) obj;
        return Objects.equals(endpointId(), other.endpointId()) && Objects.equals(attachmentArn(), other.attachmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomRoutingEndpointConfiguration").add("EndpointId", endpointId())
                .add("AttachmentArn", attachmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "AttachmentArn":
            return Optional.ofNullable(clazz.cast(attachmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("AttachmentArn", ATTACHMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomRoutingEndpointConfiguration, T> g) {
        return obj -> g.apply((CustomRoutingEndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRoutingEndpointConfiguration> {
        /**
         * <p>
         * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
         * </p>
         * 
         * @param endpointId
         *        An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
         *        subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that
         * can be added to accelerators and principals that have permission to add the endpoints.
         * </p>
         * 
         * @param attachmentArn
         *        The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints
         *        (resources) that can be added to accelerators and principals that have permission to add the
         *        endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentArn(String attachmentArn);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private String attachmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRoutingEndpointConfiguration model) {
            endpointId(model.endpointId);
            attachmentArn(model.attachmentArn);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getAttachmentArn() {
            return attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        @Override
        public CustomRoutingEndpointConfiguration build() {
            return new CustomRoutingEndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
