/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an IP address range that is provisioned for use with your Amazon Web Services resources through
 * bring your own IP address (BYOIP).
 * </p>
 * <p>
 * The following describes each BYOIP <code>State</code> that your IP address range can be in.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>PENDING_PROVISIONING</b> — You’ve submitted a request to provision an IP address range but it is not yet
 * provisioned with Global Accelerator.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>READY</b> — The address range is provisioned with Global Accelerator and can be advertised.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>PENDING_ADVERTISING</b> — You’ve submitted a request for Global Accelerator to advertise an address range but it
 * is not yet being advertised.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>ADVERTISING</b> — The address range is being advertised by Global Accelerator.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>PENDING_WITHDRAWING</b> — You’ve submitted a request to withdraw an address range from being advertised but it is
 * still being advertised by Global Accelerator.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>PENDING_DEPROVISIONING</b> — You’ve submitted a request to deprovision an address range from Global Accelerator
 * but it is still provisioned.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>DEPROVISIONED</b> — The address range is deprovisioned from Global Accelerator.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>FAILED_PROVISION </b> — The request to provision the address range from Global Accelerator was not successful.
 * Please make sure that you provide all of the correct information, and try again. If the request fails a second time,
 * contact Amazon Web Services support.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>FAILED_ADVERTISING</b> — The request for Global Accelerator to advertise the address range was not successful.
 * Please make sure that you provide all of the correct information, and try again. If the request fails a second time,
 * contact Amazon Web Services support.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>FAILED_WITHDRAW</b> — The request to withdraw the address range from advertising by Global Accelerator was not
 * successful. Please make sure that you provide all of the correct information, and try again. If the request fails a
 * second time, contact Amazon Web Services support.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>FAILED_DEPROVISION </b> — The request to deprovision the address range from Global Accelerator was not successful.
 * Please make sure that you provide all of the correct information, and try again. If the request fails a second time,
 * contact Amazon Web Services support.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByoipCidr implements SdkPojo, Serializable, ToCopyableBuilder<ByoipCidr.Builder, ByoipCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(ByoipCidr::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ByoipCidr::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<ByoipCidrEvent>> EVENTS_FIELD = SdkField
            .<List<ByoipCidrEvent>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(ByoipCidr::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ByoipCidrEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ByoipCidrEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, STATE_FIELD,
            EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String state;

    private final List<ByoipCidrEvent> events;

    private ByoipCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.state = builder.state;
        this.events = builder.events;
    }

    /**
     * <p>
     * The address range, in CIDR notation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     * 
     * @return The address range, in CIDR notation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
     *         addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The state of the address pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ByoipCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the address pool.
     * @see ByoipCidrState
     */
    public final ByoipCidrState state() {
        return ByoipCidrState.fromValue(state);
    }

    /**
     * <p>
     * The state of the address pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ByoipCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the address pool.
     * @see ByoipCidrState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A history of status changes for an IP address range that you bring to Global Accelerator through bring your own
     * IP address (BYOIP).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return A history of status changes for an IP address range that you bring to Global Accelerator through bring
     *         your own IP address (BYOIP).
     */
    public final List<ByoipCidrEvent> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByoipCidr)) {
            return false;
        }
        ByoipCidr other = (ByoipCidr) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasEvents() == other.hasEvents() && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByoipCidr").add("Cidr", cidr()).add("State", stateAsString())
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidr", CIDR_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ByoipCidr, T> g) {
        return obj -> g.apply((ByoipCidr) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByoipCidr> {
        /**
         * <p>
         * The address range, in CIDR notation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
         * (BYOIP)</a> in the Global Accelerator Developer Guide.
         * </p>
         * 
         * @param cidr
         *        The address range, in CIDR notation.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
         *        addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The state of the address pool.
         * </p>
         * 
         * @param state
         *        The state of the address pool.
         * @see ByoipCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ByoipCidrState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the address pool.
         * </p>
         * 
         * @param state
         *        The state of the address pool.
         * @see ByoipCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ByoipCidrState
         */
        Builder state(ByoipCidrState state);

        /**
         * <p>
         * A history of status changes for an IP address range that you bring to Global Accelerator through bring your
         * own IP address (BYOIP).
         * </p>
         * 
         * @param events
         *        A history of status changes for an IP address range that you bring to Global Accelerator through bring
         *        your own IP address (BYOIP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<ByoipCidrEvent> events);

        /**
         * <p>
         * A history of status changes for an IP address range that you bring to Global Accelerator through bring your
         * own IP address (BYOIP).
         * </p>
         * 
         * @param events
         *        A history of status changes for an IP address range that you bring to Global Accelerator through bring
         *        your own IP address (BYOIP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(ByoipCidrEvent... events);

        /**
         * <p>
         * A history of status changes for an IP address range that you bring to Global Accelerator through bring your
         * own IP address (BYOIP).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #events(List<ByoipCidrEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<ByoipCidrEvent>)
         */
        Builder events(Consumer<ByoipCidrEvent.Builder>... events);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String state;

        private List<ByoipCidrEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ByoipCidr model) {
            cidr(model.cidr);
            state(model.state);
            events(model.events);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ByoipCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<ByoipCidrEvent.Builder> getEvents() {
            List<ByoipCidrEvent.Builder> result = ByoipCidrEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<ByoipCidrEvent.BuilderImpl> events) {
            this.events = ByoipCidrEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<ByoipCidrEvent> events) {
            this.events = ByoipCidrEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ByoipCidrEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ByoipCidrEvent.Builder>... events) {
            events(Stream.of(events).map(c -> ByoipCidrEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ByoipCidr build() {
            return new ByoipCidr(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
