/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddEndpointsRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<AddEndpointsRequest.Builder, AddEndpointsRequest> {
    private static final SdkField<List<EndpointConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField
            .<List<EndpointConfiguration>> builder(MarshallingType.LIST)
            .memberName("EndpointConfigurations")
            .getter(getter(AddEndpointsRequest::endpointConfigurations))
            .setter(setter(Builder::endpointConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(AddEndpointsRequest::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIGURATIONS_FIELD,
            ENDPOINT_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EndpointConfiguration> endpointConfigurations;

    private final String endpointGroupArn;

    private AddEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigurations = builder.endpointConfigurations;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEndpointConfigurations() {
        return endpointConfigurations != null && !(endpointConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of endpoint objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointConfigurations} method.
     * </p>
     * 
     * @return The list of endpoint objects.
     */
    public final List<EndpointConfiguration> endpointConfigurations() {
        return endpointConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointConfigurations() ? endpointConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddEndpointsRequest)) {
            return false;
        }
        AddEndpointsRequest other = (AddEndpointsRequest) obj;
        return hasEndpointConfigurations() == other.hasEndpointConfigurations()
                && Objects.equals(endpointConfigurations(), other.endpointConfigurations())
                && Objects.equals(endpointGroupArn(), other.endpointGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddEndpointsRequest")
                .add("EndpointConfigurations", hasEndpointConfigurations() ? endpointConfigurations() : null)
                .add("EndpointGroupArn", endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigurations":
            return Optional.ofNullable(clazz.cast(endpointConfigurations()));
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointConfigurations", ENDPOINT_CONFIGURATIONS_FIELD);
        map.put("EndpointGroupArn", ENDPOINT_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddEndpointsRequest, T> g) {
        return obj -> g.apply((AddEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddEndpointsRequest> {
        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * 
         * @param endpointConfigurations
         *        The list of endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations);

        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * 
         * @param endpointConfigurations
         *        The list of endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(EndpointConfiguration... endpointConfigurations);

        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #endpointConfigurations(List<EndpointConfiguration>)}.
         * 
         * @param endpointConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfigurations(java.util.Collection<EndpointConfiguration>)
         */
        Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder>... endpointConfigurations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private List<EndpointConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddEndpointsRequest model) {
            super(model);
            endpointConfigurations(model.endpointConfigurations);
            endpointGroupArn(model.endpointGroupArn);
        }

        public final List<EndpointConfiguration.Builder> getEndpointConfigurations() {
            List<EndpointConfiguration.Builder> result = EndpointConfigurationsCopier.copyToBuilder(this.endpointConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointConfigurations(Collection<EndpointConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        @Override
        public final Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointConfiguration... endpointConfigurations) {
            endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder>... endpointConfigurations) {
            endpointConfigurations(Stream.of(endpointConfigurations)
                    .map(c -> EndpointConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddEndpointsRequest build() {
            return new AddEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
