/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of in-progress multipart uploads for a vault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<UploadListElement.Builder, UploadListElement> {
    private static final SdkField<String> MULTIPART_UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultipartUploadId").getter(getter(UploadListElement::multipartUploadId))
            .setter(setter(Builder::multipartUploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipartUploadId").build()).build();

    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultARN").getter(getter(UploadListElement::vaultARN)).setter(setter(Builder::vaultARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()).build();

    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveDescription").getter(getter(UploadListElement::archiveDescription))
            .setter(setter(Builder::archiveDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveDescription").build())
            .build();

    private static final SdkField<Long> PART_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PartSizeInBytes").getter(getter(UploadListElement::partSizeInBytes))
            .setter(setter(Builder::partSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartSizeInBytes").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(UploadListElement::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPART_UPLOAD_ID_FIELD,
            VAULT_ARN_FIELD, ARCHIVE_DESCRIPTION_FIELD, PART_SIZE_IN_BYTES_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String multipartUploadId;

    private final String vaultARN;

    private final String archiveDescription;

    private final Long partSizeInBytes;

    private final String creationDate;

    private UploadListElement(BuilderImpl builder) {
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ID of a multipart upload.
     * </p>
     * 
     * @return The ID of a multipart upload.
     */
    public final String multipartUploadId() {
        return multipartUploadId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vault that contains the archive.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vault that contains the archive.
     */
    public final String vaultARN() {
        return vaultARN;
    }

    /**
     * <p>
     * The description of the archive that was specified in the Initiate Multipart Upload request.
     * </p>
     * 
     * @return The description of the archive that was specified in the Initiate Multipart Upload request.
     */
    public final String archiveDescription() {
        return archiveDescription;
    }

    /**
     * <p>
     * The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in
     * the upload except the last part, which may be smaller than this size.
     * </p>
     * 
     * @return The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the
     *         parts in the upload except the last part, which may be smaller than this size.
     */
    public final Long partSizeInBytes() {
        return partSizeInBytes;
    }

    /**
     * <p>
     * The UTC time at which the multipart upload was initiated.
     * </p>
     * 
     * @return The UTC time at which the multipart upload was initiated.
     */
    public final String creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multipartUploadId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(partSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadListElement)) {
            return false;
        }
        UploadListElement other = (UploadListElement) obj;
        return Objects.equals(multipartUploadId(), other.multipartUploadId()) && Objects.equals(vaultARN(), other.vaultARN())
                && Objects.equals(archiveDescription(), other.archiveDescription())
                && Objects.equals(partSizeInBytes(), other.partSizeInBytes())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadListElement").add("MultipartUploadId", multipartUploadId()).add("VaultARN", vaultARN())
                .add("ArchiveDescription", archiveDescription()).add("PartSizeInBytes", partSizeInBytes())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultipartUploadId":
            return Optional.ofNullable(clazz.cast(multipartUploadId()));
        case "VaultARN":
            return Optional.ofNullable(clazz.cast(vaultARN()));
        case "ArchiveDescription":
            return Optional.ofNullable(clazz.cast(archiveDescription()));
        case "PartSizeInBytes":
            return Optional.ofNullable(clazz.cast(partSizeInBytes()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultipartUploadId", MULTIPART_UPLOAD_ID_FIELD);
        map.put("VaultARN", VAULT_ARN_FIELD);
        map.put("ArchiveDescription", ARCHIVE_DESCRIPTION_FIELD);
        map.put("PartSizeInBytes", PART_SIZE_IN_BYTES_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadListElement, T> g) {
        return obj -> g.apply((UploadListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UploadListElement> {
        /**
         * <p>
         * The ID of a multipart upload.
         * </p>
         * 
         * @param multipartUploadId
         *        The ID of a multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipartUploadId(String multipartUploadId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vault that contains the archive.
         * </p>
         * 
         * @param vaultARN
         *        The Amazon Resource Name (ARN) of the vault that contains the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultARN(String vaultARN);

        /**
         * <p>
         * The description of the archive that was specified in the Initiate Multipart Upload request.
         * </p>
         * 
         * @param archiveDescription
         *        The description of the archive that was specified in the Initiate Multipart Upload request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveDescription(String archiveDescription);

        /**
         * <p>
         * The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the
         * parts in the upload except the last part, which may be smaller than this size.
         * </p>
         * 
         * @param partSizeInBytes
         *        The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all
         *        the parts in the upload except the last part, which may be smaller than this size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partSizeInBytes(Long partSizeInBytes);

        /**
         * <p>
         * The UTC time at which the multipart upload was initiated.
         * </p>
         * 
         * @param creationDate
         *        The UTC time at which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String multipartUploadId;

        private String vaultARN;

        private String archiveDescription;

        private Long partSizeInBytes;

        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadListElement model) {
            multipartUploadId(model.multipartUploadId);
            vaultARN(model.vaultARN);
            archiveDescription(model.archiveDescription);
            partSizeInBytes(model.partSizeInBytes);
            creationDate(model.creationDate);
        }

        public final String getMultipartUploadId() {
            return multipartUploadId;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        @Override
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final String getVaultARN() {
            return vaultARN;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final String getArchiveDescription() {
            return archiveDescription;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final Long getPartSizeInBytes() {
            return partSizeInBytes;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        @Override
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public UploadListElement build() {
            return new UploadListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
