/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides options for defining a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobParameters implements SdkPojo, Serializable, ToCopyableBuilder<JobParameters.Builder, JobParameters> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(JobParameters::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(JobParameters::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(JobParameters::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(JobParameters::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SNSTopic").getter(getter(JobParameters::snsTopic)).setter(setter(Builder::snsTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopic").build()).build();

    private static final SdkField<String> RETRIEVAL_BYTE_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalByteRange").getter(getter(JobParameters::retrievalByteRange))
            .setter(setter(Builder::retrievalByteRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalByteRange").build())
            .build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(JobParameters::tier)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<InventoryRetrievalJobInput> INVENTORY_RETRIEVAL_PARAMETERS_FIELD = SdkField
            .<InventoryRetrievalJobInput> builder(MarshallingType.SDK_POJO)
            .memberName("InventoryRetrievalParameters")
            .getter(getter(JobParameters::inventoryRetrievalParameters))
            .setter(setter(Builder::inventoryRetrievalParameters))
            .constructor(InventoryRetrievalJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryRetrievalParameters")
                    .build()).build();

    private static final SdkField<SelectParameters> SELECT_PARAMETERS_FIELD = SdkField
            .<SelectParameters> builder(MarshallingType.SDK_POJO).memberName("SelectParameters")
            .getter(getter(JobParameters::selectParameters)).setter(setter(Builder::selectParameters))
            .constructor(SelectParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectParameters").build()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).memberName("OutputLocation")
            .getter(getter(JobParameters::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, TYPE_FIELD,
            ARCHIVE_ID_FIELD, DESCRIPTION_FIELD, SNS_TOPIC_FIELD, RETRIEVAL_BYTE_RANGE_FIELD, TIER_FIELD,
            INVENTORY_RETRIEVAL_PARAMETERS_FIELD, SELECT_PARAMETERS_FIELD, OUTPUT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String type;

    private final String archiveId;

    private final String description;

    private final String snsTopic;

    private final String retrievalByteRange;

    private final String tier;

    private final InventoryRetrievalJobInput inventoryRetrievalParameters;

    private final SelectParameters selectParameters;

    private final OutputLocation outputLocation;

    private JobParameters(BuilderImpl builder) {
        this.format = builder.format;
        this.type = builder.type;
        this.archiveId = builder.archiveId;
        this.description = builder.description;
        this.snsTopic = builder.snsTopic;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
        this.selectParameters = builder.selectParameters;
        this.outputLocation = builder.outputLocation;
    }

    /**
     * <p>
     * When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to
     * specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the
     * default format. Valid values are "CSV" and "JSON".
     * </p>
     * 
     * @return When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your
     *         request to specify the output format. If you are initiating an inventory job and do not specify a Format
     *         field, JSON is the default format. Valid values are "CSV" and "JSON".
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an
     * inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".
     * </p>
     * 
     * @return The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get
     *         an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to
     * <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request
     * parameter for an inventory retrieval job request.
     * </p>
     * 
     * @return The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set
     *         to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this
     *         request parameter for an inventory retrieval job request.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable
     * characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E
     * hexadecimal.
     * </p>
     * 
     * @return The optional description for the job. The description must be less than or equal to 1,024 bytes. The
     *         allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or
     *         0x20-0x7E hexadecimal.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output
     * is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic
     * must exist.
     * </p>
     * 
     * @return The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and
     *         the output is ready for you to download. The specified topic publishes the notification to its
     *         subscribers. The SNS topic must exist.
     */
    public final String snsTopic() {
        return snsTopic;
    }

    /**
     * <p>
     * The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If
     * not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned
     * which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible
     * by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is
     * not megabyte aligned, this operation returns a 400 response.
     * </p>
     * <p>
     * An error occurs if you specify this field for an inventory retrieval job request.
     * </p>
     * 
     * @return The byte range to retrieve for an archive retrieval. in the form
     *         "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If
     *         specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i>
     *         must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the
     *         archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned,
     *         this operation returns a 400 response. </p>
     *         <p>
     *         An error occurs if you specify this field for an inventory retrieval job request.
     */
    public final String retrievalByteRange() {
        return retrievalByteRange;
    }

    /**
     * <p>
     * The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>,
     * <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
     * </p>
     * 
     * @return The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>,
     *         <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
     */
    public final String tier() {
        return tier;
    }

    /**
     * <p>
     * Input parameters used for range inventory retrieval.
     * </p>
     * 
     * @return Input parameters used for range inventory retrieval.
     */
    public final InventoryRetrievalJobInput inventoryRetrievalParameters() {
        return inventoryRetrievalParameters;
    }

    /**
     * <p>
     * Contains the parameters that define a job.
     * </p>
     * 
     * @return Contains the parameters that define a job.
     */
    public final SelectParameters selectParameters() {
        return selectParameters;
    }

    /**
     * <p>
     * Contains information about the location where the select job results are stored.
     * </p>
     * 
     * @return Contains information about the location where the select job results are stored.
     */
    public final OutputLocation outputLocation() {
        return outputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryRetrievalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(selectParameters());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        JobParameters other = (JobParameters) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(type(), other.type())
                && Objects.equals(archiveId(), other.archiveId()) && Objects.equals(description(), other.description())
                && Objects.equals(snsTopic(), other.snsTopic())
                && Objects.equals(retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(tier(), other.tier())
                && Objects.equals(inventoryRetrievalParameters(), other.inventoryRetrievalParameters())
                && Objects.equals(selectParameters(), other.selectParameters())
                && Objects.equals(outputLocation(), other.outputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobParameters").add("Format", format()).add("Type", type()).add("ArchiveId", archiveId())
                .add("Description", description()).add("SNSTopic", snsTopic()).add("RetrievalByteRange", retrievalByteRange())
                .add("Tier", tier()).add("InventoryRetrievalParameters", inventoryRetrievalParameters())
                .add("SelectParameters", selectParameters()).add("OutputLocation", outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SNSTopic":
            return Optional.ofNullable(clazz.cast(snsTopic()));
        case "RetrievalByteRange":
            return Optional.ofNullable(clazz.cast(retrievalByteRange()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "InventoryRetrievalParameters":
            return Optional.ofNullable(clazz.cast(inventoryRetrievalParameters()));
        case "SelectParameters":
            return Optional.ofNullable(clazz.cast(selectParameters()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Format", FORMAT_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SNSTopic", SNS_TOPIC_FIELD);
        map.put("RetrievalByteRange", RETRIEVAL_BYTE_RANGE_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("InventoryRetrievalParameters", INVENTORY_RETRIEVAL_PARAMETERS_FIELD);
        map.put("SelectParameters", SELECT_PARAMETERS_FIELD);
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobParameters, T> g) {
        return obj -> g.apply((JobParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobParameters> {
        /**
         * <p>
         * When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to
         * specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is
         * the default format. Valid values are "CSV" and "JSON".
         * </p>
         * 
         * @param format
         *        When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your
         *        request to specify the output format. If you are initiating an inventory job and do not specify a
         *        Format field, JSON is the default format. Valid values are "CSV" and "JSON".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an
         * inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".
         * </p>
         * 
         * @param type
         *        The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or
         *        get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to
         * <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request
         * parameter for an inventory retrieval job request.
         * </p>
         * 
         * @param archiveId
         *        The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is
         *        set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify
         *        this request parameter for an inventory retrieval job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * The optional description for the job. The description must be less than or equal to 1,024 bytes. The
         * allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or
         * 0x20-0x7E hexadecimal.
         * </p>
         * 
         * @param description
         *        The optional description for the job. The description must be less than or equal to 1,024 bytes. The
         *        allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal
         *        or 0x20-0x7E hexadecimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the
         * output is ready for you to download. The specified topic publishes the notification to its subscribers. The
         * SNS topic must exist.
         * </p>
         * 
         * @param snsTopic
         *        The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and
         *        the output is ready for you to download. The specified topic publishes the notification to its
         *        subscribers. The SNS topic must exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopic(String snsTopic);

        /**
         * <p>
         * The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>"
         * If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024)
         * aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must
         * be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If
         * RetrievalByteRange is not megabyte aligned, this operation returns a 400 response.
         * </p>
         * <p>
         * An error occurs if you specify this field for an inventory retrieval job request.
         * </p>
         * 
         * @param retrievalByteRange
         *        The byte range to retrieve for an archive retrieval. in the form
         *        "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If
         *        specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i>
         *        must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of
         *        the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte
         *        aligned, this operation returns a 400 response. </p>
         *        <p>
         *        An error occurs if you specify this field for an inventory retrieval job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalByteRange(String retrievalByteRange);

        /**
         * <p>
         * The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>,
         * <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
         * </p>
         * 
         * @param tier
         *        The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>,
         *        <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(String tier);

        /**
         * <p>
         * Input parameters used for range inventory retrieval.
         * </p>
         * 
         * @param inventoryRetrievalParameters
         *        Input parameters used for range inventory retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters);

        /**
         * <p>
         * Input parameters used for range inventory retrieval.
         * </p>
         * This is a convenience method that creates an instance of the {@link InventoryRetrievalJobInput.Builder}
         * avoiding the need to create one manually via {@link InventoryRetrievalJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InventoryRetrievalJobInput.Builder#build()} is called immediately
         * and its result is passed to {@link #inventoryRetrievalParameters(InventoryRetrievalJobInput)}.
         * 
         * @param inventoryRetrievalParameters
         *        a consumer that will call methods on {@link InventoryRetrievalJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryRetrievalParameters(InventoryRetrievalJobInput)
         */
        default Builder inventoryRetrievalParameters(Consumer<InventoryRetrievalJobInput.Builder> inventoryRetrievalParameters) {
            return inventoryRetrievalParameters(InventoryRetrievalJobInput.builder().applyMutation(inventoryRetrievalParameters)
                    .build());
        }

        /**
         * <p>
         * Contains the parameters that define a job.
         * </p>
         * 
         * @param selectParameters
         *        Contains the parameters that define a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectParameters(SelectParameters selectParameters);

        /**
         * <p>
         * Contains the parameters that define a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectParameters.Builder} avoiding the
         * need to create one manually via {@link SelectParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #selectParameters(SelectParameters)}.
         * 
         * @param selectParameters
         *        a consumer that will call methods on {@link SelectParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectParameters(SelectParameters)
         */
        default Builder selectParameters(Consumer<SelectParameters.Builder> selectParameters) {
            return selectParameters(SelectParameters.builder().applyMutation(selectParameters).build());
        }

        /**
         * <p>
         * Contains information about the location where the select job results are stored.
         * </p>
         * 
         * @param outputLocation
         *        Contains information about the location where the select job results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * <p>
         * Contains information about the location where the select job results are stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputLocation.Builder} avoiding the need
         * to create one manually via {@link OutputLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String type;

        private String archiveId;

        private String description;

        private String snsTopic;

        private String retrievalByteRange;

        private String tier;

        private InventoryRetrievalJobInput inventoryRetrievalParameters;

        private SelectParameters selectParameters;

        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(JobParameters model) {
            format(model.format);
            type(model.type);
            archiveId(model.archiveId);
            description(model.description);
            snsTopic(model.snsTopic);
            retrievalByteRange(model.retrievalByteRange);
            tier(model.tier);
            inventoryRetrievalParameters(model.inventoryRetrievalParameters);
            selectParameters(model.selectParameters);
            outputLocation(model.outputLocation);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSnsTopic() {
            return snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final String getRetrievalByteRange() {
            return retrievalByteRange;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final InventoryRetrievalJobInput.Builder getInventoryRetrievalParameters() {
            return inventoryRetrievalParameters != null ? inventoryRetrievalParameters.toBuilder() : null;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobInput.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build()
                    : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final SelectParameters.Builder getSelectParameters() {
            return selectParameters != null ? selectParameters.toBuilder() : null;
        }

        public final void setSelectParameters(SelectParameters.BuilderImpl selectParameters) {
            this.selectParameters = selectParameters != null ? selectParameters.build() : null;
        }

        @Override
        public final Builder selectParameters(SelectParameters selectParameters) {
            this.selectParameters = selectParameters;
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        @Override
        public JobParameters build() {
            return new JobParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
