/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class LocationalDeploymentsCopier {
    static Map<String, LocationalDeployment> copy(Map<String, ? extends LocationalDeployment> locationalDeploymentsParam) {
        Map<String, LocationalDeployment> map;
        if (locationalDeploymentsParam == null || locationalDeploymentsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LocationalDeployment> modifiableMap = new LinkedHashMap<>(locationalDeploymentsParam.size());
            locationalDeploymentsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LocationalDeployment> copyFromBuilder(
            Map<String, ? extends LocationalDeployment.Builder> locationalDeploymentsParam) {
        Map<String, LocationalDeployment> map;
        if (locationalDeploymentsParam == null || locationalDeploymentsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LocationalDeployment> modifiableMap = new LinkedHashMap<>(locationalDeploymentsParam.size());
            locationalDeploymentsParam.forEach((key, value) -> {
                LocationalDeployment member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LocationalDeployment.Builder> copyToBuilder(
            Map<String, ? extends LocationalDeployment> locationalDeploymentsParam) {
        Map<String, LocationalDeployment.Builder> map;
        if (locationalDeploymentsParam == null || locationalDeploymentsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LocationalDeployment.Builder> modifiableMap = new LinkedHashMap<>(locationalDeploymentsParam.size());
            locationalDeploymentsParam.forEach((key, value) -> {
                LocationalDeployment.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
