/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContainerFleetsResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListContainerFleetsResponse.Builder, ListContainerFleetsResponse> {
    private static final SdkField<List<ContainerFleet>> CONTAINER_FLEETS_FIELD = SdkField
            .<List<ContainerFleet>> builder(MarshallingType.LIST)
            .memberName("ContainerFleets")
            .getter(getter(ListContainerFleetsResponse::containerFleets))
            .setter(setter(Builder::containerFleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFleets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerFleet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerFleet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContainerFleetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FLEETS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ContainerFleet> containerFleets;

    private final String nextToken;

    private ListContainerFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.containerFleets = builder.containerFleets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerFleets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerFleets() {
        return containerFleets != null && !(containerFleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of container fleet objects for all fleets that match the request criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerFleets} method.
     * </p>
     * 
     * @return A collection of container fleet objects for all fleets that match the request criteria.
     */
    public final List<ContainerFleet> containerFleets() {
        return containerFleets;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerFleets() ? containerFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerFleetsResponse)) {
            return false;
        }
        ListContainerFleetsResponse other = (ListContainerFleetsResponse) obj;
        return hasContainerFleets() == other.hasContainerFleets() && Objects.equals(containerFleets(), other.containerFleets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContainerFleetsResponse")
                .add("ContainerFleets", hasContainerFleets() ? containerFleets() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerFleets":
            return Optional.ofNullable(clazz.cast(containerFleets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerFleets", CONTAINER_FLEETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContainerFleetsResponse, T> g) {
        return obj -> g.apply((ListContainerFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContainerFleetsResponse> {
        /**
         * <p>
         * A collection of container fleet objects for all fleets that match the request criteria.
         * </p>
         * 
         * @param containerFleets
         *        A collection of container fleet objects for all fleets that match the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerFleets(Collection<ContainerFleet> containerFleets);

        /**
         * <p>
         * A collection of container fleet objects for all fleets that match the request criteria.
         * </p>
         * 
         * @param containerFleets
         *        A collection of container fleet objects for all fleets that match the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerFleets(ContainerFleet... containerFleets);

        /**
         * <p>
         * A collection of container fleet objects for all fleets that match the request criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerFleet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.ContainerFleet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerFleet.Builder#build()} is called immediately
         * and its result is passed to {@link #containerFleets(List<ContainerFleet>)}.
         * 
         * @param containerFleets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerFleet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerFleets(java.util.Collection<ContainerFleet>)
         */
        Builder containerFleets(Consumer<ContainerFleet.Builder>... containerFleets);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<ContainerFleet> containerFleets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerFleetsResponse model) {
            super(model);
            containerFleets(model.containerFleets);
            nextToken(model.nextToken);
        }

        public final List<ContainerFleet.Builder> getContainerFleets() {
            List<ContainerFleet.Builder> result = ContainerFleetListCopier.copyToBuilder(this.containerFleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerFleets(Collection<ContainerFleet.BuilderImpl> containerFleets) {
            this.containerFleets = ContainerFleetListCopier.copyFromBuilder(containerFleets);
        }

        @Override
        public final Builder containerFleets(Collection<ContainerFleet> containerFleets) {
            this.containerFleets = ContainerFleetListCopier.copy(containerFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerFleets(ContainerFleet... containerFleets) {
            containerFleets(Arrays.asList(containerFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerFleets(Consumer<ContainerFleet.Builder>... containerFleets) {
            containerFleets(Stream.of(containerFleets).map(c -> ContainerFleet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContainerFleetsResponse build() {
            return new ListContainerFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
