/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum EC2InstanceType {
    T2_MICRO("t2.micro"),

    T2_SMALL("t2.small"),

    T2_MEDIUM("t2.medium"),

    T2_LARGE("t2.large"),

    C3_LARGE("c3.large"),

    C3_XLARGE("c3.xlarge"),

    C3_2_XLARGE("c3.2xlarge"),

    C3_4_XLARGE("c3.4xlarge"),

    C3_8_XLARGE("c3.8xlarge"),

    C4_LARGE("c4.large"),

    C4_XLARGE("c4.xlarge"),

    C4_2_XLARGE("c4.2xlarge"),

    C4_4_XLARGE("c4.4xlarge"),

    C4_8_XLARGE("c4.8xlarge"),

    C5_LARGE("c5.large"),

    C5_XLARGE("c5.xlarge"),

    C5_2_XLARGE("c5.2xlarge"),

    C5_4_XLARGE("c5.4xlarge"),

    C5_9_XLARGE("c5.9xlarge"),

    C5_12_XLARGE("c5.12xlarge"),

    C5_18_XLARGE("c5.18xlarge"),

    C5_24_XLARGE("c5.24xlarge"),

    C5_A_LARGE("c5a.large"),

    C5_A_XLARGE("c5a.xlarge"),

    C5_A_2_XLARGE("c5a.2xlarge"),

    C5_A_4_XLARGE("c5a.4xlarge"),

    C5_A_8_XLARGE("c5a.8xlarge"),

    C5_A_12_XLARGE("c5a.12xlarge"),

    C5_A_16_XLARGE("c5a.16xlarge"),

    C5_A_24_XLARGE("c5a.24xlarge"),

    R3_LARGE("r3.large"),

    R3_XLARGE("r3.xlarge"),

    R3_2_XLARGE("r3.2xlarge"),

    R3_4_XLARGE("r3.4xlarge"),

    R3_8_XLARGE("r3.8xlarge"),

    R4_LARGE("r4.large"),

    R4_XLARGE("r4.xlarge"),

    R4_2_XLARGE("r4.2xlarge"),

    R4_4_XLARGE("r4.4xlarge"),

    R4_8_XLARGE("r4.8xlarge"),

    R4_16_XLARGE("r4.16xlarge"),

    R5_LARGE("r5.large"),

    R5_XLARGE("r5.xlarge"),

    R5_2_XLARGE("r5.2xlarge"),

    R5_4_XLARGE("r5.4xlarge"),

    R5_8_XLARGE("r5.8xlarge"),

    R5_12_XLARGE("r5.12xlarge"),

    R5_16_XLARGE("r5.16xlarge"),

    R5_24_XLARGE("r5.24xlarge"),

    R5_A_LARGE("r5a.large"),

    R5_A_XLARGE("r5a.xlarge"),

    R5_A_2_XLARGE("r5a.2xlarge"),

    R5_A_4_XLARGE("r5a.4xlarge"),

    R5_A_8_XLARGE("r5a.8xlarge"),

    R5_A_12_XLARGE("r5a.12xlarge"),

    R5_A_16_XLARGE("r5a.16xlarge"),

    R5_A_24_XLARGE("r5a.24xlarge"),

    M3_MEDIUM("m3.medium"),

    M3_LARGE("m3.large"),

    M3_XLARGE("m3.xlarge"),

    M3_2_XLARGE("m3.2xlarge"),

    M4_LARGE("m4.large"),

    M4_XLARGE("m4.xlarge"),

    M4_2_XLARGE("m4.2xlarge"),

    M4_4_XLARGE("m4.4xlarge"),

    M4_10_XLARGE("m4.10xlarge"),

    M5_LARGE("m5.large"),

    M5_XLARGE("m5.xlarge"),

    M5_2_XLARGE("m5.2xlarge"),

    M5_4_XLARGE("m5.4xlarge"),

    M5_8_XLARGE("m5.8xlarge"),

    M5_12_XLARGE("m5.12xlarge"),

    M5_16_XLARGE("m5.16xlarge"),

    M5_24_XLARGE("m5.24xlarge"),

    M5_A_LARGE("m5a.large"),

    M5_A_XLARGE("m5a.xlarge"),

    M5_A_2_XLARGE("m5a.2xlarge"),

    M5_A_4_XLARGE("m5a.4xlarge"),

    M5_A_8_XLARGE("m5a.8xlarge"),

    M5_A_12_XLARGE("m5a.12xlarge"),

    M5_A_16_XLARGE("m5a.16xlarge"),

    M5_A_24_XLARGE("m5a.24xlarge"),

    C5_D_LARGE("c5d.large"),

    C5_D_XLARGE("c5d.xlarge"),

    C5_D_2_XLARGE("c5d.2xlarge"),

    C5_D_4_XLARGE("c5d.4xlarge"),

    C5_D_9_XLARGE("c5d.9xlarge"),

    C5_D_12_XLARGE("c5d.12xlarge"),

    C5_D_18_XLARGE("c5d.18xlarge"),

    C5_D_24_XLARGE("c5d.24xlarge"),

    C6_A_LARGE("c6a.large"),

    C6_A_XLARGE("c6a.xlarge"),

    C6_A_2_XLARGE("c6a.2xlarge"),

    C6_A_4_XLARGE("c6a.4xlarge"),

    C6_A_8_XLARGE("c6a.8xlarge"),

    C6_A_12_XLARGE("c6a.12xlarge"),

    C6_A_16_XLARGE("c6a.16xlarge"),

    C6_A_24_XLARGE("c6a.24xlarge"),

    C6_I_LARGE("c6i.large"),

    C6_I_XLARGE("c6i.xlarge"),

    C6_I_2_XLARGE("c6i.2xlarge"),

    C6_I_4_XLARGE("c6i.4xlarge"),

    C6_I_8_XLARGE("c6i.8xlarge"),

    C6_I_12_XLARGE("c6i.12xlarge"),

    C6_I_16_XLARGE("c6i.16xlarge"),

    C6_I_24_XLARGE("c6i.24xlarge"),

    R5_D_LARGE("r5d.large"),

    R5_D_XLARGE("r5d.xlarge"),

    R5_D_2_XLARGE("r5d.2xlarge"),

    R5_D_4_XLARGE("r5d.4xlarge"),

    R5_D_8_XLARGE("r5d.8xlarge"),

    R5_D_12_XLARGE("r5d.12xlarge"),

    R5_D_16_XLARGE("r5d.16xlarge"),

    R5_D_24_XLARGE("r5d.24xlarge"),

    M6_G_MEDIUM("m6g.medium"),

    M6_G_LARGE("m6g.large"),

    M6_G_XLARGE("m6g.xlarge"),

    M6_G_2_XLARGE("m6g.2xlarge"),

    M6_G_4_XLARGE("m6g.4xlarge"),

    M6_G_8_XLARGE("m6g.8xlarge"),

    M6_G_12_XLARGE("m6g.12xlarge"),

    M6_G_16_XLARGE("m6g.16xlarge"),

    C6_G_MEDIUM("c6g.medium"),

    C6_G_LARGE("c6g.large"),

    C6_G_XLARGE("c6g.xlarge"),

    C6_G_2_XLARGE("c6g.2xlarge"),

    C6_G_4_XLARGE("c6g.4xlarge"),

    C6_G_8_XLARGE("c6g.8xlarge"),

    C6_G_12_XLARGE("c6g.12xlarge"),

    C6_G_16_XLARGE("c6g.16xlarge"),

    R6_G_MEDIUM("r6g.medium"),

    R6_G_LARGE("r6g.large"),

    R6_G_XLARGE("r6g.xlarge"),

    R6_G_2_XLARGE("r6g.2xlarge"),

    R6_G_4_XLARGE("r6g.4xlarge"),

    R6_G_8_XLARGE("r6g.8xlarge"),

    R6_G_12_XLARGE("r6g.12xlarge"),

    R6_G_16_XLARGE("r6g.16xlarge"),

    C6_GN_MEDIUM("c6gn.medium"),

    C6_GN_LARGE("c6gn.large"),

    C6_GN_XLARGE("c6gn.xlarge"),

    C6_GN_2_XLARGE("c6gn.2xlarge"),

    C6_GN_4_XLARGE("c6gn.4xlarge"),

    C6_GN_8_XLARGE("c6gn.8xlarge"),

    C6_GN_12_XLARGE("c6gn.12xlarge"),

    C6_GN_16_XLARGE("c6gn.16xlarge"),

    C7_G_MEDIUM("c7g.medium"),

    C7_G_LARGE("c7g.large"),

    C7_G_XLARGE("c7g.xlarge"),

    C7_G_2_XLARGE("c7g.2xlarge"),

    C7_G_4_XLARGE("c7g.4xlarge"),

    C7_G_8_XLARGE("c7g.8xlarge"),

    C7_G_12_XLARGE("c7g.12xlarge"),

    C7_G_16_XLARGE("c7g.16xlarge"),

    R7_G_MEDIUM("r7g.medium"),

    R7_G_LARGE("r7g.large"),

    R7_G_XLARGE("r7g.xlarge"),

    R7_G_2_XLARGE("r7g.2xlarge"),

    R7_G_4_XLARGE("r7g.4xlarge"),

    R7_G_8_XLARGE("r7g.8xlarge"),

    R7_G_12_XLARGE("r7g.12xlarge"),

    R7_G_16_XLARGE("r7g.16xlarge"),

    M7_G_MEDIUM("m7g.medium"),

    M7_G_LARGE("m7g.large"),

    M7_G_XLARGE("m7g.xlarge"),

    M7_G_2_XLARGE("m7g.2xlarge"),

    M7_G_4_XLARGE("m7g.4xlarge"),

    M7_G_8_XLARGE("m7g.8xlarge"),

    M7_G_12_XLARGE("m7g.12xlarge"),

    M7_G_16_XLARGE("m7g.16xlarge"),

    G5_G_XLARGE("g5g.xlarge"),

    G5_G_2_XLARGE("g5g.2xlarge"),

    G5_G_4_XLARGE("g5g.4xlarge"),

    G5_G_8_XLARGE("g5g.8xlarge"),

    G5_G_16_XLARGE("g5g.16xlarge"),

    R6_I_LARGE("r6i.large"),

    R6_I_XLARGE("r6i.xlarge"),

    R6_I_2_XLARGE("r6i.2xlarge"),

    R6_I_4_XLARGE("r6i.4xlarge"),

    R6_I_8_XLARGE("r6i.8xlarge"),

    R6_I_12_XLARGE("r6i.12xlarge"),

    R6_I_16_XLARGE("r6i.16xlarge"),

    C6_GD_MEDIUM("c6gd.medium"),

    C6_GD_LARGE("c6gd.large"),

    C6_GD_XLARGE("c6gd.xlarge"),

    C6_GD_2_XLARGE("c6gd.2xlarge"),

    C6_GD_4_XLARGE("c6gd.4xlarge"),

    C6_GD_8_XLARGE("c6gd.8xlarge"),

    C6_GD_12_XLARGE("c6gd.12xlarge"),

    C6_GD_16_XLARGE("c6gd.16xlarge"),

    C6_IN_LARGE("c6in.large"),

    C6_IN_XLARGE("c6in.xlarge"),

    C6_IN_2_XLARGE("c6in.2xlarge"),

    C6_IN_4_XLARGE("c6in.4xlarge"),

    C6_IN_8_XLARGE("c6in.8xlarge"),

    C6_IN_12_XLARGE("c6in.12xlarge"),

    C6_IN_16_XLARGE("c6in.16xlarge"),

    C7_A_MEDIUM("c7a.medium"),

    C7_A_LARGE("c7a.large"),

    C7_A_XLARGE("c7a.xlarge"),

    C7_A_2_XLARGE("c7a.2xlarge"),

    C7_A_4_XLARGE("c7a.4xlarge"),

    C7_A_8_XLARGE("c7a.8xlarge"),

    C7_A_12_XLARGE("c7a.12xlarge"),

    C7_A_16_XLARGE("c7a.16xlarge"),

    C7_GD_MEDIUM("c7gd.medium"),

    C7_GD_LARGE("c7gd.large"),

    C7_GD_XLARGE("c7gd.xlarge"),

    C7_GD_2_XLARGE("c7gd.2xlarge"),

    C7_GD_4_XLARGE("c7gd.4xlarge"),

    C7_GD_8_XLARGE("c7gd.8xlarge"),

    C7_GD_12_XLARGE("c7gd.12xlarge"),

    C7_GD_16_XLARGE("c7gd.16xlarge"),

    C7_GN_MEDIUM("c7gn.medium"),

    C7_GN_LARGE("c7gn.large"),

    C7_GN_XLARGE("c7gn.xlarge"),

    C7_GN_2_XLARGE("c7gn.2xlarge"),

    C7_GN_4_XLARGE("c7gn.4xlarge"),

    C7_GN_8_XLARGE("c7gn.8xlarge"),

    C7_GN_12_XLARGE("c7gn.12xlarge"),

    C7_GN_16_XLARGE("c7gn.16xlarge"),

    C7_I_LARGE("c7i.large"),

    C7_I_XLARGE("c7i.xlarge"),

    C7_I_2_XLARGE("c7i.2xlarge"),

    C7_I_4_XLARGE("c7i.4xlarge"),

    C7_I_8_XLARGE("c7i.8xlarge"),

    C7_I_12_XLARGE("c7i.12xlarge"),

    C7_I_16_XLARGE("c7i.16xlarge"),

    M6_A_LARGE("m6a.large"),

    M6_A_XLARGE("m6a.xlarge"),

    M6_A_2_XLARGE("m6a.2xlarge"),

    M6_A_4_XLARGE("m6a.4xlarge"),

    M6_A_8_XLARGE("m6a.8xlarge"),

    M6_A_12_XLARGE("m6a.12xlarge"),

    M6_A_16_XLARGE("m6a.16xlarge"),

    M6_GD_MEDIUM("m6gd.medium"),

    M6_GD_LARGE("m6gd.large"),

    M6_GD_XLARGE("m6gd.xlarge"),

    M6_GD_2_XLARGE("m6gd.2xlarge"),

    M6_GD_4_XLARGE("m6gd.4xlarge"),

    M6_GD_8_XLARGE("m6gd.8xlarge"),

    M6_GD_12_XLARGE("m6gd.12xlarge"),

    M6_GD_16_XLARGE("m6gd.16xlarge"),

    M6_I_LARGE("m6i.large"),

    M6_I_XLARGE("m6i.xlarge"),

    M6_I_2_XLARGE("m6i.2xlarge"),

    M6_I_4_XLARGE("m6i.4xlarge"),

    M6_I_8_XLARGE("m6i.8xlarge"),

    M6_I_12_XLARGE("m6i.12xlarge"),

    M6_I_16_XLARGE("m6i.16xlarge"),

    M7_A_MEDIUM("m7a.medium"),

    M7_A_LARGE("m7a.large"),

    M7_A_XLARGE("m7a.xlarge"),

    M7_A_2_XLARGE("m7a.2xlarge"),

    M7_A_4_XLARGE("m7a.4xlarge"),

    M7_A_8_XLARGE("m7a.8xlarge"),

    M7_A_12_XLARGE("m7a.12xlarge"),

    M7_A_16_XLARGE("m7a.16xlarge"),

    M7_GD_MEDIUM("m7gd.medium"),

    M7_GD_LARGE("m7gd.large"),

    M7_GD_XLARGE("m7gd.xlarge"),

    M7_GD_2_XLARGE("m7gd.2xlarge"),

    M7_GD_4_XLARGE("m7gd.4xlarge"),

    M7_GD_8_XLARGE("m7gd.8xlarge"),

    M7_GD_12_XLARGE("m7gd.12xlarge"),

    M7_GD_16_XLARGE("m7gd.16xlarge"),

    M7_I_LARGE("m7i.large"),

    M7_I_XLARGE("m7i.xlarge"),

    M7_I_2_XLARGE("m7i.2xlarge"),

    M7_I_4_XLARGE("m7i.4xlarge"),

    M7_I_8_XLARGE("m7i.8xlarge"),

    M7_I_12_XLARGE("m7i.12xlarge"),

    M7_I_16_XLARGE("m7i.16xlarge"),

    R6_GD_MEDIUM("r6gd.medium"),

    R6_GD_LARGE("r6gd.large"),

    R6_GD_XLARGE("r6gd.xlarge"),

    R6_GD_2_XLARGE("r6gd.2xlarge"),

    R6_GD_4_XLARGE("r6gd.4xlarge"),

    R6_GD_8_XLARGE("r6gd.8xlarge"),

    R6_GD_12_XLARGE("r6gd.12xlarge"),

    R6_GD_16_XLARGE("r6gd.16xlarge"),

    R7_A_MEDIUM("r7a.medium"),

    R7_A_LARGE("r7a.large"),

    R7_A_XLARGE("r7a.xlarge"),

    R7_A_2_XLARGE("r7a.2xlarge"),

    R7_A_4_XLARGE("r7a.4xlarge"),

    R7_A_8_XLARGE("r7a.8xlarge"),

    R7_A_12_XLARGE("r7a.12xlarge"),

    R7_A_16_XLARGE("r7a.16xlarge"),

    R7_GD_MEDIUM("r7gd.medium"),

    R7_GD_LARGE("r7gd.large"),

    R7_GD_XLARGE("r7gd.xlarge"),

    R7_GD_2_XLARGE("r7gd.2xlarge"),

    R7_GD_4_XLARGE("r7gd.4xlarge"),

    R7_GD_8_XLARGE("r7gd.8xlarge"),

    R7_GD_12_XLARGE("r7gd.12xlarge"),

    R7_GD_16_XLARGE("r7gd.16xlarge"),

    R7_I_LARGE("r7i.large"),

    R7_I_XLARGE("r7i.xlarge"),

    R7_I_2_XLARGE("r7i.2xlarge"),

    R7_I_4_XLARGE("r7i.4xlarge"),

    R7_I_8_XLARGE("r7i.8xlarge"),

    R7_I_12_XLARGE("r7i.12xlarge"),

    R7_I_16_XLARGE("r7i.16xlarge"),

    R7_I_24_XLARGE("r7i.24xlarge"),

    R7_I_48_XLARGE("r7i.48xlarge"),

    C5_AD_LARGE("c5ad.large"),

    C5_AD_XLARGE("c5ad.xlarge"),

    C5_AD_2_XLARGE("c5ad.2xlarge"),

    C5_AD_4_XLARGE("c5ad.4xlarge"),

    C5_AD_8_XLARGE("c5ad.8xlarge"),

    C5_AD_12_XLARGE("c5ad.12xlarge"),

    C5_AD_16_XLARGE("c5ad.16xlarge"),

    C5_AD_24_XLARGE("c5ad.24xlarge"),

    C5_N_LARGE("c5n.large"),

    C5_N_XLARGE("c5n.xlarge"),

    C5_N_2_XLARGE("c5n.2xlarge"),

    C5_N_4_XLARGE("c5n.4xlarge"),

    C5_N_9_XLARGE("c5n.9xlarge"),

    C5_N_18_XLARGE("c5n.18xlarge"),

    R5_AD_LARGE("r5ad.large"),

    R5_AD_XLARGE("r5ad.xlarge"),

    R5_AD_2_XLARGE("r5ad.2xlarge"),

    R5_AD_4_XLARGE("r5ad.4xlarge"),

    R5_AD_8_XLARGE("r5ad.8xlarge"),

    R5_AD_12_XLARGE("r5ad.12xlarge"),

    R5_AD_16_XLARGE("r5ad.16xlarge"),

    R5_AD_24_XLARGE("r5ad.24xlarge"),

    C6_ID_LARGE("c6id.large"),

    C6_ID_XLARGE("c6id.xlarge"),

    C6_ID_2_XLARGE("c6id.2xlarge"),

    C6_ID_4_XLARGE("c6id.4xlarge"),

    C6_ID_8_XLARGE("c6id.8xlarge"),

    C6_ID_12_XLARGE("c6id.12xlarge"),

    C6_ID_16_XLARGE("c6id.16xlarge"),

    C6_ID_24_XLARGE("c6id.24xlarge"),

    C6_ID_32_XLARGE("c6id.32xlarge"),

    C8_G_MEDIUM("c8g.medium"),

    C8_G_LARGE("c8g.large"),

    C8_G_XLARGE("c8g.xlarge"),

    C8_G_2_XLARGE("c8g.2xlarge"),

    C8_G_4_XLARGE("c8g.4xlarge"),

    C8_G_8_XLARGE("c8g.8xlarge"),

    C8_G_12_XLARGE("c8g.12xlarge"),

    C8_G_16_XLARGE("c8g.16xlarge"),

    C8_G_24_XLARGE("c8g.24xlarge"),

    C8_G_48_XLARGE("c8g.48xlarge"),

    M5_AD_LARGE("m5ad.large"),

    M5_AD_XLARGE("m5ad.xlarge"),

    M5_AD_2_XLARGE("m5ad.2xlarge"),

    M5_AD_4_XLARGE("m5ad.4xlarge"),

    M5_AD_8_XLARGE("m5ad.8xlarge"),

    M5_AD_12_XLARGE("m5ad.12xlarge"),

    M5_AD_16_XLARGE("m5ad.16xlarge"),

    M5_AD_24_XLARGE("m5ad.24xlarge"),

    M5_D_LARGE("m5d.large"),

    M5_D_XLARGE("m5d.xlarge"),

    M5_D_2_XLARGE("m5d.2xlarge"),

    M5_D_4_XLARGE("m5d.4xlarge"),

    M5_D_8_XLARGE("m5d.8xlarge"),

    M5_D_12_XLARGE("m5d.12xlarge"),

    M5_D_16_XLARGE("m5d.16xlarge"),

    M5_D_24_XLARGE("m5d.24xlarge"),

    M5_DN_LARGE("m5dn.large"),

    M5_DN_XLARGE("m5dn.xlarge"),

    M5_DN_2_XLARGE("m5dn.2xlarge"),

    M5_DN_4_XLARGE("m5dn.4xlarge"),

    M5_DN_8_XLARGE("m5dn.8xlarge"),

    M5_DN_12_XLARGE("m5dn.12xlarge"),

    M5_DN_16_XLARGE("m5dn.16xlarge"),

    M5_DN_24_XLARGE("m5dn.24xlarge"),

    M5_N_LARGE("m5n.large"),

    M5_N_XLARGE("m5n.xlarge"),

    M5_N_2_XLARGE("m5n.2xlarge"),

    M5_N_4_XLARGE("m5n.4xlarge"),

    M5_N_8_XLARGE("m5n.8xlarge"),

    M5_N_12_XLARGE("m5n.12xlarge"),

    M5_N_16_XLARGE("m5n.16xlarge"),

    M5_N_24_XLARGE("m5n.24xlarge"),

    M6_ID_LARGE("m6id.large"),

    M6_ID_XLARGE("m6id.xlarge"),

    M6_ID_2_XLARGE("m6id.2xlarge"),

    M6_ID_4_XLARGE("m6id.4xlarge"),

    M6_ID_8_XLARGE("m6id.8xlarge"),

    M6_ID_12_XLARGE("m6id.12xlarge"),

    M6_ID_16_XLARGE("m6id.16xlarge"),

    M6_ID_24_XLARGE("m6id.24xlarge"),

    M6_ID_32_XLARGE("m6id.32xlarge"),

    M6_IDN_LARGE("m6idn.large"),

    M6_IDN_XLARGE("m6idn.xlarge"),

    M6_IDN_2_XLARGE("m6idn.2xlarge"),

    M6_IDN_4_XLARGE("m6idn.4xlarge"),

    M6_IDN_8_XLARGE("m6idn.8xlarge"),

    M6_IDN_12_XLARGE("m6idn.12xlarge"),

    M6_IDN_16_XLARGE("m6idn.16xlarge"),

    M6_IDN_24_XLARGE("m6idn.24xlarge"),

    M6_IDN_32_XLARGE("m6idn.32xlarge"),

    M6_IN_LARGE("m6in.large"),

    M6_IN_XLARGE("m6in.xlarge"),

    M6_IN_2_XLARGE("m6in.2xlarge"),

    M6_IN_4_XLARGE("m6in.4xlarge"),

    M6_IN_8_XLARGE("m6in.8xlarge"),

    M6_IN_12_XLARGE("m6in.12xlarge"),

    M6_IN_16_XLARGE("m6in.16xlarge"),

    M6_IN_24_XLARGE("m6in.24xlarge"),

    M6_IN_32_XLARGE("m6in.32xlarge"),

    M8_G_MEDIUM("m8g.medium"),

    M8_G_LARGE("m8g.large"),

    M8_G_XLARGE("m8g.xlarge"),

    M8_G_2_XLARGE("m8g.2xlarge"),

    M8_G_4_XLARGE("m8g.4xlarge"),

    M8_G_8_XLARGE("m8g.8xlarge"),

    M8_G_12_XLARGE("m8g.12xlarge"),

    M8_G_16_XLARGE("m8g.16xlarge"),

    M8_G_24_XLARGE("m8g.24xlarge"),

    M8_G_48_XLARGE("m8g.48xlarge"),

    R5_DN_LARGE("r5dn.large"),

    R5_DN_XLARGE("r5dn.xlarge"),

    R5_DN_2_XLARGE("r5dn.2xlarge"),

    R5_DN_4_XLARGE("r5dn.4xlarge"),

    R5_DN_8_XLARGE("r5dn.8xlarge"),

    R5_DN_12_XLARGE("r5dn.12xlarge"),

    R5_DN_16_XLARGE("r5dn.16xlarge"),

    R5_DN_24_XLARGE("r5dn.24xlarge"),

    R5_N_LARGE("r5n.large"),

    R5_N_XLARGE("r5n.xlarge"),

    R5_N_2_XLARGE("r5n.2xlarge"),

    R5_N_4_XLARGE("r5n.4xlarge"),

    R5_N_8_XLARGE("r5n.8xlarge"),

    R5_N_12_XLARGE("r5n.12xlarge"),

    R5_N_16_XLARGE("r5n.16xlarge"),

    R5_N_24_XLARGE("r5n.24xlarge"),

    R6_A_LARGE("r6a.large"),

    R6_A_XLARGE("r6a.xlarge"),

    R6_A_2_XLARGE("r6a.2xlarge"),

    R6_A_4_XLARGE("r6a.4xlarge"),

    R6_A_8_XLARGE("r6a.8xlarge"),

    R6_A_12_XLARGE("r6a.12xlarge"),

    R6_A_16_XLARGE("r6a.16xlarge"),

    R6_A_24_XLARGE("r6a.24xlarge"),

    R6_A_32_XLARGE("r6a.32xlarge"),

    R6_A_48_XLARGE("r6a.48xlarge"),

    R6_ID_LARGE("r6id.large"),

    R6_ID_XLARGE("r6id.xlarge"),

    R6_ID_2_XLARGE("r6id.2xlarge"),

    R6_ID_4_XLARGE("r6id.4xlarge"),

    R6_ID_8_XLARGE("r6id.8xlarge"),

    R6_ID_12_XLARGE("r6id.12xlarge"),

    R6_ID_16_XLARGE("r6id.16xlarge"),

    R6_ID_24_XLARGE("r6id.24xlarge"),

    R6_ID_32_XLARGE("r6id.32xlarge"),

    R6_IDN_LARGE("r6idn.large"),

    R6_IDN_XLARGE("r6idn.xlarge"),

    R6_IDN_2_XLARGE("r6idn.2xlarge"),

    R6_IDN_4_XLARGE("r6idn.4xlarge"),

    R6_IDN_8_XLARGE("r6idn.8xlarge"),

    R6_IDN_12_XLARGE("r6idn.12xlarge"),

    R6_IDN_16_XLARGE("r6idn.16xlarge"),

    R6_IDN_24_XLARGE("r6idn.24xlarge"),

    R6_IDN_32_XLARGE("r6idn.32xlarge"),

    R6_IN_LARGE("r6in.large"),

    R6_IN_XLARGE("r6in.xlarge"),

    R6_IN_2_XLARGE("r6in.2xlarge"),

    R6_IN_4_XLARGE("r6in.4xlarge"),

    R6_IN_8_XLARGE("r6in.8xlarge"),

    R6_IN_12_XLARGE("r6in.12xlarge"),

    R6_IN_16_XLARGE("r6in.16xlarge"),

    R6_IN_24_XLARGE("r6in.24xlarge"),

    R6_IN_32_XLARGE("r6in.32xlarge"),

    R8_G_MEDIUM("r8g.medium"),

    R8_G_LARGE("r8g.large"),

    R8_G_XLARGE("r8g.xlarge"),

    R8_G_2_XLARGE("r8g.2xlarge"),

    R8_G_4_XLARGE("r8g.4xlarge"),

    R8_G_8_XLARGE("r8g.8xlarge"),

    R8_G_12_XLARGE("r8g.12xlarge"),

    R8_G_16_XLARGE("r8g.16xlarge"),

    R8_G_24_XLARGE("r8g.24xlarge"),

    R8_G_48_XLARGE("r8g.48xlarge"),

    M4_16_XLARGE("m4.16xlarge"),

    C6_A_32_XLARGE("c6a.32xlarge"),

    C6_A_48_XLARGE("c6a.48xlarge"),

    C6_I_32_XLARGE("c6i.32xlarge"),

    R6_I_24_XLARGE("r6i.24xlarge"),

    R6_I_32_XLARGE("r6i.32xlarge"),

    C6_IN_24_XLARGE("c6in.24xlarge"),

    C6_IN_32_XLARGE("c6in.32xlarge"),

    C7_A_24_XLARGE("c7a.24xlarge"),

    C7_A_32_XLARGE("c7a.32xlarge"),

    C7_A_48_XLARGE("c7a.48xlarge"),

    C7_I_24_XLARGE("c7i.24xlarge"),

    C7_I_48_XLARGE("c7i.48xlarge"),

    M6_A_24_XLARGE("m6a.24xlarge"),

    M6_A_32_XLARGE("m6a.32xlarge"),

    M6_A_48_XLARGE("m6a.48xlarge"),

    M6_I_24_XLARGE("m6i.24xlarge"),

    M6_I_32_XLARGE("m6i.32xlarge"),

    M7_A_24_XLARGE("m7a.24xlarge"),

    M7_A_32_XLARGE("m7a.32xlarge"),

    M7_A_48_XLARGE("m7a.48xlarge"),

    M7_I_24_XLARGE("m7i.24xlarge"),

    M7_I_48_XLARGE("m7i.48xlarge"),

    R7_A_24_XLARGE("r7a.24xlarge"),

    R7_A_32_XLARGE("r7a.32xlarge"),

    R7_A_48_XLARGE("r7a.48xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EC2InstanceType> VALUE_MAP = EnumUtils.uniqueIndex(EC2InstanceType.class,
            EC2InstanceType::toString);

    private final String value;

    private EC2InstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EC2InstanceType corresponding to the value
     */
    public static EC2InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EC2InstanceType}s
     */
    public static Set<EC2InstanceType> knownValues() {
        Set<EC2InstanceType> knownValues = EnumSet.allOf(EC2InstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
