/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMatchmakingRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeMatchmakingRequest.Builder, DescribeMatchmakingRequest> {
    private static final SdkField<List<String>> TICKET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TicketIds")
            .getter(getter(DescribeMatchmakingRequest::ticketIds))
            .setter(setter(Builder::ticketIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> ticketIds;

    private DescribeMatchmakingRequest(BuilderImpl builder) {
        super(builder);
        this.ticketIds = builder.ticketIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the TicketIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTicketIds() {
        return ticketIds != null && !(ticketIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTicketIds} method.
     * </p>
     * 
     * @return A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
     */
    public final List<String> ticketIds() {
        return ticketIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTicketIds() ? ticketIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingRequest)) {
            return false;
        }
        DescribeMatchmakingRequest other = (DescribeMatchmakingRequest) obj;
        return hasTicketIds() == other.hasTicketIds() && Objects.equals(ticketIds(), other.ticketIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMatchmakingRequest").add("TicketIds", hasTicketIds() ? ticketIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketIds":
            return Optional.ofNullable(clazz.cast(ticketIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TicketIds", TICKET_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingRequest, T> g) {
        return obj -> g.apply((DescribeMatchmakingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMatchmakingRequest> {
        /**
         * <p>
         * A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
         * </p>
         * 
         * @param ticketIds
         *        A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketIds(Collection<String> ticketIds);

        /**
         * <p>
         * A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
         * </p>
         * 
         * @param ticketIds
         *        A unique identifier for a matchmaking ticket. You can include up to 10 ID values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketIds(String... ticketIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private List<String> ticketIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingRequest model) {
            super(model);
            ticketIds(model.ticketIds);
        }

        public final Collection<String> getTicketIds() {
            if (ticketIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ticketIds;
        }

        public final void setTicketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
        }

        @Override
        public final Builder ticketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketIds(String... ticketIds) {
            ticketIds(Arrays.asList(ticketIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMatchmakingRequest build() {
            return new DescribeMatchmakingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
