/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetLocationCapacityResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetLocationCapacityResponse.Builder, DescribeFleetLocationCapacityResponse> {
    private static final SdkField<FleetCapacity> FLEET_CAPACITY_FIELD = SdkField
            .<FleetCapacity> builder(MarshallingType.SDK_POJO).memberName("FleetCapacity")
            .getter(getter(DescribeFleetLocationCapacityResponse::fleetCapacity)).setter(setter(Builder::fleetCapacity))
            .constructor(FleetCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FleetCapacity fleetCapacity;

    private DescribeFleetLocationCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.fleetCapacity = builder.fleetCapacity;
    }

    /**
     * <p>
     * Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and
     * locations that currently exist. Changes in desired instance value can take up to 1 minute to be reflected.
     * </p>
     * 
     * @return Resource capacity information for the requested fleet location. Capacity objects are returned only for
     *         fleets and locations that currently exist. Changes in desired instance value can take up to 1 minute to
     *         be reflected.
     */
    public final FleetCapacity fleetCapacity() {
        return fleetCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetLocationCapacityResponse)) {
            return false;
        }
        DescribeFleetLocationCapacityResponse other = (DescribeFleetLocationCapacityResponse) obj;
        return Objects.equals(fleetCapacity(), other.fleetCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetLocationCapacityResponse").add("FleetCapacity", fleetCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetCapacity":
            return Optional.ofNullable(clazz.cast(fleetCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetCapacity", FLEET_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetLocationCapacityResponse, T> g) {
        return obj -> g.apply((DescribeFleetLocationCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetLocationCapacityResponse> {
        /**
         * <p>
         * Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets
         * and locations that currently exist. Changes in desired instance value can take up to 1 minute to be
         * reflected.
         * </p>
         * 
         * @param fleetCapacity
         *        Resource capacity information for the requested fleet location. Capacity objects are returned only for
         *        fleets and locations that currently exist. Changes in desired instance value can take up to 1 minute
         *        to be reflected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetCapacity(FleetCapacity fleetCapacity);

        /**
         * <p>
         * Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets
         * and locations that currently exist. Changes in desired instance value can take up to 1 minute to be
         * reflected.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetCapacity.Builder} avoiding the need
         * to create one manually via {@link FleetCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetCapacity(FleetCapacity)}.
         * 
         * @param fleetCapacity
         *        a consumer that will call methods on {@link FleetCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetCapacity(FleetCapacity)
         */
        default Builder fleetCapacity(Consumer<FleetCapacity.Builder> fleetCapacity) {
            return fleetCapacity(FleetCapacity.builder().applyMutation(fleetCapacity).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private FleetCapacity fleetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetLocationCapacityResponse model) {
            super(model);
            fleetCapacity(model.fleetCapacity);
        }

        public final FleetCapacity.Builder getFleetCapacity() {
            return fleetCapacity != null ? fleetCapacity.toBuilder() : null;
        }

        public final void setFleetCapacity(FleetCapacity.BuilderImpl fleetCapacity) {
            this.fleetCapacity = fleetCapacity != null ? fleetCapacity.build() : null;
        }

        @Override
        public final Builder fleetCapacity(FleetCapacity fleetCapacity) {
            this.fleetCapacity = fleetCapacity;
            return this;
        }

        @Override
        public DescribeFleetLocationCapacityResponse build() {
            return new DescribeFleetLocationCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
