/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteContainerGroupDefinitionRequest extends GameLiftRequest implements
        ToCopyableBuilder<DeleteContainerGroupDefinitionRequest.Builder, DeleteContainerGroupDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DeleteContainerGroupDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionNumber").getter(getter(DeleteContainerGroupDefinitionRequest::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<Integer> VERSION_COUNT_TO_RETAIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionCountToRetain").getter(getter(DeleteContainerGroupDefinitionRequest::versionCountToRetain))
            .setter(setter(Builder::versionCountToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCountToRetain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VERSION_NUMBER_FIELD, VERSION_COUNT_TO_RETAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer versionNumber;

    private final Integer versionCountToRetain;

    private DeleteContainerGroupDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionNumber = builder.versionNumber;
        this.versionCountToRetain = builder.versionCountToRetain;
    }

    /**
     * <p>
     * The unique identifier for the container group definition to delete. You can use either the <code>Name</code> or
     * <code>ARN</code> value.
     * </p>
     * 
     * @return The unique identifier for the container group definition to delete. You can use either the
     *         <code>Name</code> or <code>ARN</code> value.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The specific version to delete.
     * </p>
     * 
     * @return The specific version to delete.
     */
    public final Integer versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The number of most recent versions to keep while deleting all older versions.
     * </p>
     * 
     * @return The number of most recent versions to keep while deleting all older versions.
     */
    public final Integer versionCountToRetain() {
        return versionCountToRetain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(versionCountToRetain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteContainerGroupDefinitionRequest)) {
            return false;
        }
        DeleteContainerGroupDefinitionRequest other = (DeleteContainerGroupDefinitionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(versionCountToRetain(), other.versionCountToRetain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteContainerGroupDefinitionRequest").add("Name", name())
                .add("VersionNumber", versionNumber()).add("VersionCountToRetain", versionCountToRetain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "VersionCountToRetain":
            return Optional.ofNullable(clazz.cast(versionCountToRetain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("VersionCountToRetain", VERSION_COUNT_TO_RETAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteContainerGroupDefinitionRequest, T> g) {
        return obj -> g.apply((DeleteContainerGroupDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteContainerGroupDefinitionRequest> {
        /**
         * <p>
         * The unique identifier for the container group definition to delete. You can use either the <code>Name</code>
         * or <code>ARN</code> value.
         * </p>
         * 
         * @param name
         *        The unique identifier for the container group definition to delete. You can use either the
         *        <code>Name</code> or <code>ARN</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The specific version to delete.
         * </p>
         * 
         * @param versionNumber
         *        The specific version to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Integer versionNumber);

        /**
         * <p>
         * The number of most recent versions to keep while deleting all older versions.
         * </p>
         * 
         * @param versionCountToRetain
         *        The number of most recent versions to keep while deleting all older versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCountToRetain(Integer versionCountToRetain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private Integer versionNumber;

        private Integer versionCountToRetain;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteContainerGroupDefinitionRequest model) {
            super(model);
            name(model.name);
            versionNumber(model.versionNumber);
            versionCountToRetain(model.versionCountToRetain);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Integer getVersionCountToRetain() {
            return versionCountToRetain;
        }

        public final void setVersionCountToRetain(Integer versionCountToRetain) {
            this.versionCountToRetain = versionCountToRetain;
        }

        @Override
        public final Builder versionCountToRetain(Integer versionCountToRetain) {
            this.versionCountToRetain = versionCountToRetain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteContainerGroupDefinitionRequest build() {
            return new DeleteContainerGroupDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
