/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has the following endpoints that are used to access data
 * or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SvmEndpoints implements SdkPojo, Serializable, ToCopyableBuilder<SvmEndpoints.Builder, SvmEndpoints> {
    private static final SdkField<SvmEndpoint> ISCSI_FIELD = SdkField.<SvmEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Iscsi").getter(getter(SvmEndpoints::iscsi)).setter(setter(Builder::iscsi))
            .constructor(SvmEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iscsi").build()).build();

    private static final SdkField<SvmEndpoint> MANAGEMENT_FIELD = SdkField.<SvmEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Management").getter(getter(SvmEndpoints::management)).setter(setter(Builder::management))
            .constructor(SvmEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Management").build()).build();

    private static final SdkField<SvmEndpoint> NFS_FIELD = SdkField.<SvmEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Nfs").getter(getter(SvmEndpoints::nfs)).setter(setter(Builder::nfs)).constructor(SvmEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nfs").build()).build();

    private static final SdkField<SvmEndpoint> SMB_FIELD = SdkField.<SvmEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Smb").getter(getter(SvmEndpoints::smb)).setter(setter(Builder::smb)).constructor(SvmEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Smb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISCSI_FIELD, MANAGEMENT_FIELD,
            NFS_FIELD, SMB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SvmEndpoint iscsi;

    private final SvmEndpoint management;

    private final SvmEndpoint nfs;

    private final SvmEndpoint smb;

    private SvmEndpoints(BuilderImpl builder) {
        this.iscsi = builder.iscsi;
        this.management = builder.management;
        this.nfs = builder.nfs;
        this.smb = builder.smb;
    }

    /**
     * <p>
     * An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.
     * </p>
     * 
     * @return An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.
     */
    public final SvmEndpoint iscsi() {
        return iscsi;
    }

    /**
     * <p>
     * An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.
     * </p>
     * 
     * @return An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.
     */
    public final SvmEndpoint management() {
        return management;
    }

    /**
     * <p>
     * An endpoint for connecting using the Network File System (NFS) protocol.
     * </p>
     * 
     * @return An endpoint for connecting using the Network File System (NFS) protocol.
     */
    public final SvmEndpoint nfs() {
        return nfs;
    }

    /**
     * <p>
     * An endpoint for connecting using the Server Message Block (SMB) protocol.
     * </p>
     * 
     * @return An endpoint for connecting using the Server Message Block (SMB) protocol.
     */
    public final SvmEndpoint smb() {
        return smb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iscsi());
        hashCode = 31 * hashCode + Objects.hashCode(management());
        hashCode = 31 * hashCode + Objects.hashCode(nfs());
        hashCode = 31 * hashCode + Objects.hashCode(smb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SvmEndpoints)) {
            return false;
        }
        SvmEndpoints other = (SvmEndpoints) obj;
        return Objects.equals(iscsi(), other.iscsi()) && Objects.equals(management(), other.management())
                && Objects.equals(nfs(), other.nfs()) && Objects.equals(smb(), other.smb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SvmEndpoints").add("Iscsi", iscsi()).add("Management", management()).add("Nfs", nfs())
                .add("Smb", smb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Iscsi":
            return Optional.ofNullable(clazz.cast(iscsi()));
        case "Management":
            return Optional.ofNullable(clazz.cast(management()));
        case "Nfs":
            return Optional.ofNullable(clazz.cast(nfs()));
        case "Smb":
            return Optional.ofNullable(clazz.cast(smb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Iscsi", ISCSI_FIELD);
        map.put("Management", MANAGEMENT_FIELD);
        map.put("Nfs", NFS_FIELD);
        map.put("Smb", SMB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SvmEndpoints, T> g) {
        return obj -> g.apply((SvmEndpoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SvmEndpoints> {
        /**
         * <p>
         * An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.
         * </p>
         * 
         * @param iscsi
         *        An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iscsi(SvmEndpoint iscsi);

        /**
         * <p>
         * An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link SvmEndpoint.Builder} avoiding the need to
         * create one manually via {@link SvmEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SvmEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #iscsi(SvmEndpoint)}.
         * 
         * @param iscsi
         *        a consumer that will call methods on {@link SvmEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iscsi(SvmEndpoint)
         */
        default Builder iscsi(Consumer<SvmEndpoint.Builder> iscsi) {
            return iscsi(SvmEndpoint.builder().applyMutation(iscsi).build());
        }

        /**
         * <p>
         * An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.
         * </p>
         * 
         * @param management
         *        An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder management(SvmEndpoint management);

        /**
         * <p>
         * An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.
         * </p>
         * This is a convenience method that creates an instance of the {@link SvmEndpoint.Builder} avoiding the need to
         * create one manually via {@link SvmEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SvmEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #management(SvmEndpoint)}.
         * 
         * @param management
         *        a consumer that will call methods on {@link SvmEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #management(SvmEndpoint)
         */
        default Builder management(Consumer<SvmEndpoint.Builder> management) {
            return management(SvmEndpoint.builder().applyMutation(management).build());
        }

        /**
         * <p>
         * An endpoint for connecting using the Network File System (NFS) protocol.
         * </p>
         * 
         * @param nfs
         *        An endpoint for connecting using the Network File System (NFS) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfs(SvmEndpoint nfs);

        /**
         * <p>
         * An endpoint for connecting using the Network File System (NFS) protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link SvmEndpoint.Builder} avoiding the need to
         * create one manually via {@link SvmEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SvmEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #nfs(SvmEndpoint)}.
         * 
         * @param nfs
         *        a consumer that will call methods on {@link SvmEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfs(SvmEndpoint)
         */
        default Builder nfs(Consumer<SvmEndpoint.Builder> nfs) {
            return nfs(SvmEndpoint.builder().applyMutation(nfs).build());
        }

        /**
         * <p>
         * An endpoint for connecting using the Server Message Block (SMB) protocol.
         * </p>
         * 
         * @param smb
         *        An endpoint for connecting using the Server Message Block (SMB) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smb(SvmEndpoint smb);

        /**
         * <p>
         * An endpoint for connecting using the Server Message Block (SMB) protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link SvmEndpoint.Builder} avoiding the need to
         * create one manually via {@link SvmEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SvmEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #smb(SvmEndpoint)}.
         * 
         * @param smb
         *        a consumer that will call methods on {@link SvmEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smb(SvmEndpoint)
         */
        default Builder smb(Consumer<SvmEndpoint.Builder> smb) {
            return smb(SvmEndpoint.builder().applyMutation(smb).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SvmEndpoint iscsi;

        private SvmEndpoint management;

        private SvmEndpoint nfs;

        private SvmEndpoint smb;

        private BuilderImpl() {
        }

        private BuilderImpl(SvmEndpoints model) {
            iscsi(model.iscsi);
            management(model.management);
            nfs(model.nfs);
            smb(model.smb);
        }

        public final SvmEndpoint.Builder getIscsi() {
            return iscsi != null ? iscsi.toBuilder() : null;
        }

        public final void setIscsi(SvmEndpoint.BuilderImpl iscsi) {
            this.iscsi = iscsi != null ? iscsi.build() : null;
        }

        @Override
        public final Builder iscsi(SvmEndpoint iscsi) {
            this.iscsi = iscsi;
            return this;
        }

        public final SvmEndpoint.Builder getManagement() {
            return management != null ? management.toBuilder() : null;
        }

        public final void setManagement(SvmEndpoint.BuilderImpl management) {
            this.management = management != null ? management.build() : null;
        }

        @Override
        public final Builder management(SvmEndpoint management) {
            this.management = management;
            return this;
        }

        public final SvmEndpoint.Builder getNfs() {
            return nfs != null ? nfs.toBuilder() : null;
        }

        public final void setNfs(SvmEndpoint.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(SvmEndpoint nfs) {
            this.nfs = nfs;
            return this;
        }

        public final SvmEndpoint.Builder getSmb() {
            return smb != null ? smb.toBuilder() : null;
        }

        public final void setSmb(SvmEndpoint.BuilderImpl smb) {
            this.smb = smb != null ? smb.build() : null;
        }

        @Override
        public final Builder smb(SvmEndpoint smb) {
            this.smb = smb;
            return this;
        }

        @Override
        public SvmEndpoints build() {
            return new SvmEndpoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
