/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to set the retention period of an FSx for ONTAP SnapLock volume. The retention period includes
 * default, maximum, and minimum settings. For more information, see <a
 * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html">Working with the retention period in
 * SnapLock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnaplockRetentionPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<SnaplockRetentionPeriod.Builder, SnaplockRetentionPeriod> {
    private static final SdkField<RetentionPeriod> DEFAULT_RETENTION_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("DefaultRetention")
            .getter(getter(SnaplockRetentionPeriod::defaultRetention)).setter(setter(Builder::defaultRetention))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRetention").build()).build();

    private static final SdkField<RetentionPeriod> MINIMUM_RETENTION_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("MinimumRetention")
            .getter(getter(SnaplockRetentionPeriod::minimumRetention)).setter(setter(Builder::minimumRetention))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumRetention").build()).build();

    private static final SdkField<RetentionPeriod> MAXIMUM_RETENTION_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("MaximumRetention")
            .getter(getter(SnaplockRetentionPeriod::maximumRetention)).setter(setter(Builder::maximumRetention))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetention").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RETENTION_FIELD,
            MINIMUM_RETENTION_FIELD, MAXIMUM_RETENTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RetentionPeriod defaultRetention;

    private final RetentionPeriod minimumRetention;

    private final RetentionPeriod maximumRetention;

    private SnaplockRetentionPeriod(BuilderImpl builder) {
        this.defaultRetention = builder.defaultRetention;
        this.minimumRetention = builder.minimumRetention;
        this.maximumRetention = builder.maximumRetention;
    }

    /**
     * <p>
     * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period
     * is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to
     * the minimum retention period and less than or equal to the maximum retention period.
     * </p>
     * 
     * @return The retention period assigned to a write once, read many (WORM) file by default if an explicit retention
     *         period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than
     *         or equal to the minimum retention period and less than or equal to the maximum retention period.
     */
    public final RetentionPeriod defaultRetention() {
        return defaultRetention;
    }

    /**
     * <p>
     * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     * </p>
     * 
     * @return The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     */
    public final RetentionPeriod minimumRetention() {
        return minimumRetention;
    }

    /**
     * <p>
     * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     * </p>
     * 
     * @return The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     */
    public final RetentionPeriod maximumRetention() {
        return maximumRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultRetention());
        hashCode = 31 * hashCode + Objects.hashCode(minimumRetention());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnaplockRetentionPeriod)) {
            return false;
        }
        SnaplockRetentionPeriod other = (SnaplockRetentionPeriod) obj;
        return Objects.equals(defaultRetention(), other.defaultRetention())
                && Objects.equals(minimumRetention(), other.minimumRetention())
                && Objects.equals(maximumRetention(), other.maximumRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnaplockRetentionPeriod").add("DefaultRetention", defaultRetention())
                .add("MinimumRetention", minimumRetention()).add("MaximumRetention", maximumRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultRetention":
            return Optional.ofNullable(clazz.cast(defaultRetention()));
        case "MinimumRetention":
            return Optional.ofNullable(clazz.cast(minimumRetention()));
        case "MaximumRetention":
            return Optional.ofNullable(clazz.cast(maximumRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultRetention", DEFAULT_RETENTION_FIELD);
        map.put("MinimumRetention", MINIMUM_RETENTION_FIELD);
        map.put("MaximumRetention", MAXIMUM_RETENTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnaplockRetentionPeriod, T> g) {
        return obj -> g.apply((SnaplockRetentionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnaplockRetentionPeriod> {
        /**
         * <p>
         * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention
         * period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or
         * equal to the minimum retention period and less than or equal to the maximum retention period.
         * </p>
         * 
         * @param defaultRetention
         *        The retention period assigned to a write once, read many (WORM) file by default if an explicit
         *        retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be
         *        greater than or equal to the minimum retention period and less than or equal to the maximum retention
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRetention(RetentionPeriod defaultRetention);

        /**
         * <p>
         * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention
         * period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or
         * equal to the minimum retention period and less than or equal to the maximum retention period.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultRetention(RetentionPeriod)}.
         * 
         * @param defaultRetention
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRetention(RetentionPeriod)
         */
        default Builder defaultRetention(Consumer<RetentionPeriod.Builder> defaultRetention) {
            return defaultRetention(RetentionPeriod.builder().applyMutation(defaultRetention).build());
        }

        /**
         * <p>
         * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * </p>
         * 
         * @param minimumRetention
         *        The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumRetention(RetentionPeriod minimumRetention);

        /**
         * <p>
         * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #minimumRetention(RetentionPeriod)}.
         * 
         * @param minimumRetention
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumRetention(RetentionPeriod)
         */
        default Builder minimumRetention(Consumer<RetentionPeriod.Builder> minimumRetention) {
            return minimumRetention(RetentionPeriod.builder().applyMutation(minimumRetention).build());
        }

        /**
         * <p>
         * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * </p>
         * 
         * @param maximumRetention
         *        The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetention(RetentionPeriod maximumRetention);

        /**
         * <p>
         * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumRetention(RetentionPeriod)}.
         * 
         * @param maximumRetention
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumRetention(RetentionPeriod)
         */
        default Builder maximumRetention(Consumer<RetentionPeriod.Builder> maximumRetention) {
            return maximumRetention(RetentionPeriod.builder().applyMutation(maximumRetention).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetentionPeriod defaultRetention;

        private RetentionPeriod minimumRetention;

        private RetentionPeriod maximumRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(SnaplockRetentionPeriod model) {
            defaultRetention(model.defaultRetention);
            minimumRetention(model.minimumRetention);
            maximumRetention(model.maximumRetention);
        }

        public final RetentionPeriod.Builder getDefaultRetention() {
            return defaultRetention != null ? defaultRetention.toBuilder() : null;
        }

        public final void setDefaultRetention(RetentionPeriod.BuilderImpl defaultRetention) {
            this.defaultRetention = defaultRetention != null ? defaultRetention.build() : null;
        }

        @Override
        public final Builder defaultRetention(RetentionPeriod defaultRetention) {
            this.defaultRetention = defaultRetention;
            return this;
        }

        public final RetentionPeriod.Builder getMinimumRetention() {
            return minimumRetention != null ? minimumRetention.toBuilder() : null;
        }

        public final void setMinimumRetention(RetentionPeriod.BuilderImpl minimumRetention) {
            this.minimumRetention = minimumRetention != null ? minimumRetention.build() : null;
        }

        @Override
        public final Builder minimumRetention(RetentionPeriod minimumRetention) {
            this.minimumRetention = minimumRetention;
            return this;
        }

        public final RetentionPeriod.Builder getMaximumRetention() {
            return maximumRetention != null ? maximumRetention.toBuilder() : null;
        }

        public final void setMaximumRetention(RetentionPeriod.BuilderImpl maximumRetention) {
            this.maximumRetention = maximumRetention != null ? maximumRetention.build() : null;
        }

        @Override
        public final Builder maximumRetention(RetentionPeriod maximumRetention) {
            this.maximumRetention = maximumRetention;
            return this;
        }

        @Override
        public SnaplockRetentionPeriod build() {
            return new SnaplockRetentionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
