/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeS3AccessPointAttachmentsResponse extends FSxResponse implements
        ToCopyableBuilder<DescribeS3AccessPointAttachmentsResponse.Builder, DescribeS3AccessPointAttachmentsResponse> {
    private static final SdkField<List<S3AccessPointAttachment>> S3_ACCESS_POINT_ATTACHMENTS_FIELD = SdkField
            .<List<S3AccessPointAttachment>> builder(MarshallingType.LIST)
            .memberName("S3AccessPointAttachments")
            .getter(getter(DescribeS3AccessPointAttachmentsResponse::s3AccessPointAttachments))
            .setter(setter(Builder::s3AccessPointAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPointAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3AccessPointAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3AccessPointAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeS3AccessPointAttachmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            S3_ACCESS_POINT_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<S3AccessPointAttachment> s3AccessPointAttachments;

    private final String nextToken;

    private DescribeS3AccessPointAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointAttachments = builder.s3AccessPointAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3AccessPointAttachments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasS3AccessPointAttachments() {
        return s3AccessPointAttachments != null && !(s3AccessPointAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of S3 access point attachments returned after a successful <code>DescribeS3AccessPointAttachments</code>
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3AccessPointAttachments} method.
     * </p>
     * 
     * @return Array of S3 access point attachments returned after a successful
     *         <code>DescribeS3AccessPointAttachments</code> operation.
     */
    public final List<S3AccessPointAttachment> s3AccessPointAttachments() {
        return s3AccessPointAttachments;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasS3AccessPointAttachments() ? s3AccessPointAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeS3AccessPointAttachmentsResponse)) {
            return false;
        }
        DescribeS3AccessPointAttachmentsResponse other = (DescribeS3AccessPointAttachmentsResponse) obj;
        return hasS3AccessPointAttachments() == other.hasS3AccessPointAttachments()
                && Objects.equals(s3AccessPointAttachments(), other.s3AccessPointAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeS3AccessPointAttachmentsResponse")
                .add("S3AccessPointAttachments", hasS3AccessPointAttachments() ? s3AccessPointAttachments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3AccessPointAttachments":
            return Optional.ofNullable(clazz.cast(s3AccessPointAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3AccessPointAttachments", S3_ACCESS_POINT_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeS3AccessPointAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeS3AccessPointAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeS3AccessPointAttachmentsResponse> {
        /**
         * <p>
         * Array of S3 access point attachments returned after a successful
         * <code>DescribeS3AccessPointAttachments</code> operation.
         * </p>
         * 
         * @param s3AccessPointAttachments
         *        Array of S3 access point attachments returned after a successful
         *        <code>DescribeS3AccessPointAttachments</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointAttachments(Collection<S3AccessPointAttachment> s3AccessPointAttachments);

        /**
         * <p>
         * Array of S3 access point attachments returned after a successful
         * <code>DescribeS3AccessPointAttachments</code> operation.
         * </p>
         * 
         * @param s3AccessPointAttachments
         *        Array of S3 access point attachments returned after a successful
         *        <code>DescribeS3AccessPointAttachments</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointAttachments(S3AccessPointAttachment... s3AccessPointAttachments);

        /**
         * <p>
         * Array of S3 access point attachments returned after a successful
         * <code>DescribeS3AccessPointAttachments</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #s3AccessPointAttachments(List<S3AccessPointAttachment>)}.
         * 
         * @param s3AccessPointAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessPointAttachments(java.util.Collection<S3AccessPointAttachment>)
         */
        Builder s3AccessPointAttachments(Consumer<S3AccessPointAttachment.Builder>... s3AccessPointAttachments);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<S3AccessPointAttachment> s3AccessPointAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeS3AccessPointAttachmentsResponse model) {
            super(model);
            s3AccessPointAttachments(model.s3AccessPointAttachments);
            nextToken(model.nextToken);
        }

        public final List<S3AccessPointAttachment.Builder> getS3AccessPointAttachments() {
            List<S3AccessPointAttachment.Builder> result = S3AccessPointAttachmentsCopier
                    .copyToBuilder(this.s3AccessPointAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3AccessPointAttachments(Collection<S3AccessPointAttachment.BuilderImpl> s3AccessPointAttachments) {
            this.s3AccessPointAttachments = S3AccessPointAttachmentsCopier.copyFromBuilder(s3AccessPointAttachments);
        }

        @Override
        public final Builder s3AccessPointAttachments(Collection<S3AccessPointAttachment> s3AccessPointAttachments) {
            this.s3AccessPointAttachments = S3AccessPointAttachmentsCopier.copy(s3AccessPointAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessPointAttachments(S3AccessPointAttachment... s3AccessPointAttachments) {
            s3AccessPointAttachments(Arrays.asList(s3AccessPointAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessPointAttachments(Consumer<S3AccessPointAttachment.Builder>... s3AccessPointAttachments) {
            s3AccessPointAttachments(Stream.of(s3AccessPointAttachments)
                    .map(c -> S3AccessPointAttachment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeS3AccessPointAttachmentsResponse build() {
            return new DescribeS3AccessPointAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
