/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can manage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionScope implements SdkPojo, Serializable, ToCopyableBuilder<RegionScope.Builder, RegionScope> {
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(RegionScope::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_REGIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllRegionsEnabled").getter(getter(RegionScope::allRegionsEnabled))
            .setter(setter(Builder::allRegionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllRegionsEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD,
            ALL_REGIONS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> regions;

    private final Boolean allRegionsEnabled;

    private RegionScope(BuilderImpl builder) {
        this.regions = builder.regions;
        this.allRegionsEnabled = builder.allRegionsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * Allows the specified Firewall Manager administrator to manage all Amazon Web Services Regions.
     * </p>
     * 
     * @return Allows the specified Firewall Manager administrator to manage all Amazon Web Services Regions.
     */
    public final Boolean allRegionsEnabled() {
        return allRegionsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allRegionsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionScope)) {
            return false;
        }
        RegionScope other = (RegionScope) obj;
        return hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(allRegionsEnabled(), other.allRegionsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionScope").add("Regions", hasRegions() ? regions() : null)
                .add("AllRegionsEnabled", allRegionsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "AllRegionsEnabled":
            return Optional.ofNullable(clazz.cast(allRegionsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Regions", REGIONS_FIELD);
        map.put("AllRegionsEnabled", ALL_REGIONS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionScope, T> g) {
        return obj -> g.apply((RegionScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionScope> {
        /**
         * <p>
         * The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * Allows the specified Firewall Manager administrator to manage all Amazon Web Services Regions.
         * </p>
         * 
         * @param allRegionsEnabled
         *        Allows the specified Firewall Manager administrator to manage all Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allRegionsEnabled(Boolean allRegionsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private Boolean allRegionsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionScope model) {
            regions(model.regions);
            allRegionsEnabled(model.allRegionsEnabled);
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = AWSRegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = AWSRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Boolean getAllRegionsEnabled() {
            return allRegionsEnabled;
        }

        public final void setAllRegionsEnabled(Boolean allRegionsEnabled) {
            this.allRegionsEnabled = allRegionsEnabled;
        }

        @Override
        public final Builder allRegionsEnabled(Boolean allRegionsEnabled) {
            this.allRegionsEnabled = allRegionsEnabled;
            return this;
        }

        @Override
        public RegionScope build() {
            return new RegionScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
